/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.xml.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.gvsig.gpe.lib.impl.parser.GPEParser;
import org.gvsig.gpe.prov.xml.exceptions.GPEXmlEmptyFileException;
import org.gvsig.xmlpull.lib.api.XmlPullLocator;
import org.gvsig.xmlpull.lib.api.XmlPullManager;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GPEXmlParser
extends GPEParser {
    private static final Logger logger = LoggerFactory.getLogger(GPEXmlParser.class);
    private IXmlStreamReader parser = null;

    protected void parseStream() {
        try {
            this.parser = this.getXmlReader();
            if (this.getGpeManager().getBooleanProperty("xmlSchemaValidated")) {
                // empty if block
            }
            this.initParse();
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (GPEXmlEmptyFileException e) {
            this.getErrorHandler().addError((Throwable)((Object)e));
        }
    }

    private IXmlStreamReader getXmlReader() throws XmlStreamException {
        IXmlStreamReader reader;
        PushbackInputStream pushBackStream = new PushbackInputStream(this.getInputStream(), 200);
        try {
            int firstByte = pushBackStream.read();
            pushBackStream.unread(firstByte);
            XmlPullManager xmlManager = XmlPullLocator.getXMLManager();
            if (1 == firstByte) {
                reader = xmlManager.createStreamReader("text/x-bxml", (InputStream)pushBackStream);
            } else {
                this.fixDocDeclaration(pushBackStream);
                reader = xmlManager.createStreamReader("text/xml", (InputStream)pushBackStream);
            }
        }
        catch (IOException e) {
            throw new XmlStreamException((Throwable)e);
        }
        return reader;
    }

    private void fixDocDeclaration(PushbackInputStream pbis) {
        byte[] head = new byte[50];
        try {
            pbis.read(head);
        }
        catch (IOException e) {
            return;
        }
        String str = new String(head);
        try {
            pbis.unread(head);
            if (!str.trim().toLowerCase().startsWith("<?xml")) {
                String docdec = "<?xml ?>\n";
                pbis.unread(docdec.getBytes());
                logger.info("Fixing XML head (inserting: <?xml ?>)");
            }
        }
        catch (IOException e) {
            logger.info("Unable to unread stream. XML file will not be parsed.", (Throwable)e);
        }
    }

    protected void parseURI() {
        try {
            File file = new File(this.getMainFile());
            InputStream inputStream = this.createInputStream(file);
            this.setInputStream(inputStream);
            this.parseStream();
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR: Fichero " + this.getMainFile().getPath() + " no encontrado");
            this.getErrorHandler().addError((Throwable)e);
        }
        catch (IOException e) {
            System.out.println("ERROR: No se puede leer/escribir la codificaci\u00f3n del fichero: " + e.getMessage());
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    protected abstract InputStream createInputStream(File var1) throws FileNotFoundException;

    protected abstract void initParse() throws GPEXmlEmptyFileException, XmlStreamException;

    protected IXmlStreamReader getParser() {
        return this.parser;
    }
}

