/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.geotools.xml.XPathFactory;
import org.opengis.catalog.MetadataEntity;

public abstract class AbstractMetadataEntity
implements MetadataEntity {
    static /* synthetic */ Class class$org$geotools$catalog$AbstractMetadataEntity;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opengis$catalog$MetadataEntity;

    public final List elements() {
        EntityImpl type = (EntityImpl)this.getEntityType();
        ArrayList<Object> elements = new ArrayList<Object>(type.getElements().size());
        List methods = type.getGetMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Method method = (Method)iter.next();
            try {
                elements.add(method.invoke((Object)this, (Object[])null));
            }
            catch (Exception e) {
                throw new RuntimeException("There must be a bug in the EntityImpl class during the introspection.", e);
            }
        }
        return elements;
    }

    public final Object getElement(String xpath) {
        List elements = XPathFactory.value(xpath, this);
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        return elements;
    }

    public Object getElement(MetadataEntity.Element element) {
        ElementImpl elemImpl = element instanceof ElementImpl ? (ElementImpl)element : (ElementImpl)this.getEntityType().getElement(element.getName());
        return this.invoke(elemImpl.getGetMethod());
    }

    private Object invoke(Method m) {
        try {
            return m.invoke((Object)this, (Object[])null);
        }
        catch (Exception e) {
            System.out.println(this.getClass().getName() + " could not invoke " + m.getDeclaringClass().getName() + " " + m.getName());
            throw new RuntimeException("Cannot access metadata for " + m.getName() + ": " + e, e);
        }
    }

    public MetadataEntity.EntityType getEntityType() {
        return EntityImpl.getEntity(this.getClass());
    }

    private static class ElementImpl
    implements MetadataEntity.Element {
        private Method getMethod;
        private Class type;
        private String name;
        private boolean nillable;
        private MetadataEntity.EntityType entity;

        public ElementImpl(Class elementClass, Method method) {
            this.getMethod = method;
            this.type = elementClass;
            this.name = method.getName();
            if (this.name.startsWith("get")) {
                this.name = this.name.substring(3);
            } else if (this.name.startsWith("is")) {
                this.name = this.name.substring(2);
            }
            this.name = Introspector.decapitalize(this.name);
            if ((class$org$opengis$catalog$MetadataEntity == null ? (class$org$opengis$catalog$MetadataEntity = AbstractMetadataEntity.class$("org.opengis.catalog.MetadataEntity")) : class$org$opengis$catalog$MetadataEntity).isAssignableFrom(elementClass)) {
                this.entity = EntityImpl.getEntity(elementClass);
            }
        }

        public Method getGetMethod() {
            return this.getMethod;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean isNillable() {
            return false;
        }

        public boolean isMetadataEntity() {
            return this.entity != null;
        }

        public MetadataEntity.EntityType getEntityType() {
            return this.entity;
        }
    }

    private static class EntityImpl
    implements MetadataEntity.EntityType {
        static HashMap entityMap = new HashMap();
        ArrayList elemList = new ArrayList();
        HashMap elemMap = new HashMap();
        List getMethods;

        private EntityImpl(Class clazz) {
            this.init(clazz);
        }

        public static EntityImpl getEntity(Class clazz) {
            if (!entityMap.containsKey(clazz)) {
                entityMap.put(clazz, new EntityImpl(clazz));
            }
            return (EntityImpl)entityMap.get(clazz);
        }

        private void init(Class clazz) {
            this.getMethods = new ArrayList();
            List methodlist = this.getMethods(clazz);
            Method[] methods = new Method[methodlist.size()];
            methodlist.toArray(methods);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getName().startsWith("get") || method.getParameterTypes().length == 0) {
                    this.getMethods.add(method);
                    Class<?> elementClass = method.getReturnType();
                    ElementImpl element = new ElementImpl(elementClass, method);
                    this.elemMap.put(element.getName(), element);
                    this.elemList.add(element);
                }
                if (!method.getName().startsWith("is") || !method.getReturnType().equals(Boolean.TYPE)) continue;
                this.getMethods.add(method);
                ElementImpl element = new ElementImpl(Boolean.TYPE, method);
                this.elemMap.put(element.getName(), element);
                this.elemList.add(element);
            }
        }

        private List getMethods(Class clazz) {
            List<Method> result = null;
            Class sclass = clazz.getSuperclass();
            if (sclass != null && !sclass.isAssignableFrom(class$org$geotools$catalog$AbstractMetadataEntity == null ? (class$org$geotools$catalog$AbstractMetadataEntity = AbstractMetadataEntity.class$("org.geotools.catalog.AbstractMetadataEntity")) : class$org$geotools$catalog$AbstractMetadataEntity)) {
                result = this.getMethods(sclass);
            }
            if (result == null) {
                result = new ArrayList<Method>();
            }
            result.addAll(Arrays.asList(clazz.getDeclaredMethods()));
            return result;
        }

        private void getInterfaces(Class class1, List list) {
            Class<?>[] ifaces = class1.getInterfaces();
            Class superclass = class1.getSuperclass();
            if (superclass != null && !superclass.getClass().isAssignableFrom(class$java$lang$Object == null ? (class$java$lang$Object = AbstractMetadataEntity.class$("java.lang.Object")) : class$java$lang$Object)) {
                this.getInterfaces(superclass, list);
            }
            for (int i = 0; i < ifaces.length; ++i) {
                Class<?> iface = ifaces[i];
                this.getInterfaces(iface, list);
            }
            if (!class1.isInterface()) {
                return;
            }
            if (class1 == (class$org$opengis$catalog$MetadataEntity == null ? (class$org$opengis$catalog$MetadataEntity = AbstractMetadataEntity.class$("org.opengis.catalog.MetadataEntity")) : class$org$opengis$catalog$MetadataEntity)) {
                return;
            }
            if (!(class$org$opengis$catalog$MetadataEntity == null ? (class$org$opengis$catalog$MetadataEntity = AbstractMetadataEntity.class$("org.opengis.catalog.MetadataEntity")) : class$org$opengis$catalog$MetadataEntity).isAssignableFrom(class1)) {
                return;
            }
            if (list.contains(class1)) {
                return;
            }
            list.add(class1);
        }

        List getGetMethods() {
            return this.getMethods;
        }

        public Object getElement(String xpath) {
            if (this.elemMap.containsKey("xpath")) {
                return this.elemMap.get(xpath);
            }
            List result = XPathFactory.find(xpath, this);
            switch (result.size()) {
                case 1: {
                    return result.get(0);
                }
                case 0: {
                    return null;
                }
            }
            return result;
        }

        public List getElements() {
            return this.elemList;
        }
    }
}

