/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.Color;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.coverage.GeophysicsCategory;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.Utilities;
import org.geotools.resources.XMath;
import org.geotools.resources.gcs.Resources;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.WeakHashSet;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class Category
implements Serializable {
    private static final long serialVersionUID = 6215962897884256696L;
    static final WeakHashSet pool;
    private static final NumberRange BYTE_0;
    private static final NumberRange BYTE_1;
    public static final Category NODATA;
    public static final Category FALSE;
    public static final Category TRUE;
    private final InternationalString name;
    final double minimum;
    final double maximum;
    NumberRange range;
    final MathTransform1D transform;
    final Category inverse;
    private final int[] ARGB;
    private static final int[] DEFAULT;
    private static final Color[] CYCLE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Category(CharSequence name, Color color, boolean sample) {
        this(name, new Color[]{color}, sample ? BYTE_0 : BYTE_1, (MathTransform1D)LinearTransform1D.IDENTITY);
    }

    public Category(CharSequence name, Color color, int sample) {
        this(name, Category.toARGB(color, sample), new Integer(sample));
        if (!$assertionsDisabled && this.minimum != (double)sample) {
            throw new AssertionError(this.minimum);
        }
        if (!$assertionsDisabled && this.maximum != (double)sample) {
            throw new AssertionError(this.maximum);
        }
    }

    public Category(CharSequence name, Color color, double sample) {
        this(name, Category.toARGB(color, (int)sample), new Double(sample));
        if (!$assertionsDisabled && Double.doubleToRawLongBits(this.minimum) != Double.doubleToRawLongBits(sample)) {
            throw new AssertionError(this.minimum);
        }
        if (!$assertionsDisabled && Double.doubleToRawLongBits(this.maximum) != Double.doubleToRawLongBits(sample)) {
            throw new AssertionError(this.maximum);
        }
    }

    private Category(CharSequence name, int[] ARGB, Number sample) {
        this(name, ARGB, new NumberRange(sample.getClass(), sample, sample), null);
        if (!$assertionsDisabled && !Double.isNaN(this.inverse.minimum)) {
            throw new AssertionError(this.inverse.minimum);
        }
        if (!$assertionsDisabled && !Double.isNaN(this.inverse.maximum)) {
            throw new AssertionError(this.inverse.maximum);
        }
    }

    public Category(CharSequence name, Color color, NumberRange sampleValueRange) throws IllegalArgumentException {
        this(name, new Color[]{color}, sampleValueRange, (MathTransform1D)null);
    }

    public Category(CharSequence name, Color[] colors, int lower, int upper, double scale, double offset) throws IllegalArgumentException {
        this(name, colors, new NumberRange(Integer.class, new Integer(lower), true, new Integer(upper), false), scale, offset);
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange, double scale, double offset) throws IllegalArgumentException {
        this(name, colors, sampleValueRange, Category.createLinearTransform(scale, offset));
        try {
            if (!$assertionsDisabled && Double.doubleToLongBits(this.transform.derivative(0.0)) != Double.doubleToLongBits(scale)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && Double.doubleToLongBits(this.transform.transform(0.0)) != Double.doubleToLongBits(offset)) {
                throw new AssertionError();
            }
        }
        catch (TransformException exception) {
            throw new AssertionError((Object)exception);
        }
        if (Double.isNaN(scale) || Double.isInfinite(scale)) {
            throw new IllegalArgumentException(Resources.format(38, "scale", new Double(scale)));
        }
        if (Double.isNaN(offset) || Double.isInfinite(offset)) {
            throw new IllegalArgumentException(Resources.format(38, "offset", new Double(offset)));
        }
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange, NumberRange geophysicsValueRange) throws IllegalArgumentException {
        this(name, colors, sampleValueRange, Category.createLinearTransform(sampleValueRange, geophysicsValueRange));
        this.inverse.range = NumberRange.wrap(geophysicsValueRange);
        if (!$assertionsDisabled && !this.range.equals((Object)NumberRange.wrap(sampleValueRange))) {
            throw new AssertionError();
        }
    }

    public Category(CharSequence name, Color[] colors, NumberRange sampleValueRange, MathTransform1D sampleToGeophysics) throws IllegalArgumentException {
        this(name, Category.toARGB(colors), sampleValueRange, sampleToGeophysics);
    }

    private Category(CharSequence name, int[] ARGB, NumberRange range, MathTransform1D sampleToGeophysics) throws IllegalArgumentException {
        Category.ensureNonNull("name", name);
        this.name = SimpleInternationalString.wrap(name);
        this.ARGB = ARGB;
        this.range = range;
        Class type = range.getElementClass();
        boolean minInc = range.isMinIncluded();
        boolean maxInc = range.isMaxIncluded();
        this.minimum = Category.doubleValue(type, range.getMinValue(), minInc ? 0 : 1);
        this.maximum = Category.doubleValue(type, range.getMaxValue(), maxInc ? 0 : -1);
        if (sampleToGeophysics == null && minInc && maxInc && Double.isNaN(this.minimum) && Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(this.maximum)) {
            this.inverse = this;
            this.transform = Category.createLinearTransform(0.0, this.minimum);
            return;
        }
        if (!(this.minimum <= this.maximum) || Double.isInfinite(this.minimum) || Double.isInfinite(this.maximum)) {
            throw new IllegalArgumentException(Resources.format(43, range.getMinValue(), range.getMaxValue()));
        }
        TransformException cause = null;
        try {
            if (sampleToGeophysics == null) {
                this.inverse = new GeophysicsCategory(this, false);
                this.transform = Category.createLinearTransform(0.0, this.inverse.minimum);
                return;
            }
            this.transform = sampleToGeophysics;
            this.inverse = sampleToGeophysics.isIdentity() ? this : new GeophysicsCategory(this, true);
            if (this.inverse.minimum <= this.inverse.maximum) {
                return;
            }
        }
        catch (TransformException exception) {
            cause = exception;
        }
        IllegalArgumentException exception = new IllegalArgumentException(Resources.format(44, Utilities.getShortClassName(sampleToGeophysics)));
        exception.initCause(cause);
        throw exception;
    }

    Category(Category inverse, boolean isQuantitative) throws TransformException {
        double max;
        if (!$assertionsDisabled && !(this instanceof GeophysicsCategory)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && inverse instanceof GeophysicsCategory) {
            throw new AssertionError();
        }
        this.inverse = inverse;
        this.name = inverse.name;
        this.ARGB = inverse.ARGB;
        if (!isQuantitative) {
            this.minimum = this.maximum = (double)Category.toNaN((int)Math.round((inverse.minimum + inverse.maximum) / 2.0));
            this.transform = Category.createLinearTransform(0.0, inverse.minimum);
            return;
        }
        this.transform = (MathTransform1D)inverse.transform.inverse();
        double min = inverse.transform.transform(inverse.minimum);
        if (min > (max = inverse.transform.transform(inverse.maximum))) {
            this.minimum = max;
            this.maximum = min;
        } else {
            this.minimum = min;
            this.maximum = max;
        }
    }

    static MathTransform1D createLinearTransform(double scale, double offset) {
        return LinearTransform1D.create(scale, offset);
    }

    private static MathTransform1D createLinearTransform(NumberRange sampleValueRange, NumberRange geophysicsValueRange) {
        int swap;
        boolean adjustSamples;
        int gMaxInc;
        Class sType = sampleValueRange.getElementClass();
        Class gType = geophysicsValueRange.getElementClass();
        int sMinInc = sampleValueRange.isMinIncluded() ? 0 : 1;
        int sMaxInc = sampleValueRange.isMaxIncluded() ? 0 : -1;
        int gMinInc = geophysicsValueRange.isMinIncluded() ? 0 : 1;
        int n = gMaxInc = geophysicsValueRange.isMaxIncluded() ? 0 : -1;
        if (sMinInc == gMinInc) {
            gMinInc = 0;
            sMinInc = 0;
        }
        if (sMaxInc == gMaxInc) {
            gMaxInc = 0;
            sMaxInc = 0;
        }
        if (((adjustSamples = XMath.isInteger(sType) && !XMath.isInteger(gType)) ? gMinInc : sMinInc) != 0) {
            swap = sMinInc;
            sMinInc = -gMinInc;
            gMinInc = -swap;
        }
        if ((adjustSamples ? gMaxInc : sMaxInc) != 0) {
            swap = sMaxInc;
            sMaxInc = -gMaxInc;
            gMaxInc = -swap;
        }
        double minSample = Category.doubleValue(sType, sampleValueRange.getMinValue(), sMinInc);
        double maxSample = Category.doubleValue(sType, sampleValueRange.getMaxValue(), sMaxInc);
        double minValue = Category.doubleValue(gType, geophysicsValueRange.getMinValue(), gMinInc);
        double maxValue = Category.doubleValue(gType, geophysicsValueRange.getMaxValue(), gMaxInc);
        double scale = (maxValue - minValue) / (maxSample - minSample);
        if (Double.isNaN(scale) && !Double.isNaN(maxValue - minValue) && !Double.isNaN(maxSample - minSample)) {
            scale = 1.0;
        }
        double offset = minValue - scale * minSample;
        return Category.createLinearTransform(scale, offset);
    }

    private static double doubleValue(Class type, Comparable number, int direction) {
        if (!($assertionsDisabled || direction >= -1 && direction <= 1)) {
            throw new AssertionError(direction);
        }
        return XMath.rool(type, ((Number)((Object)number)).doubleValue(), direction);
    }

    private static float toNaN(int index) throws IndexOutOfBoundsException {
        if ((index += 0x200000) >= 0 && index <= 0x3FFFFF) {
            float value = Float.intBitsToFloat(2143289344 + index);
            if (!$assertionsDisabled && !Float.isNaN(value)) {
                throw new AssertionError(value);
            }
            return value;
        }
        throw new IndexOutOfBoundsException(Integer.toHexString(index));
    }

    private static int[] toARGB(Color[] colors) {
        int[] ARGB;
        if (colors != null && colors.length != 0) {
            ARGB = new int[colors.length];
            for (int i = 0; i < ARGB.length; ++i) {
                ARGB[i] = colors[i].getRGB();
            }
        } else {
            ARGB = DEFAULT;
        }
        return ARGB;
    }

    private static int[] toARGB(Color color, int sample) {
        if (color == null) {
            color = CYCLE[Math.abs(sample) % CYCLE.length];
        }
        return Category.toARGB(new Color[]{color});
    }

    public InternationalString getName() {
        return this.name;
    }

    public Color[] getColors() {
        Color[] colors = new Color[this.ARGB.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(this.ARGB[i], true);
        }
        return colors;
    }

    public NumberRange getRange() {
        if (!$assertionsDisabled && this.range == null) {
            throw new AssertionError();
        }
        return this.range;
    }

    public MathTransform1D getSampleToGeophysics() {
        return this.isQuantitative() ? this.transform : null;
    }

    public boolean isQuantitative() {
        return !Double.isNaN(this.inverse.minimum) && !Double.isNaN(this.inverse.maximum);
    }

    public Category recolor(Color[] colors) {
        if (!$assertionsDisabled && this instanceof GeophysicsCategory) {
            throw new AssertionError(this);
        }
        int[] newARGB = Category.toARGB(colors);
        if (Arrays.equals(this.ARGB, newARGB)) {
            return this;
        }
        if (!$assertionsDisabled && this.range == null) {
            throw new AssertionError();
        }
        Category newCategory = new Category((CharSequence)this.name, newARGB, this.range, this.getSampleToGeophysics());
        newCategory.inverse.range = this.inverse.range;
        return newCategory;
    }

    public Category rescale(MathTransform1D sampleToGeophysics) {
        if (Utilities.equals(sampleToGeophysics, this.transform)) {
            return this;
        }
        return new Category((CharSequence)this.name, this.ARGB, this.range, sampleToGeophysics);
    }

    public Category geophysics(boolean geo) {
        return geo ? this.inverse : this;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            Category that = (Category)object;
            if (Double.doubleToRawLongBits(this.minimum) == Double.doubleToRawLongBits(that.minimum) && Double.doubleToRawLongBits(this.maximum) == Double.doubleToRawLongBits(that.maximum) && Utilities.equals(this.transform, that.transform) && Utilities.equals(this.name, that.name) && Arrays.equals(this.ARGB, that.ARGB)) {
                if (this.range != null && that.range != null) {
                    if (!Utilities.equals((Object)this.range, (Object)that.range)) {
                        return false;
                    }
                    if (this.inverse instanceof GeophysicsCategory && !$assertionsDisabled && !this.inverse.equals(that.inverse)) {
                        throw new AssertionError();
                    }
                    return true;
                }
                if (!$assertionsDisabled && !(this instanceof GeophysicsCategory)) {
                    throw new AssertionError();
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append("(\"");
        buffer.append((CharSequence)this.name);
        buffer.append("\":[");
        if (Double.isNaN(this.minimum) && Double.isNaN(this.maximum)) {
            buffer.append("NaN(");
            buffer.append((int)this.inverse.minimum);
            buffer.append("..");
            buffer.append((int)this.inverse.maximum);
            buffer.append(')');
        } else {
            buffer.append(this.minimum);
            buffer.append(" .. ");
            buffer.append(this.maximum);
        }
        buffer.append("])");
        return buffer.toString();
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(org.geotools.resources.cts.Resources.format(115, name));
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return pool.canonicalize(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return pool.canonicalize(this);
    }

    static {
        $assertionsDisabled = !Category.class.desiredAssertionStatus();
        pool = new WeakHashSet();
        Byte index = new Byte(0);
        BYTE_0 = new NumberRange(Byte.class, index, index);
        index = new Byte(1);
        BYTE_1 = new NumberRange(Byte.class, index, index);
        NODATA = new Category((CharSequence)Resources.formatInternational(21), new Color(0, 0, 0, 0), 0);
        FALSE = new Category((CharSequence)Resources.formatInternational(9), Color.BLACK, false);
        TRUE = new Category((CharSequence)Resources.formatInternational(29), Color.WHITE, true);
        DEFAULT = new int[]{-16777216, -1};
        CYCLE = new Color[]{Color.BLUE, Color.RED, Color.ORANGE, Color.YELLOW, Color.PINK, Color.MAGENTA, Color.GREEN, Color.CYAN, Color.LIGHT_GRAY, Color.GRAY};
    }
}

