/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.Image;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.resources.gcs.Resources;
import org.opengis.coverage.MetadataNameNotFoundException;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.processing.GridAnalysis;
import org.opengis.coverage.processing.GridCoverageProcessor;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public abstract class AbstractGridCoverageProcessor
extends PropertySourceImpl
implements GridCoverageProcessor {
    private static final String[] NO_PROPERTIES;
    public static final Logger LOGGER;
    public static final Level OPERATION;
    private static final Comparator COMPARATOR;
    final Map operations = new TreeMap(COMPARATOR);
    private transient Operation2D[] asArray;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractGridCoverageProcessor(PropertySource source, Map properties) {
        super(properties, source);
    }

    protected synchronized void addOperation(Operation operation) throws IllegalStateException {
        String name = operation.getName();
        if (!this.operations.containsKey(name)) {
            if (!$assertionsDisabled && this.operations.containsValue(operation)) {
                throw new AssertionError();
            }
        } else {
            throw new IllegalStateException(Resources.format(66, operation.getName()));
        }
        this.operations.put(name, operation);
        this.asArray = null;
    }

    public synchronized int getNumOperations() {
        return this.operations.size();
    }

    public synchronized Operation getOperation(int index) throws IndexOutOfBoundsException {
        if (this.asArray == null) {
            this.asArray = this.operations.values().toArray(new Operation2D[this.operations.size()]);
        }
        return this.asArray[index];
    }

    public synchronized Operation getOperation(String name) throws OperationNotFoundException {
        Operation2D operation = (Operation2D)this.operations.get(name);
        if (operation != null) {
            return operation;
        }
        throw new OperationNotFoundException(Resources.format(67, name));
    }

    public GridCoverage doOperation(String operationName, GridCoverage source) throws OperationNotFoundException {
        Operation operation = this.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        return this.doOperation(operation, parameters);
    }

    public GridCoverage doOperation(String operationName, GridCoverage source, String argumentName1, Object argumentValue1) throws OperationNotFoundException, InvalidParameterNameException {
        Operation operation = this.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        try {
            parameters.parameter(argumentName1).setValue(argumentValue1);
        }
        catch (ParameterNotFoundException cause) {
            throw AbstractGridCoverageProcessor.invalidParameterName(cause);
        }
        return this.doOperation(operation, parameters);
    }

    public GridCoverage doOperation(String operationName, GridCoverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2) throws OperationNotFoundException, InvalidParameterNameException {
        Operation operation = this.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        try {
            parameters.parameter(argumentName1).setValue(argumentValue1);
            parameters.parameter(argumentName2).setValue(argumentValue2);
        }
        catch (ParameterNotFoundException cause) {
            throw AbstractGridCoverageProcessor.invalidParameterName(cause);
        }
        return this.doOperation(operation, parameters);
    }

    public GridCoverage doOperation(String operationName, GridCoverage source, String argumentName1, Object argumentValue1, String argumentName2, Object argumentValue2, String argumentName3, Object argumentValue3) throws OperationNotFoundException, InvalidParameterNameException {
        Operation operation = this.getOperation(operationName);
        ParameterValueGroup parameters = operation.getParameters();
        parameters.parameter("Source").setValue((Object)source);
        try {
            parameters.parameter(argumentName1).setValue(argumentValue1);
            parameters.parameter(argumentName2).setValue(argumentValue2);
            parameters.parameter(argumentName3).setValue(argumentValue3);
        }
        catch (ParameterNotFoundException cause) {
            throw AbstractGridCoverageProcessor.invalidParameterName(cause);
        }
        return this.doOperation(operation, parameters);
    }

    public GridCoverage doOperation(String operationName, GeneralParameterValue[] parameters) {
        Operation operation = this.getOperation(operationName);
        ParameterValueGroup group = operation.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            ParameterValue value = (ParameterValue)parameters[i];
            group.parameter(value.getDescriptor().getName().getCode()).setValue(value.getValue());
        }
        return this.doOperation(operation, group);
    }

    public abstract GridCoverage doOperation(Operation var1, ParameterValueGroup var2);

    private static InvalidParameterNameException invalidParameterName(ParameterNotFoundException cause) {
        String name = cause.getParameterName();
        InvalidParameterNameException exception = new InvalidParameterNameException(Resources.format(77, name), name);
        exception.initCause((Throwable)cause);
        return exception;
    }

    public GridAnalysis analyze(GridCoverage gridCoverage) {
        throw new UnsupportedOperationException();
    }

    public String[] getMetadataNames() {
        String[] list = this.getPropertyNames();
        return list != null ? list : NO_PROPERTIES;
    }

    public String getMetadataValue(String name) throws MetadataNameNotFoundException {
        Object value = this.getProperty(name);
        if (value == Image.UndefinedProperty) {
            throw new MetadataNameNotFoundException(Resources.format(73, name));
        }
        return value != null ? value.toString() : null;
    }

    static {
        $assertionsDisabled = !AbstractGridCoverageProcessor.class.desiredAssertionStatus();
        NO_PROPERTIES = new String[0];
        LOGGER = Logger.getLogger("org.geotools.coverage.processing");
        OPERATION = new LogLevel("OPERATION", 780);
        COMPARATOR = new Comparator(){

            public int compare(Object name1, Object name2) {
                return ((String)name1).toLowerCase().compareTo(((String)name2).toLowerCase());
            }
        };
    }

    private static final class LogLevel
    extends Level {
        protected LogLevel(String name, int level) {
            super(name, level);
        }
    }
}

