/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;

public abstract class JDBCTextFeatureWriter
extends JDBCFeatureWriter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    FIDMapper mapper = null;

    public JDBCTextFeatureWriter(FeatureReader fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
        this.mapper = queryData.getMapper();
    }

    protected void doInsert(MutableFIDFeature current) throws IOException, SQLException {
        LOGGER.fine("inserting into postgis feature " + current);
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.queryData.getConnection();
            statement = conn.createStatement();
            String sql = this.makeInsertSql(current);
            LOGGER.fine(sql);
            statement.executeUpdate(sql);
            if (this.mapper.getColumnCount() > 0 && this.mapper.hasAutoIncrementColumns()) {
                current.setID(this.mapper.createID(conn, current, statement));
            }
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column" + sqle.getLocalizedMessage();
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
        }
    }

    protected String makeInsertSql(Feature feature) throws IOException {
        String attrValue;
        int i;
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType fetureType = ftInfo.getSchema();
        String tableName = this.encodeName(fetureType.getTypeName());
        AttributeType[] attributeTypes = fetureType.getAttributeTypes();
        StringBuffer statementSQL = new StringBuffer("INSERT INTO " + tableName + "(");
        if (!this.mapper.returnFIDColumnsAsAttributes()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                if (this.mapper.isAutoIncrement(i)) continue;
                statementSQL.append(this.mapper.getColumnName(i)).append(",");
            }
        }
        for (i = 0; i < attributeTypes.length; ++i) {
            String colName = this.encodeName(attributeTypes[i].getName());
            statementSQL.append(colName).append(",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        statementSQL.append(" VALUES (");
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            String FID = this.mapper.createID(this.queryData.getConnection(), feature, null);
            if (this.current instanceof MutableFIDFeature) {
                ((MutableFIDFeature)this.current).setID(FID);
            }
            Object[] primaryKey = this.mapper.getPKAttributes(FID);
            for (int i2 = 0; i2 < primaryKey.length; ++i2) {
                if (this.mapper.isAutoIncrement(i2)) continue;
                attrValue = this.addQuotes(primaryKey[i2]);
                statementSQL.append(attrValue).append(",");
            }
        }
        Object[] attributes = feature.getAttributes(null);
        for (int i3 = 0; i3 < attributeTypes.length; ++i3) {
            if (attributeTypes[i3].isGeometry()) {
                String geomName = attributeTypes[i3].getName();
                int srid = ftInfo.getSRID(geomName);
                attrValue = this.getGeometryInsertText((Geometry)attributes[i3], srid);
            } else {
                attrValue = this.addQuotes(attributes[i3]);
            }
            statementSQL.append(attrValue + ",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        return statementSQL.toString();
    }

    protected String addQuotes(Object value) {
        String retString = value != null ? "'" + this.doubleQuote(value) + "'" : "null";
        return retString;
    }

    String doubleQuote(Object obj) {
        return obj.toString().replaceAll("'", "''");
    }

    protected String encodeName(String tableName) {
        return tableName;
    }

    protected abstract String getGeometryInsertText(Geometry var1, int var2) throws IOException;

    public void remove() throws IOException {
        LOGGER.fine("inserting into postgis feature " + this.current);
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.queryData.getConnection();
            statement = conn.createStatement();
            String sql = this.makeDeleteSql(this.current);
            LOGGER.fine(sql);
            statement.executeUpdate(sql);
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
        }
    }

    protected String makeDeleteSql(Feature feature) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType fetureType = ftInfo.getSchema();
        String tableName = this.encodeName(fetureType.getTypeName());
        StringBuffer statementSQL = new StringBuffer("DELETE FROM " + tableName + " WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(feature.getID());
        for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
            statementSQL.append(this.mapper.getColumnName(i)).append(" = ").append(this.addQuotes(pkValues[i]));
            if (i >= this.mapper.getColumnCount() - 1) continue;
            statementSQL.append(" AND ");
        }
        return statementSQL.toString();
    }

    protected void doUpdate(Feature live, Feature current) throws IOException, SQLException {
        LOGGER.fine("updating postgis feature " + current);
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.queryData.getConnection();
            statement = conn.createStatement();
            String sql = this.makeUpdateSql(live, current);
            LOGGER.fine(sql);
            System.out.println(sql);
            statement.executeUpdate(sql);
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column";
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
        }
    }

    protected String makeUpdateSql(Feature live, Feature current) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType featureType = ftInfo.getSchema();
        AttributeType[] attributes = featureType.getAttributeTypes();
        String tableName = this.encodeName(featureType.getTypeName());
        StringBuffer statementSQL = new StringBuffer("UPDATE " + tableName + " SET ");
        for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
            Object liveAtt;
            Object currAtt = current.getAttribute(i);
            if (DataUtilities.attributesEqual(currAtt, liveAtt = live.getAttribute(i))) continue;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.fine("modifying att# " + i + " to " + currAtt);
            }
            String attrValue = null;
            if (attributes[i].isGeometry()) {
                String geomName = attributes[i].getName();
                int srid = ftInfo.getSRID(geomName);
                attrValue = this.getGeometryInsertText((Geometry)currAtt, srid);
            } else {
                attrValue = this.addQuotes(attributes[i]);
            }
            String colName = this.encodeName(attributes[i].getName());
            statementSQL.append(colName).append(" = ").append(attrValue).append(", ");
        }
        statementSQL.setLength(statementSQL.length() - 2);
        statementSQL.append(" WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(current.getID());
        for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
            statementSQL.append(this.mapper.getColumnName(i)).append(" = ").append(this.addQuotes(pkValues[i]));
            if (i >= this.mapper.getColumnCount() - 1) continue;
            statementSQL.append(" AND ");
        }
        return statementSQL.toString();
    }

    protected boolean useQueryDataForInsert() {
        return false;
    }
}

