/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.MetaData;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;

public class MetaDataImpl
extends MetadataEntity
implements MetaData {
    private static final long serialVersionUID = 4280620497868178687L;
    private String fileIdentifier;
    private Locale language;
    private Charset characterSet;
    private String parentIdentifier;
    private Collection hierarchyLevels;
    private Collection hierarchyLevelNames;
    private ResponsibleParty contact;
    private long dateStamp = Long.MIN_VALUE;
    private String metadataStandardName;
    private String metadataStandardVersion;
    private Collection spatialRepresentationInfo;
    private Collection referenceSystemInfo;
    private Collection metadataExtensionInfo;
    private Collection identificationInfo;
    private Collection contentInfo;
    private Distribution distributionInfo;
    private Collection dataQualityInfo;
    private Collection portrayalCatalogueInfo;
    private Collection metadataConstraints;
    private Collection applicationSchemaInfo;
    private MaintenanceInformation metadataMaintenance;

    public MetaDataImpl() {
    }

    public MetaDataImpl(ResponsibleParty contact, Date dateStamp, Identification identificationInfo) {
        this.setContact(contact);
        this.setDateStamp(dateStamp);
        this.setIdentificationInfo(Collections.singleton(identificationInfo));
    }

    public String getFileIdentifier() {
        return this.fileIdentifier;
    }

    public synchronized void setFileIdentifier(String newValue) {
        this.checkWritePermission();
        this.fileIdentifier = newValue;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public synchronized void setLanguage(Locale newValue) {
        this.checkWritePermission();
        this.language = newValue;
    }

    public Charset getCharacterSet() {
        return this.characterSet;
    }

    public synchronized void setCharacterSet(String newValue) {
        this.checkWritePermission();
        this.fileIdentifier = newValue;
    }

    public String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public synchronized void setParentIdentifier(String newValue) {
        this.checkWritePermission();
        this.fileIdentifier = newValue;
    }

    public synchronized Collection getHierarchyLevels() {
        this.hierarchyLevels = this.nonNullCollection(this.hierarchyLevels, ScopeCode.class);
        return this.hierarchyLevels;
    }

    public synchronized void setHierarchyLevels(Collection newValues) {
        this.hierarchyLevels = this.copyCollection(newValues, this.hierarchyLevels, ScopeCode.class);
    }

    public synchronized Collection getHierarchyLevelNames() {
        this.hierarchyLevelNames = this.nonNullCollection(this.hierarchyLevelNames, String.class);
        return this.hierarchyLevelNames;
    }

    public synchronized void setHierarchyLevelNames(Collection newValues) {
        this.hierarchyLevelNames = this.copyCollection(newValues, this.hierarchyLevelNames, String.class);
    }

    public ResponsibleParty getContact() {
        return this.contact;
    }

    public synchronized void setContact(ResponsibleParty newValue) {
        this.checkWritePermission();
        this.contact = newValue;
    }

    public synchronized Date getDateStamp() {
        return this.dateStamp != Long.MIN_VALUE ? new Date(this.dateStamp) : (Date)null;
    }

    public synchronized void setDateStamp(Date newValue) {
        this.checkWritePermission();
        this.dateStamp = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public String getMetadataStandardName() {
        return this.metadataStandardName;
    }

    public synchronized void setMetadataStandardName(String newValue) {
        this.checkWritePermission();
        this.metadataStandardName = newValue;
    }

    public String getMetadataStandardVersion() {
        return this.metadataStandardVersion;
    }

    public synchronized void setMetadataStandardVersion(String newValue) {
        this.checkWritePermission();
        this.metadataStandardVersion = newValue;
    }

    public synchronized Collection getSpatialRepresentationInfo() {
        this.spatialRepresentationInfo = this.nonNullCollection(this.spatialRepresentationInfo, SpatialRepresentation.class);
        return this.spatialRepresentationInfo;
    }

    public synchronized void setSpatialRepresentationInfo(Collection newValues) {
        this.spatialRepresentationInfo = this.copyCollection(newValues, this.spatialRepresentationInfo, SpatialRepresentation.class);
    }

    public synchronized Collection getReferenceSystemInfo() {
        this.referenceSystemInfo = this.nonNullCollection(this.referenceSystemInfo, ReferenceSystem.class);
        return this.referenceSystemInfo;
    }

    public synchronized void setReferenceSystemInfo(Collection newValues) {
        this.referenceSystemInfo = this.copyCollection(newValues, this.referenceSystemInfo, ReferenceSystem.class);
    }

    public synchronized Collection getMetadataExtensionInfo() {
        this.metadataExtensionInfo = this.nonNullCollection(this.metadataExtensionInfo, MetadataExtensionInformation.class);
        return this.metadataExtensionInfo;
    }

    public synchronized void setMetadataExtensionInfo(Collection newValues) {
        this.metadataExtensionInfo = this.copyCollection(newValues, this.metadataExtensionInfo, MetadataExtensionInformation.class);
    }

    public synchronized Collection getIdentificationInfo() {
        this.identificationInfo = this.nonNullCollection(this.identificationInfo, Identification.class);
        return this.identificationInfo;
    }

    public synchronized void setIdentificationInfo(Collection newValues) {
        this.identificationInfo = this.copyCollection(newValues, this.identificationInfo, Identification.class);
    }

    public synchronized Collection getContentInfo() {
        this.contentInfo = this.nonNullCollection(this.contentInfo, Identification.class);
        return this.contentInfo;
    }

    public synchronized void setContentInfo(Collection newValues) {
        this.contentInfo = this.copyCollection(newValues, this.contentInfo, Identification.class);
    }

    public Distribution getDistributionInfo() {
        return this.distributionInfo;
    }

    public synchronized void setDistributionInfo(Distribution newValue) {
        this.checkWritePermission();
        this.distributionInfo = newValue;
    }

    public synchronized Collection getDataQualityInfo() {
        this.dataQualityInfo = this.nonNullCollection(this.dataQualityInfo, DataQuality.class);
        return this.dataQualityInfo;
    }

    public synchronized void setDataQualityInfo(Collection newValues) {
        this.dataQualityInfo = this.copyCollection(newValues, this.dataQualityInfo, DataQuality.class);
    }

    public synchronized Collection getPortrayalCatalogueInfo() {
        this.portrayalCatalogueInfo = this.nonNullCollection(this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
        return this.portrayalCatalogueInfo;
    }

    public synchronized void setPortrayalCatalogueInfo(Collection newValues) {
        this.portrayalCatalogueInfo = this.copyCollection(newValues, this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
    }

    public synchronized Collection getMetadataConstraints() {
        this.metadataConstraints = this.nonNullCollection(this.metadataConstraints, Constraints.class);
        return this.metadataConstraints;
    }

    public synchronized void setMetadataConstraints(Collection newValues) {
        this.metadataConstraints = this.copyCollection(newValues, this.metadataConstraints, Constraints.class);
    }

    public synchronized Collection getApplicationSchemaInfo() {
        this.applicationSchemaInfo = this.nonNullCollection(this.applicationSchemaInfo, ApplicationSchemaInformation.class);
        return this.applicationSchemaInfo;
    }

    public synchronized void setApplicationSchemaInfo(Collection newValues) {
        this.applicationSchemaInfo = this.copyCollection(newValues, this.applicationSchemaInfo, ApplicationSchemaInformation.class);
    }

    public MaintenanceInformation getMetadataMaintenance() {
        return this.metadataMaintenance;
    }

    public synchronized void setMetadataMaintenance(MaintenanceInformation newValue) {
        this.checkWritePermission();
        this.metadataMaintenance = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.language = (Locale)MetaDataImpl.unmodifiable(this.language);
        this.characterSet = (Charset)MetaDataImpl.unmodifiable(this.characterSet);
        this.hierarchyLevels = (Collection)MetaDataImpl.unmodifiable(this.hierarchyLevels);
        this.hierarchyLevelNames = (Collection)MetaDataImpl.unmodifiable(this.hierarchyLevelNames);
        this.contact = (ResponsibleParty)MetaDataImpl.unmodifiable(this.contact);
        this.spatialRepresentationInfo = (Collection)MetaDataImpl.unmodifiable(this.spatialRepresentationInfo);
        this.referenceSystemInfo = (Collection)MetaDataImpl.unmodifiable(this.referenceSystemInfo);
        this.metadataExtensionInfo = (Collection)MetaDataImpl.unmodifiable(this.metadataExtensionInfo);
        this.identificationInfo = (Collection)MetaDataImpl.unmodifiable(this.identificationInfo);
        this.contentInfo = (Collection)MetaDataImpl.unmodifiable(this.contentInfo);
        this.distributionInfo = (Distribution)MetaDataImpl.unmodifiable(this.distributionInfo);
        this.dataQualityInfo = (Collection)MetaDataImpl.unmodifiable(this.dataQualityInfo);
        this.portrayalCatalogueInfo = (Collection)MetaDataImpl.unmodifiable(this.portrayalCatalogueInfo);
        this.metadataConstraints = (Collection)MetaDataImpl.unmodifiable(this.metadataConstraints);
        this.applicationSchemaInfo = (Collection)MetaDataImpl.unmodifiable(this.applicationSchemaInfo);
        this.metadataMaintenance = (MaintenanceInformation)MetaDataImpl.unmodifiable(this.metadataMaintenance);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            MetaDataImpl that = (MetaDataImpl)object;
            return this.dateStamp == that.dateStamp && Utilities.equals(this.fileIdentifier, that.fileIdentifier) && Utilities.equals(this.language, that.language) && Utilities.equals(this.characterSet, that.characterSet) && Utilities.equals(this.parentIdentifier, that.parentIdentifier) && Utilities.equals(this.hierarchyLevels, that.hierarchyLevels) && Utilities.equals(this.hierarchyLevelNames, that.hierarchyLevelNames) && Utilities.equals(this.contact, that.contact) && Utilities.equals(this.metadataStandardName, that.metadataStandardName) && Utilities.equals(this.metadataStandardVersion, that.metadataStandardVersion) && Utilities.equals(this.spatialRepresentationInfo, that.spatialRepresentationInfo) && Utilities.equals(this.referenceSystemInfo, that.referenceSystemInfo) && Utilities.equals(this.metadataExtensionInfo, that.metadataExtensionInfo) && Utilities.equals(this.identificationInfo, that.identificationInfo) && Utilities.equals(this.contentInfo, that.contentInfo) && Utilities.equals(this.distributionInfo, that.distributionInfo) && Utilities.equals(this.dataQualityInfo, that.dataQualityInfo) && Utilities.equals(this.portrayalCatalogueInfo, that.portrayalCatalogueInfo) && Utilities.equals(this.metadataConstraints, that.metadataConstraints) && Utilities.equals(this.applicationSchemaInfo, that.applicationSchemaInfo) && Utilities.equals(this.metadataMaintenance, that.metadataMaintenance);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -1045412609;
        if (this.contact != null) {
            code ^= this.contact.hashCode();
        }
        if (this.identificationInfo != null) {
            code ^= ((Object)this.identificationInfo).hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.contact);
    }
}

