/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.util.InternationalString;

public class OnLineResourceImpl
extends MetadataEntity
implements OnLineResource {
    private static final long serialVersionUID = 5412370008274334799L;
    public static final OnLineResource OGC;
    public static final OnLineResource OPEN_GIS;
    public static final OnLineResource EPSG;
    public static final OnLineResource GEOTIFF;
    public static final OnLineResource ESRI;
    public static final OnLineResource ORACLE;
    public static final OnLineResource GEOTOOLS;
    private String applicationProfile;
    private InternationalString description;
    private OnLineFunction function;
    private URI linkage;

    public OnLineResourceImpl() {
    }

    public OnLineResourceImpl(URI linkage) {
        this.setLinkage(linkage);
    }

    public String getApplicationProfile() {
        return this.applicationProfile;
    }

    public synchronized void setApplicationProfile(String newValue) {
        this.checkWritePermission();
        this.applicationProfile = newValue;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public OnLineFunction getFunction() {
        return this.function;
    }

    public synchronized void setFunction(OnLineFunction newValue) {
        this.checkWritePermission();
        this.function = newValue;
    }

    public URI getLinkage() {
        return this.linkage;
    }

    public synchronized void setLinkage(URI newValue) {
        this.checkWritePermission();
        this.linkage = newValue;
    }

    public String getProtocol() {
        URI linkage = this.linkage;
        return linkage != null ? linkage.getScheme() : null;
    }

    protected void freeze() {
        super.freeze();
        this.description = (InternationalString)OnLineResourceImpl.unmodifiable(this.description);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            OnLineResourceImpl that = (OnLineResourceImpl)object;
            return Utilities.equals(this.applicationProfile, that.applicationProfile) && Utilities.equals(this.description, that.description) && Utilities.equals(this.function, that.function) && Utilities.equals(this.linkage, that.linkage);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -1205111729;
        if (this.linkage != null) {
            code ^= this.linkage.hashCode();
        }
        return code;
    }

    public String toString() {
        return this.linkage.toString();
    }

    static {
        try {
            OnLineResourceImpl r = new OnLineResourceImpl(new URI("http://www.opengeospatial.org/"));
            OGC = r;
            r.setFunction(OnLineFunction.INFORMATION);
            r.freeze();
            r = new OnLineResourceImpl(new URI("http://www.opengis.org"));
            OPEN_GIS = r;
            r.setFunction(OnLineFunction.DOWNLOAD);
            r.freeze();
            r = new OnLineResourceImpl(new URI("http://www.epsg.org"));
            EPSG = r;
            r.setFunction(OnLineFunction.DOWNLOAD);
            r.freeze();
            r = new OnLineResourceImpl(new URI("http://www.remotesensing.org/geotiff"));
            GEOTIFF = r;
            r.setFunction(OnLineFunction.DOWNLOAD);
            r.freeze();
            r = new OnLineResourceImpl(new URI("http://www.esri.com"));
            ESRI = r;
            r.setFunction(OnLineFunction.INFORMATION);
            r.freeze();
            r = new OnLineResourceImpl(new URI("http://www.oracle.com"));
            ORACLE = r;
            r.setFunction(OnLineFunction.INFORMATION);
            r.freeze();
            r = new OnLineResourceImpl(new URI("http://www.geotools.org"));
            GEOTOOLS = r;
            r.setFunction(OnLineFunction.DOWNLOAD);
            r.freeze();
        }
        catch (URISyntaxException exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

