/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.IOException;
import java.io.Serializable;
import org.geotools.io.TableWriter;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;

public abstract class AbstractParameter
extends Formattable
implements GeneralParameterValue,
Serializable {
    private static final long serialVersionUID = 8458179223988766398L;
    final GeneralParameterDescriptor descriptor;

    protected AbstractParameter(GeneralParameterDescriptor descriptor) {
        this.descriptor = descriptor;
        AbstractParameter.ensureNonNull("descriptor", descriptor);
    }

    public GeneralParameterDescriptor getDescriptor() {
        return this.descriptor;
    }

    static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Resources.format(115, name));
        }
    }

    static void ensureNonNull(String name, Object[] array, int index) throws IllegalArgumentException {
        if (array[index] == null) {
            throw new IllegalArgumentException(Resources.format(115, name + '[' + index + ']'));
        }
    }

    static void ensureValidClass(Class valueClass, Object value) throws IllegalArgumentException {
        if (value != null && !valueClass.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException(Resources.format(85, Utilities.getShortClassName(value), Utilities.getShortName(valueClass)));
        }
    }

    static String getName(GeneralParameterDescriptor descriptor) {
        return descriptor.getName().getCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            AbstractParameter that = (AbstractParameter)object;
            return Utilities.equals(this.descriptor, that.descriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ 0xDC7086BE;
    }

    public final String toString() {
        TableWriter table = new TableWriter(null, 1);
        table.setMultiLinesCells(true);
        try {
            this.write(table);
        }
        catch (IOException exception) {
            throw new AssertionError((Object)exception);
        }
        return table.toString();
    }

    protected void write(TableWriter table) throws IOException {
        table.write(this.descriptor.getName().getCode());
        table.nextLine();
    }

    protected final String formatWKT(Formatter formatter) {
        return "PARAMETER";
    }
}

