/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEngineeringDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.util.NameFactory;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.util.InternationalString;

public class DefaultEngineeringCRS
extends AbstractSingleCRS
implements EngineeringCRS {
    private static final long serialVersionUID = 6695541732063382701L;
    public static final DefaultEngineeringCRS CARTESIAN_2D = new Cartesian("Cartesian", (CoordinateSystem)DefaultCartesianCS.GENERIC_2D);
    public static final DefaultEngineeringCRS CARTESIAN_3D = new Cartesian("Cartesian", (CoordinateSystem)DefaultCartesianCS.GENERIC_3D);
    public static final DefaultEngineeringCRS GENERIC_2D = new Cartesian("Generic", (CoordinateSystem)DefaultCartesianCS.GENERIC_2D);
    public static final DefaultEngineeringCRS GENERIC_3D = new Cartesian("Generic", (CoordinateSystem)DefaultCartesianCS.GENERIC_3D);

    public DefaultEngineeringCRS(String name, EngineeringDatum datum, CoordinateSystem cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultEngineeringCRS(Map properties, EngineeringDatum datum, CoordinateSystem cs) {
        super(properties, (Datum)datum, cs);
    }

    public int hashCode() {
        return 0x16710CAD ^ super.hashCode();
    }

    protected String formatWKT(Formatter formatter) {
        super.formatWKT(formatter);
        return "LOCAL_CS";
    }

    private static final class Cartesian
    extends DefaultEngineeringCRS {
        private static final long serialVersionUID = -1773381554353809683L;
        private static Collection ALIAS = Collections.singleton(NameFactory.create((CharSequence[])new InternationalString[]{Resources.formatInternational(6)}));

        public Cartesian(String name, CoordinateSystem cs) {
            super(name, (EngineeringDatum)DefaultEngineeringDatum.UNKNOW, cs);
        }

        public Collection getAlias() {
            return ALIAS;
        }

        public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
            if (super.equals(object, compareMetadata)) {
                if (compareMetadata) {
                    return true;
                }
                Cartesian that = (Cartesian)object;
                return Utilities.equals(this.getName().getCode(), that.getName().getCode());
            }
            return false;
        }
    }
}

