/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.GMatrix;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.datum.AbstractDatum;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.wkt.Formatter;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Matrix;

public class DefaultGeodeticDatum
extends AbstractDatum
implements GeodeticDatum {
    private static final long serialVersionUID = 8832100095648302943L;
    public static final DefaultGeodeticDatum WGS84;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    public static final String BURSA_WOLF_PROPERTY = "bursaWolf";
    private final Ellipsoid ellipsoid;
    private final PrimeMeridian primeMeridian;
    private final BursaWolfParameters[] bursaWolf;

    public DefaultGeodeticDatum(String name, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        this(Collections.singletonMap("name", name), ellipsoid, primeMeridian);
    }

    public DefaultGeodeticDatum(Map properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) {
        super(properties);
        BursaWolfParameters[] bursaWolf;
        this.ellipsoid = ellipsoid;
        this.primeMeridian = primeMeridian;
        DefaultGeodeticDatum.ensureNonNull("ellipsoid", ellipsoid);
        DefaultGeodeticDatum.ensureNonNull("primeMeridian", primeMeridian);
        Object object = properties.get("bursaWolf");
        if (object instanceof BursaWolfParameters) {
            bursaWolf = new BursaWolfParameters[]{(BursaWolfParameters)((BursaWolfParameters)object).clone()};
        } else {
            bursaWolf = (BursaWolfParameters[])object;
            if (bursaWolf != null) {
                if (bursaWolf.length == 0) {
                    bursaWolf = null;
                } else {
                    bursaWolf = (BursaWolfParameters[])bursaWolf.clone();
                    for (int i = 0; i < bursaWolf.length; ++i) {
                        bursaWolf[i] = (BursaWolfParameters)bursaWolf[i].clone();
                    }
                }
            }
        }
        this.bursaWolf = bursaWolf;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    public BursaWolfParameters getBursaWolfParameters(GeodeticDatum target) {
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters candidate = this.bursaWolf[i];
                if (!DefaultGeodeticDatum.equals((IdentifiedObject)target, (IdentifiedObject)candidate.targetDatum, false)) continue;
                return (BursaWolfParameters)candidate.clone();
            }
        }
        return null;
    }

    public static Matrix getAffineTransform(GeodeticDatum source, GeodeticDatum target) {
        return DefaultGeodeticDatum.getAffineTransform(source, target, null);
    }

    private static Matrix getAffineTransform(GeodeticDatum source, GeodeticDatum target, Set exclusion) {
        BursaWolfParameters transformation;
        int i;
        BursaWolfParameters[] bursaWolf;
        DefaultGeodeticDatum.ensureNonNull("source", source);
        DefaultGeodeticDatum.ensureNonNull("target", target);
        if (source instanceof DefaultGeodeticDatum && (bursaWolf = ((DefaultGeodeticDatum)source).bursaWolf) != null) {
            for (i = 0; i < bursaWolf.length; ++i) {
                transformation = bursaWolf[i];
                if (!DefaultGeodeticDatum.equals((IdentifiedObject)target, (IdentifiedObject)transformation.targetDatum, false)) continue;
                return transformation.getAffineTransform();
            }
        }
        if (target instanceof DefaultGeodeticDatum && (bursaWolf = ((DefaultGeodeticDatum)target).bursaWolf) != null) {
            for (i = 0; i < bursaWolf.length; ++i) {
                Matrix matrix;
                transformation = bursaWolf[i];
                if (!DefaultGeodeticDatum.equals((IdentifiedObject)source, (IdentifiedObject)transformation.targetDatum, false) || !((matrix = transformation.getAffineTransform()) instanceof GMatrix)) continue;
                ((GMatrix)matrix).invert();
                return matrix;
            }
        }
        if (source instanceof DefaultGeodeticDatum && target instanceof DefaultGeodeticDatum) {
            BursaWolfParameters[] sourceParam = ((DefaultGeodeticDatum)source).bursaWolf;
            BursaWolfParameters[] targetParam = ((DefaultGeodeticDatum)target).bursaWolf;
            if (sourceParam != null && targetParam != null) {
                for (int i2 = 0; i2 < sourceParam.length; ++i2) {
                    GeodeticDatum sourceStep = sourceParam[i2].targetDatum;
                    for (int j = 0; j < targetParam.length; ++j) {
                        GeodeticDatum targetStep = targetParam[j].targetDatum;
                        if (!DefaultGeodeticDatum.equals((IdentifiedObject)sourceStep, (IdentifiedObject)targetStep, false)) continue;
                        if (exclusion == null) {
                            exclusion = new HashSet<GeodeticDatum>();
                        }
                        if (!exclusion.add(source)) continue;
                        if (exclusion.add(target)) {
                            Matrix step2;
                            Matrix step1 = DefaultGeodeticDatum.getAffineTransform(source, sourceStep, exclusion);
                            if (step1 instanceof GMatrix && (step2 = DefaultGeodeticDatum.getAffineTransform(targetStep, target, exclusion)) instanceof GMatrix) {
                                ((GMatrix)step2).mul((GMatrix)step1);
                                return step2;
                            }
                            exclusion.remove(target);
                        }
                        exclusion.remove(source);
                    }
                }
            }
        }
        return null;
    }

    public static boolean isWGS84(Datum datum) {
        if (datum instanceof AbstractIdentifiedObject) {
            return WGS84.equals((AbstractIdentifiedObject)datum, false);
        }
        return datum != null && datum.equals(WGS84);
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultGeodeticDatum that = (DefaultGeodeticDatum)object;
            if (DefaultGeodeticDatum.equals((IdentifiedObject)this.ellipsoid, (IdentifiedObject)that.ellipsoid, compareMetadata) && DefaultGeodeticDatum.equals((IdentifiedObject)this.primeMeridian, (IdentifiedObject)that.primeMeridian, compareMetadata)) {
                return !compareMetadata || Arrays.equals(this.bursaWolf, that.bursaWolf);
            }
        }
        return false;
    }

    public int hashCode() {
        int code = 0x15CF875F ^ 37 * (super.hashCode() ^ 37 * (this.ellipsoid.hashCode() ^ 37 * this.primeMeridian.hashCode()));
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        formatter.append((IdentifiedObject)this.ellipsoid);
        if (this.bursaWolf != null) {
            for (int i = 0; i < this.bursaWolf.length; ++i) {
                BursaWolfParameters transformation = this.bursaWolf[i];
                if (!DefaultGeodeticDatum.isWGS84((Datum)transformation.targetDatum)) continue;
                formatter.append(transformation);
                break;
            }
        }
        return "DATUM";
    }

    static {
        Identifier[] identifiers = new Identifier[]{new NamedIdentifier(CitationImpl.OGC, "WGS84"), new NamedIdentifier(CitationImpl.ORACLE, "WGS 84"), new NamedIdentifier(null, "WGS_84"), new NamedIdentifier(null, "WGS 1984"), new NamedIdentifier(CitationImpl.EPSG, "WGS_1984"), new NamedIdentifier(CitationImpl.ESRI, "D_WGS_1984"), new NamedIdentifier(CitationImpl.EPSG, "World Geodetic System 1984")};
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", identifiers[0]);
        properties.put("alias", identifiers);
        WGS84 = new DefaultGeodeticDatum(properties, (Ellipsoid)DefaultEllipsoid.WGS84, (PrimeMeridian)DefaultPrimeMeridian.GREENWICH);
    }
}

