/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.imageio.spi.ServiceRegistry;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.factory.JNDI;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.factory.epsg.DataSource;
import org.geotools.referencing.factory.epsg.FactoryUsingSQL;
import org.geotools.resources.Arguments;
import org.geotools.util.MonolineFormatter;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.OperationNotFoundException;

public class DefaultFactory
extends DeferredAuthorityFactory {
    public static final String DATASOURCE_NAME = "jdbc/EPSG";
    private static FactoryRegistry datasources;
    private static final Hints HINTS;
    private DataSource datasource;
    private Thread shutdown;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultFactory() {
        super(new FactoryGroup(), 90);
        this.setTimeout(1800000L);
    }

    public Citation getAuthority() {
        Citation authority = super.getAuthority();
        return authority != null ? authority : CitationImpl.EPSG;
    }

    public final synchronized DataSource getDataSource() throws SQLException {
        if (this.datasource == null && !super.isReady()) {
            throw new SQLException("No data source found.");
        }
        return this.datasource;
    }

    public synchronized void setDataSource(DataSource datasource) throws SQLException {
        if (datasource != this.datasource) {
            try {
                this.dispose();
            }
            catch (FactoryException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                SQLException e = new SQLException(exception.getLocalizedMessage());
                e.initCause(exception);
                throw e;
            }
            this.datasource = datasource;
        }
    }

    private static synchronized Iterator getDataSources() {
        Class category;
        Class clazz = category = DataSource.class;
        if (datasources == null) {
            datasources = new FactoryRegistry(Collections.singleton(category));
            datasources.scanForPlugins();
            datasources.setOrdering(category, new Comparator(){

                public int compare(Object f1, Object f2) {
                    return ((DataSource)f2).getPriority() - ((DataSource)f1).getPriority();
                }
            });
        }
        return datasources.getServiceProviders(category, true);
    }

    private AbstractAuthorityFactory createFactory() throws SQLException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.datasource != null) {
            return this.datasource.createFactory(this.factories);
        }
        InitialContext context = null;
        DataSource source = null;
        boolean register = false;
        try {
            context = JNDI.getInitialContext(HINTS);
            source = (DataSource)context.lookup(DATASOURCE_NAME);
        }
        catch (NoInitialContextException exception) {
        }
        catch (NameNotFoundException exception) {
            register = context != null;
        }
        catch (NamingException exception) {
            SQLException e = new SQLException("Failed to get the data source for name \"jdbc/EPSG\".");
            e.initCause(exception);
            throw e;
        }
        Iterator sources = null;
        AbstractAuthorityFactory factory = null;
        SQLException failure = null;
        while (true) {
            block16: {
                if (source != null) {
                    try {
                        factory = source.createFactory(this.factories);
                        break;
                    }
                    catch (SQLException exception) {
                        if (failure != null) break block16;
                        failure = exception;
                    }
                }
            }
            if (sources == null) {
                sources = DefaultFactory.getDataSources();
            }
            if (!sources.hasNext()) {
                if (failure == null) {
                    failure = new SQLException("No data source found.");
                }
                throw failure;
            }
            source = (DataSource)sources.next();
        }
        if (register) {
            LogRecord record;
            try {
                context.bind(DATASOURCE_NAME, (Object)source);
                record = new LogRecord(Level.INFO, "Created a \"jdbc/EPSG\" entry in the naming system.");
            }
            catch (NamingException exception) {
                record = new LogRecord(Level.WARNING, "Failed to bind \"jdbc/EPSG\" entry");
                record.setThrown(exception);
            }
            record.setSourceMethodName(DefaultFactory.class.getName());
            record.setSourceMethodName("createBackingStore");
            LOGGER.log(record);
        }
        this.datasource = source;
        return factory;
    }

    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        AbstractAuthorityFactory factory;
        String product = "<unknow>";
        String url = "<unknow>";
        try {
            factory = this.createFactory();
            if (factory instanceof FactoryUsingSQL) {
                DatabaseMetaData info = ((FactoryUsingSQL)factory).connection.getMetaData();
                product = info.getDatabaseProductName();
                url = info.getURL();
            }
        }
        catch (SQLException exception) {
            throw new FactoryException("Failed to connect to the EPSG database", (Throwable)exception);
        }
        LOGGER.config("Connected to EPSG database \"" + url + "\" on " + product + '.');
        if (factory instanceof FactoryUsingSQL) {
            ((FactoryUsingSQL)factory).buffered = this;
        }
        return factory;
    }

    public synchronized void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (this.shutdown == null) {
            this.shutdown = new Thread("EPSG factory shutdown"){

                public void run() {
                    try {
                        DefaultFactory.this.dispose();
                    }
                    catch (FactoryException factoryException) {
                        // empty catch block
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdown);
        }
    }

    public synchronized void onDeregistration(ServiceRegistry registry, Class category) {
        if (this.shutdown != null && registry.getServiceProviderByClass(this.getClass()) == null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdown);
            this.shutdown = null;
        }
        super.onDeregistration(registry, category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i;
        CoordinateOperationFactory factory;
        MonolineFormatter.initGeotools();
        Arguments arguments = new Arguments(args);
        boolean printMT = arguments.getFlag("-transform");
        args = arguments.getRemainingArguments(Integer.MAX_VALUE);
        PrintWriter out = arguments.out;
        int count = 0;
        CoordinateReferenceSystem[] crs = new CoordinateReferenceSystem[args.length];
        try {
            factory = null;
            try {
                for (i = 0; i < args.length; ++i) {
                    if (factory == null && (factory = FactoryFinder.getCRSAuthorityFactory("EPSG", HINTS)) instanceof AbstractAuthorityFactory) {
                        out.println(((AbstractAuthorityFactory)factory).getBackingStoreDescription());
                    }
                    IdentifiedObject object = factory.createObject(args[i]);
                    out.println(object);
                    out.println();
                    if (!(object instanceof CoordinateReferenceSystem)) continue;
                    crs[count++] = (CoordinateReferenceSystem)object;
                }
            }
            finally {
                if (factory instanceof AbstractAuthorityFactory) {
                    ((AbstractAuthorityFactory)factory).dispose();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(arguments.err);
        }
        if (printMT) {
            factory = FactoryFinder.getCoordinateOperationFactory(HINTS);
            for (i = 0; i < count; ++i) {
                for (int j = i + 1; j < count; ++j) {
                    try {
                        out.println(factory.createOperation(crs[i], crs[j]).getMathTransform());
                    }
                    catch (OperationNotFoundException exception) {
                        out.println(exception.getLocalizedMessage());
                    }
                    catch (FactoryException exception) {
                        exception.printStackTrace(arguments.err);
                    }
                    out.println();
                }
            }
        }
        out.flush();
    }

    static {
        $assertionsDisabled = !DefaultFactory.class.desiredAssertionStatus();
        HINTS = null;
    }
}

