/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import org.geotools.referencing.operation.projection.OrthographicOblique;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public class OrthographicEquatorial
extends OrthographicOblique {
    static final /* synthetic */ boolean $assertionsDisabled;

    OrthographicEquatorial(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
        super(parameters, expected);
        if (!$assertionsDisabled && !(this.latitudeOfOrigin < 1.0E-6)) {
            throw new AssertionError(this.latitudeOfOrigin);
        }
        this.latitudeOfOrigin = 0.0;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double coslam;
        if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
            throw new AssertionError();
        }
        double cosphi = Math.cos(y);
        if (cosphi * (coslam = Math.cos(x)) < -1.0E-6) {
            throw new ProjectionException(Resources.format(118));
        }
        y = Math.sin(y);
        x = cosphi * Math.sin(x);
        if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(x);
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
            throw new AssertionError(y);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
            throw new AssertionError();
        }
        double rho = Math.sqrt(x * x + y * y);
        double sinc = rho;
        if (sinc > 1.0) {
            if (sinc - 1.0 > 1.0E-6) {
                throw new ProjectionException(Resources.format(118));
            }
            sinc = 1.0;
        }
        double cosc = Math.sqrt(1.0 - sinc * sinc);
        if (rho <= 1.0E-6) {
            y = this.latitudeOfOrigin;
            x = 0.0;
        } else {
            double phi = y * sinc / rho;
            x *= sinc;
            y = cosc * rho;
            phi = Math.abs(phi) >= 1.0 ? (phi < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(phi);
            x = y == 0.0 ? (x == 0.0 ? 0.0 : (x < 0.0 ? -1.5707963267948966 : 1.5707963267948966)) : Math.atan2(x, y);
            y = phi;
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
            throw new AssertionError(x);
        }
        if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
            throw new AssertionError(y);
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    static {
        $assertionsDisabled = !OrthographicEquatorial.class.desiredAssertionStatus();
    }
}

