/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

public class ListenerList {
    private int capacity;
    private int size;
    private Object[] listeners = null;
    private static final Object[] EmptyArray;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ListenerList() {
        this(1);
    }

    public ListenerList(int capacity) {
        if (!$assertionsDisabled && capacity < 1) {
            throw new AssertionError();
        }
        this.capacity = capacity;
    }

    public void add(Object listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        if (this.size == 0) {
            this.listeners = new Object[this.capacity];
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.listeners[i] != listener) continue;
                return;
            }
            if (this.size == this.listeners.length) {
                this.listeners = new Object[this.size * 2 + 1];
                System.arraycopy(this.listeners, 0, this.listeners, 0, this.size);
            }
        }
        this.listeners[this.size] = listener;
        ++this.size;
    }

    public void clear() {
        this.size = 0;
        this.listeners = null;
    }

    public Object[] getListeners() {
        if (this.size == 0) {
            return EmptyArray;
        }
        Object[] result = new Object[this.size];
        System.arraycopy(this.listeners, 0, result, 0, this.size);
        return result;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(Object listener) {
        if (!$assertionsDisabled && listener == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.listeners[i] != listener) continue;
            if (this.size == 1) {
                this.listeners = null;
                this.size = 0;
            } else {
                System.arraycopy(this.listeners, i + 1, this.listeners, i, --this.size - i);
                this.listeners[this.size] = null;
            }
            return;
        }
    }

    public int size() {
        return this.size;
    }

    static {
        $assertionsDisabled = !ListenerList.class.desiredAssertionStatus();
        EmptyArray = new Object[0];
    }
}

