/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.renderer.lite.AbstractLiteIterator;
import org.geotools.renderer.lite.Decimator;
import org.geotools.renderer.lite.GeomCollectionIterator;
import org.geotools.renderer.lite.LineIterator;
import org.geotools.renderer.lite.LiteCoordinateSequence;
import org.geotools.renderer.lite.LiteCoordinateSequenceFactory;
import org.geotools.renderer.lite.PointIterator;
import org.geotools.renderer.lite.PolygonIterator;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class LiteShape2
implements Shape,
Cloneable {
    private Geometry geometry;
    private boolean generalize = false;
    private double maxDistance = 1.0;
    private LineIterator lineIterator = new LineIterator();
    private GeomCollectionIterator collIterator = new GeomCollectionIterator();
    private GeometryFactory geomFac;
    private MathTransform mathTransform;

    public LiteShape2(Geometry geom, MathTransform mathTransform, Decimator decimator, boolean generalize, double maxDistance) throws TransformException, FactoryException {
        this(geom, mathTransform, decimator, generalize);
        this.maxDistance = maxDistance;
    }

    public LiteShape2(Geometry geom, MathTransform mathTransform, Decimator decimator, boolean generalize) throws TransformException, FactoryException {
        if (geom != null) {
            this.geometry = this.getGeometryFactory().createGeometry(geom);
        }
        this.mathTransform = mathTransform;
        if (decimator != null) {
            decimator.decimate(this.geometry);
        } else if (mathTransform != null && !mathTransform.isIdentity()) {
            new Decimator(mathTransform.inverse()).decimate(this.geometry);
        } else {
            new Decimator(null).decimate(this.geometry);
        }
        if (this.geometry != null) {
            this.transformGeometry(this.geometry);
        }
        this.generalize = generalize;
    }

    private void transformGeometry(Geometry geometry) throws TransformException, FactoryException {
        if (this.mathTransform == null || this.mathTransform.isIdentity()) {
            return;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                this.transformGeometry(collection.getGeometryN(i));
            }
        } else if (geometry instanceof Point) {
            LiteCoordinateSequence seq = (LiteCoordinateSequence)((Point)geometry).getCoordinateSequence();
            double[] coords = seq.getArray();
            double[] newCoords = new double[coords.length];
            this.mathTransform.transform(coords, 0, newCoords, 0, seq.size());
            seq.setArray(newCoords);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            this.transformGeometry((Geometry)polygon.getExteriorRing());
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                this.transformGeometry((Geometry)polygon.getInteriorRingN(i));
            }
        } else if (geometry instanceof LineString) {
            LiteCoordinateSequence seq = (LiteCoordinateSequence)((LineString)geometry).getCoordinateSequence();
            double[] coords = seq.getArray();
            double[] newCoords = new double[coords.length];
            this.mathTransform.transform(coords, 0, newCoords, 0, seq.size());
            seq.setArray(newCoords);
        }
    }

    private GeometryFactory getGeometryFactory() {
        if (this.geomFac == null) {
            this.geomFac = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
        }
        return this.geomFac;
    }

    public void setGeometry(Geometry g) throws TransformException, FactoryException {
        if (g != null) {
            this.geometry = this.getGeometryFactory().createGeometry(g);
            this.transformGeometry(this.geometry);
        }
    }

    public boolean contains(Rectangle2D r) {
        Geometry rect = this.rectangleToGeometry(r);
        return this.geometry.contains(rect);
    }

    public boolean contains(Point2D p) {
        Coordinate coord = new Coordinate(p.getX(), p.getY());
        Point point = this.geometry.getFactory().createPoint(coord);
        return this.geometry.contains((Geometry)point);
    }

    public boolean contains(double x, double y) {
        Coordinate coord = new Coordinate(x, y);
        Point point = this.geometry.getFactory().createPoint(coord);
        return this.geometry.contains((Geometry)point);
    }

    public boolean contains(double x, double y, double w, double h) {
        Geometry rect = this.createRectangle(x, y, w, h);
        return this.geometry.contains(rect);
    }

    public Rectangle getBounds() {
        double y2;
        double x2;
        Coordinate[] coords = this.geometry.getEnvelope().getCoordinates();
        double x1 = x2 = coords[0].x;
        double y1 = y2 = coords[0].y;
        for (int i = 1; i < 3; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            if (x < x1) {
                x1 = x;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (!(y > y2)) continue;
            y2 = y;
        }
        x1 = Math.ceil(x1);
        x2 = Math.floor(x2);
        y1 = Math.ceil(y1);
        y2 = Math.floor(y2);
        return new Rectangle((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
    }

    public Rectangle2D getBounds2D() {
        double y2;
        double x2;
        Coordinate[] coords = this.geometry.getEnvelope().getCoordinates();
        double x1 = x2 = coords[0].x;
        double y1 = y2 = coords[0].y;
        for (int i = 1; i < 3; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            if (x < x1) {
                x1 = x;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (!(y > y2)) continue;
            y2 = y;
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        AbstractLiteIterator pi = null;
        if (this.geometry instanceof Point) {
            pi = new PointIterator((Point)this.geometry, at);
        }
        if (this.geometry instanceof Polygon) {
            pi = new PolygonIterator((Polygon)this.geometry, at, this.generalize, this.maxDistance);
        } else if (this.geometry instanceof LinearRing) {
            this.lineIterator.init((LineString)((LinearRing)this.geometry), at, this.generalize, (float)this.maxDistance);
            pi = this.lineIterator;
        } else if (this.geometry instanceof LineString) {
            this.lineIterator.init((LineString)this.geometry, at, this.generalize, (float)this.maxDistance);
            pi = this.lineIterator;
        } else if (this.geometry instanceof GeometryCollection) {
            this.collIterator.init((GeometryCollection)this.geometry, at, this.generalize, this.maxDistance);
            pi = this.collIterator;
        }
        return pi;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public boolean intersects(Rectangle2D r) {
        Geometry rect = this.rectangleToGeometry(r);
        return this.geometry.intersects(rect);
    }

    public boolean intersects(double x, double y, double w, double h) {
        Geometry rect = this.createRectangle(x, y, w, h);
        return this.geometry.intersects(rect);
    }

    private Geometry rectangleToGeometry(Rectangle2D r) {
        return this.createRectangle(r.getMinX(), r.getMinY(), r.getWidth(), r.getHeight());
    }

    private Geometry createRectangle(double x, double y, double w, double h) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(x, y), new Coordinate(x, y + h), new Coordinate(x + w, y + h), new Coordinate(x + w, y), new Coordinate(x, y)};
        LinearRing lr = this.geometry.getFactory().createLinearRing(coords);
        return this.geometry.getFactory().createPolygon(lr, null);
    }

    public MathTransform getMathTransform() {
        return this.mathTransform;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }
}

