/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.image.RenderedImage;
import java.util.Iterator;
import java.util.List;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.RenderedCoverage;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridRange;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.spatialschema.geometry.Envelope;

public final class GCSUtilities {
    private GCSUtilities() {
    }

    public static boolean hasGridRange(GridGeometry geometry) {
        if (geometry != null) {
            try {
                return geometry.getGridRange() != null;
            }
            catch (InvalidGridGeometryException invalidGridGeometryException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean hasTransform(GridGeometry geometry) {
        if (geometry != null) {
            try {
                return geometry.getGridToCoordinateSystem() != null;
            }
            catch (InvalidGridGeometryException invalidGridGeometryException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Envelope toEnvelope(GridRange gridRange) {
        int dimension = gridRange.getDimension();
        double[] lower = new double[dimension];
        double[] upper = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = gridRange.getLower(i);
            upper[i] = gridRange.getUpper(i);
        }
        return new GeneralEnvelope(lower, upper);
    }

    public static GridRange toGridRange(Envelope envelope) {
        int dimension = envelope.getDimension();
        int[] lower = new int[dimension];
        int[] upper = new int[dimension];
        for (int i = 0; i < dimension; ++i) {
            lower[i] = (int)Math.round(envelope.getMinimum(i));
            upper[i] = (int)Math.round(envelope.getMaximum(i));
        }
        return new GeneralGridRange(lower, upper);
    }

    public static boolean hasTransform(SampleDimension[] sampleDimensions) {
        int i = sampleDimensions.length;
        if (--i >= 0) {
            MathTransform1D tr;
            SampleDimension sd = sampleDimensions[i];
            if (sd instanceof GridSampleDimension) {
                sd = ((GridSampleDimension)sd).geophysics(false);
            }
            return (tr = sd.getSampleToGeophysics()) != null && !tr.isIdentity();
        }
        return false;
    }

    public static boolean uses(GridCoverage coverage, RenderedImage image) {
        if (coverage != null) {
            if (coverage instanceof RenderedCoverage && ((RenderedCoverage)coverage).getRenderedImage() == image) {
                return true;
            }
            List sources = coverage.getSources();
            if (sources != null) {
                Iterator it = sources.iterator();
                while (it.hasNext()) {
                    if (!GCSUtilities.uses((GridCoverage)it.next(), image)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int getVisibleBand(RenderedImage image) {
        Object candidate = image.getProperty("GC_VisibleBand");
        if (candidate instanceof Integer) {
            return (Integer)candidate;
        }
        return 0;
    }
}

