/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.IllegalFilterException;
import org.geotools.resources.Utilities;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.opengis.util.Cloneable;

public class GraphicImpl
implements Graphic,
Cloneable {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private static final FilterFactory filterFactory = FilterFactory.createFilterFactory();
    private String geometryPropertyName = "";
    private List externalGraphics = new ArrayList();
    private List marks = new ArrayList();
    private List symbols = new ArrayList();
    private Expression rotation = null;
    private Expression size = null;
    private Displacement displacement = null;
    private Expression opacity = null;

    protected GraphicImpl() {
    }

    private static void severe(String method, String message, Exception exception) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceMethodName(method);
        record.setThrown(exception);
        LOGGER.log(record);
    }

    public ExternalGraphic[] getExternalGraphics() {
        ExternalGraphic[] ret = null;
        if (this.externalGraphics.size() > 0) {
            ret = this.externalGraphics.toArray(new ExternalGraphic[0]);
        }
        return ret;
    }

    public void setExternalGraphics(ExternalGraphic[] externalGraphics) {
        this.externalGraphics.clear();
        int i = 0;
        while (i < this.symbols.size()) {
            Object symbol = this.symbols.get(i);
            if (symbol instanceof ExternalGraphic) {
                this.symbols.remove(i);
                continue;
            }
            ++i;
        }
        if (externalGraphics != null) {
            for (i = 0; i < externalGraphics.length; ++i) {
                this.addExternalGraphic(externalGraphics[i]);
            }
        }
    }

    public void addExternalGraphic(ExternalGraphic externalGraphic) {
        this.externalGraphics.add(externalGraphic);
        this.symbols.add(externalGraphic);
    }

    public Mark[] getMarks() {
        Mark[] ret = new Mark[]{};
        if (this.marks.size() > 0) {
            ret = this.marks.toArray(new Mark[0]);
        }
        return ret;
    }

    public void setMarks(Mark[] marks) {
        this.marks.clear();
        int i = 0;
        while (i < this.symbols.size()) {
            Object symbol = this.symbols.get(i);
            if (symbol instanceof Mark) {
                this.symbols.remove(i);
                continue;
            }
            ++i;
        }
        for (i = 0; i < marks.length; ++i) {
            this.addMark(marks[i]);
        }
    }

    public void addMark(Mark mark) {
        if (mark == null) {
            return;
        }
        this.marks.add(mark);
        this.symbols.add(mark);
        mark.setSize(this.size);
        mark.setRotation(this.rotation);
    }

    public Symbol[] getSymbols() {
        Symbol[] ret = null;
        ret = this.symbols.size() > 0 ? this.symbols.toArray(new Symbol[this.symbols.size()]) : new Symbol[]{new MarkImpl()};
        return ret;
    }

    public void setSymbols(Symbol[] symbols) {
        this.symbols.clear();
        if (symbols != null) {
            for (int i = 0; i < symbols.length; ++i) {
                this.addSymbol(symbols[i]);
            }
        }
    }

    public void addSymbol(Symbol symbol) {
        this.symbols.add(symbol);
        if (symbol instanceof ExternalGraphic) {
            this.addExternalGraphic((ExternalGraphic)symbol);
        }
        if (symbol instanceof Mark) {
            this.addMark((Mark)symbol);
        }
    }

    public Expression getOpacity() {
        return this.opacity;
    }

    public Expression getRotation() {
        return this.rotation;
    }

    public Expression getSize() {
        return this.size;
    }

    public Displacement getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(Displacement offset) {
        this.displacement = offset;
    }

    public void setOpacity(Expression opacity) {
        this.opacity = opacity;
    }

    public void setOpacity(double opacity) {
        try {
            this.opacity = filterFactory.createLiteralExpression(new Double(opacity));
        }
        catch (IllegalFilterException mfe) {
            GraphicImpl.severe("setOpacity", "Problem setting Opacity", mfe);
        }
    }

    public void setRotation(Expression rotation) {
        this.rotation = rotation;
        Iterator iter = this.marks.iterator();
        while (iter.hasNext()) {
            ((MarkImpl)iter.next()).setRotation(rotation);
        }
    }

    public void setRotation(double rotation) {
        try {
            this.setRotation(filterFactory.createLiteralExpression(new Double(rotation)));
        }
        catch (IllegalFilterException mfe) {
            GraphicImpl.severe("setRotation", "Problem setting Rotation", mfe);
        }
    }

    public void setSize(Expression size) {
        this.size = size;
        Iterator iter = this.marks.iterator();
        while (iter.hasNext()) {
            ((MarkImpl)iter.next()).setSize(size);
        }
    }

    public void setSize(int size) {
        try {
            this.setSize(filterFactory.createLiteralExpression(new Integer(size)));
        }
        catch (IllegalFilterException mfe) {
            GraphicImpl.severe("setSize", "Problem setting Size", mfe);
        }
    }

    public void setGeometryPropertyName(String name) {
        this.geometryPropertyName = name;
    }

    public String getGeometryPropertyName() {
        return this.geometryPropertyName;
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        GraphicImpl clone;
        try {
            clone = (GraphicImpl)super.clone();
            clone.marks = new ArrayList();
            clone.externalGraphics = new ArrayList();
            clone.symbols = new ArrayList();
            Iterator iter = this.externalGraphics.iterator();
            while (iter.hasNext()) {
                ExternalGraphic exGraphic = (ExternalGraphic)iter.next();
                clone.addExternalGraphic((ExternalGraphic)((Cloneable)exGraphic).clone());
            }
            iter = this.marks.iterator();
            while (iter.hasNext()) {
                Mark mark = (Mark)iter.next();
                clone.addMark((Mark)((Cloneable)mark).clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.geometryPropertyName != null) {
            result = 1000003 * result + this.geometryPropertyName.hashCode();
        }
        if (this.symbols != null) {
            result = 1000003 * result + ((Object)this.symbols).hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof GraphicImpl) {
            GraphicImpl other = (GraphicImpl)oth;
            return Utilities.equals(this.geometryPropertyName, other.geometryPropertyName) && Utilities.equals(this.size, other.size) && Utilities.equals(this.rotation, other.rotation) && Utilities.equals(this.opacity, other.opacity) && Utilities.equals(this.symbols, other.symbols);
        }
        return false;
    }
}

