/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.functions.spatial.convert;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.SQLException;
import org.h2gis.api.DeterministicScalarFunction;
import org.h2gis.functions.spatial.convert.ST_GeomFromText;

public class ST_MPointFromText
extends DeterministicScalarFunction {
    public ST_MPointFromText() {
        this.addProperty("remarks", "Convert a WKT String into a MULTIPOINT.\n If an SRID is not specified, it defaults to 0.");
    }

    public String getJavaStaticMethod() {
        return "toGeometry";
    }

    public static Geometry toGeometry(String wKT) throws SQLException {
        return ST_MPointFromText.toGeometry(wKT, 0);
    }

    public static Geometry toGeometry(String wKT, int srid) throws SQLException {
        Geometry geometry = ST_GeomFromText.toGeometry(wKT, srid);
        if (!geometry.getGeometryType().equalsIgnoreCase("MULTIPOINT")) {
            throw new SQLException("The provided WKT Geometry is not a MULTIPOINT.");
        }
        return geometry;
    }
}

