/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.fmap.layers;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.cresques.cts.IProjection;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.grid.render.Render;
import org.gvsig.fmap.dal.coverage.grid.render.VisualPropertyEvent;
import org.gvsig.fmap.dal.coverage.grid.render.VisualPropertyListener;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.util.CRSUtils;
import org.gvsig.fmap.dal.coverage.util.ColorConversion;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.fmap.dal.coverage.util.Historical;
import org.gvsig.fmap.dal.coverage.util.MathUtils;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.exceptions.ReloadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLyrDefault;
import org.gvsig.fmap.mapcontext.layers.LayerChangeSupport;
import org.gvsig.fmap.mapcontext.layers.LayerListener;
import org.gvsig.fmap.mapcontext.layers.Tiling;
import org.gvsig.fmap.mapcontext.layers.operations.Classifiable;
import org.gvsig.fmap.mapcontext.layers.operations.InfoByPoint;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.listeners.LegendListener;
import org.gvsig.raster.fmap.layers.DefaultLayerConfiguration;
import org.gvsig.raster.fmap.layers.DynObjectSetRasterInfo;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.FLyrState;
import org.gvsig.raster.fmap.layers.IConfiguration;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.fmap.layers.Multiresolution;
import org.gvsig.raster.fmap.layers.NotAvailableStateException;
import org.gvsig.raster.fmap.layers.RasterDrawStrategy;
import org.gvsig.raster.fmap.legend.ColorTableLegend;
import org.gvsig.raster.roi.ROI;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceRuntimeException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.task.impl.BaseTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFLyrRaster
extends FLyrDefault
implements FLyrRaster,
Multiresolution,
InfoByPoint,
Classifiable,
IRasterLayerActions,
ILayerState,
VisualPropertyListener,
SingleLayer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFLyrRaster.class);
    public static final String PERSISTENT_NAME = "FLyrRasterSE_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "FLyrRasterSE Persistent";
    private RasterManager rManager = RasterLocator.getManager();
    private boolean mustTileDraw = false;
    private boolean mustTilePrint = true;
    private int maxTileDrawWidth = 200;
    private int maxTileDrawHeight = 200;
    private int maxTilePrintWidth = 1500;
    private int maxTilePrintHeight = 1500;
    private boolean firstLoad = false;
    private boolean removeRasterFlag = true;
    protected RasterDataStore dataStore = null;
    protected Render render = null;
    private int posX = 0;
    private int posY = 0;
    private double posXWC = 0.0;
    private int posYWC = 0;
    private int r = 0;
    private int g = 0;
    private int b = 0;
    private LayerChangeSupport layerChangeSupport = new LayerChangeSupport();
    private FLyrState state = new FLyrState();
    protected ILegend lastLegend = null;
    protected ColorTable colorTableLoadedFromProject = null;
    protected boolean loadedFromProject = false;
    private RasterDrawStrategy strategy = null;
    private static IConfiguration configuration = new DefaultLayerConfiguration();
    protected int zoomLevel = 1;
    public boolean recalcLevel = true;
    private URI uri = null;
    private static GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(DefaultFLyrRaster.class);
    protected FileUtils fileUtil = RasterLocator.getManager().getFileUtils();
    protected RasterUtils rasterUtil = RasterLocator.getManager().getRasterUtils();
    protected CRSUtils crsUtil = RasterLocator.getManager().getCRSUtils();
    protected MathUtils mathUtil = RasterLocator.getManager().getMathUtils();
    private Historical affineTransformList = this.rManager.createHistoricalService();
    protected String readingData = null;
    private boolean layerInitialize = false;

    public static void registerDynClass() {
        DynObjectManager manager = ToolsLocator.getDynObjectManager();
        DynClass dynClass = manager.add("RasterInfo", "Raster layer Info by point");
        dynClass.setNamespace("InfoByPoint");
        dynClass.addDynFieldString("File");
        dynClass.addDynFieldString("View Point");
        dynClass.addDynFieldString("Pixel Point");
        dynClass.addDynFieldString("RGB");
        dynClass.addDynFieldString("CMYK");
        dynClass.addDynFieldString("HSL");
        dynClass.addDynFieldString("Band Value");
        dynClass.addDynFieldString("World Point");
    }

    public static DefaultFLyrRaster createLayer(String layerName, File file) throws LoadLayerException {
        ProviderServices provServ = RasterLocator.getManager().getProviderServices();
        RasterDataParameters storeParameters = provServ.createParameters(file.getName());
        storeParameters.setURI(file.toURI());
        MapContextManager mcm = MapContextLocator.getMapContextManager();
        DefaultFLyrRaster lyr = (DefaultFLyrRaster)mcm.createLayer(layerName, (DataStoreParameters)storeParameters);
        return lyr;
    }

    public void setName(String name) {
        super.setName(name);
        if (name != null) {
            try {
                if (this.isClosed()) {
                    this.enableAwake();
                }
            }
            catch (NotAvailableStateException e) {
                logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Active=" + this.isOpen(), (Object)this, (Object)e);
            }
        }
    }

    public void wakeUp() {
        try {
            this.reload();
            this.enableAwake();
        }
        catch (ReloadLayerException | NotAvailableStateException throwable) {
            // empty catch block
        }
    }

    public void load() throws LoadLayerException {
        DataStoreParameters params;
        if (this.isStopped() || this.getDataStore() == null) {
            return;
        }
        this.enableStopped();
        boolean test = false;
        DataStoreParameters p = params = this.getDataStore().getParameters();
        if (params != null) {
            if (params instanceof TileDataParameters) {
                this.uri = ((RasterDataParameters)params).getURI();
                if (this.uri == null) {
                    p = (DataStoreParameters)((TileDataParameters)params).getDataParameters();
                }
            }
            if (this.uri == null && params instanceof RasterDataParameters) {
                this.uri = ((RasterDataParameters)p).getURI();
            }
        }
        try {
            if (!this.getDataStore().isOpen()) {
                this.dataStore = this.rManager.getProviderServices().open(params);
            } else {
                this.dataStore.reload();
            }
        }
        catch (NotSupportedExtensionException e) {
            throw new LoadLayerException(this.getName());
        }
        catch (RasterDriverException e) {
            throw new LoadLayerException(this.getName());
        }
    }

    @Override
    public void setLayerInitialized(boolean initialized) {
        this.layerInitialize = initialized;
    }

    public void init() throws LoadLayerException, FilePaletteException {
        this.layerInitialize = true;
        if (this.getDataStore() == null) {
            throw new LoadLayerException("Formato no valido", (Throwable)new IOException());
        }
        this.render = this.getDataStore().getRender();
        this.render.addVisualPropertyListener((VisualPropertyListener)this);
        this.initFilters();
        this.affineTransformList.clear();
        this.affineTransformList.add((Object)this.getAffineTransform());
        try {
            if (!this.isOpen()) {
                this.enableOpen();
            }
        }
        catch (NotAvailableStateException e) {
            throw new LoadLayerException("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Throwable)e);
        }
    }

    @Override
    public IProjection readProjection() throws RasterDriverException {
        try {
            this.crsUtil.setCRSFactory(CRSFactory.cp);
            if (this.getDataStore() == null) {
                return null;
            }
            return this.crsUtil.convertWktToIProjection(this.getDataStore().getWktProjection());
        }
        catch (Exception e) {
            throw new RasterDriverException("Problems converting from WKT to IProjection", e);
        }
        catch (Error e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Render getRender() {
        if (this.render == null && this.getDataStore() != null) {
            this.render = this.getDataStore().getRender();
            this.render.addVisualPropertyListener((VisualPropertyListener)this);
        }
        return this.render;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void setNoDataTransparent(boolean t) {
        this.getNoDataValue().setNoDataTransparent(t);
        if (this.getRender().getRenderingTransparency() != null) {
            this.getRender().getRenderingTransparency().setNoData(this.getDataStore().getNoDataValue());
            this.getRender().getRenderingTransparency().activeTransparency();
        }
    }

    protected void initFilters() throws FilePaletteException {
        if (this.getDataType() == null) {
            return;
        }
        RasterFilterList filterList = this.rManager.createEmptyFilterList(this.getDataType()[0]);
        if (this.loadedFromProject) {
            filterList = this.getDataStore().getRender().getFilterList();
        }
        if (this.getDataStore() == null) {
            return;
        }
        if (this.getDataStore().getNoDataValue() != null) {
            this.getDataStore().getNoDataValue().load();
        }
        filterList.setInitDataType(this.getDataType()[0]);
        this.lastLegend = null;
        try {
            if (this.colorTableLoadedFromProject != null) {
                this.setLastLegend(this.colorTableLoadedFromProject);
                RasterFilterListManager colorTableManager = filterList.getManagerByID("ColorTable");
                Params params = filterList.createEmptyFilterParams();
                params.setParam("colorTable", (Object)this.colorTableLoadedFromProject);
                colorTableManager.addFilter(params);
            } else if (this.getDataStore().getColorTable() != null) {
                ColorTable table = this.getDataStore().getColorTable();
                this.setLastLegend(table);
                RasterFilterListManager colorTableManager = filterList.getManagerByID("ColorTable");
                Params params = filterList.createEmptyFilterParams();
                params.setParam("colorTable", (Object)table);
                colorTableManager.addFilter(params);
            } else if (this.getDataStore().needEnhanced() || this.loadedFromProject && filterList.get("enhanced_stretch") != null) {
                this.loadEnhancedOrColorTable(filterList);
            }
            this.colorTableLoadedFromProject = null;
            this.getRender().setFilterList(filterList);
            this.loadedFromProject = false;
        }
        catch (FilterTypeException e) {
            logger.error("Error a\u00f1adiendo filtros en la inicializaci\u00f3n de capa " + this.getName() + " Datatype=" + this.getDataType(), null, (Object)e);
        }
        catch (FilterManagerException e) {
            logger.error("Error a\u00f1adiendo filtros en la inicializaci\u00f3n de capa " + this.getName() + " Datatype=" + this.getDataType(), null, (Object)e);
        }
    }

    private void loadEnhancedOrColorTable(RasterFilterList filterList) throws FilterTypeException, FilterManagerException, FilePaletteException {
        String colorTableName = null;
        if (configuration != null) {
            colorTableName = configuration.getValueString("loadlayer_usecolortable", null);
        }
        String palettesPath = System.getProperty("user.home") + File.separator + "gvSIG" + File.separator + "colortable";
        Statistics stats = this.getDataStore().getStatistics();
        ColorTableLibrary colorTableLibrary = this.rManager.getDataStructFactory().getColorTableLibrary();
        if (colorTableName != null) {
            try {
                stats.calculate(RasterLibrary.statisticsScale);
                if (this.getDataStore().getBandCount() == 1) {
                    ArrayList fileList = colorTableLibrary.getPaletteFileList(palettesPath);
                    for (int i = 0; i < fileList.size(); ++i) {
                        ArrayList paletteItems = new ArrayList();
                        String paletteName = colorTableLibrary.loadPalette(palettesPath, (String)fileList.get(i), paletteItems);
                        if (!paletteName.equals(colorTableName) || paletteItems.size() <= 0) continue;
                        ColorTable colorTable = colorTableLibrary.createColorTable();
                        colorTable.setName(paletteName);
                        colorTable.createPaletteFromColorItems(paletteItems, true);
                        colorTable.setInterpolated(true);
                        colorTable.createColorTableInRange(stats.getMinimun(), stats.getMaximun(), true);
                        this.setLastLegend(colorTable);
                        RasterFilterListManager colorTableManager = filterList.getManagerByID("ColorTable");
                        Params params = filterList.createEmptyFilterParams();
                        params.setParam("colorTable", (Object)colorTable);
                        colorTableManager.addFilter(params);
                        return;
                    }
                }
            }
            catch (FileNotOpenException fileList) {
            }
            catch (RasterDriverException fileList) {
            }
            catch (ProcessInterruptedException fileList) {
                // empty catch block
            }
        }
        RasterFilterListManager enhancementManager = filterList.getManagerByID("EnhancementStretch");
        RasterFilter f = filterList.getByName("enhanced_stretch");
        if (f == null) {
            Params params = filterList.createEmptyFilterParams();
            params.setParam("stats", (Object)stats);
            params.setParam("remove", (Object)new Boolean(false));
            params.setParam("renderBands", (Object)this.getRender().getRenderColorInterpretation().buildRenderBands());
            params.setParam("stretchs", null);
            params.setParam("rgb", (Object)new Boolean(true));
            enhancementManager.addFilter(params);
        }
    }

    @Override
    public boolean isReproyectable() {
        if (this.getDataStore() == null) {
            return false;
        }
        return this.getDataStore().isReproyectable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(BufferedImage image, Graphics2D g, ViewPort vp, Cancellable cancel, double scale) throws ReadException {
        block18: {
            TaskEventManager task = this.rManager.getRasterTask();
            task.setEvent(null);
            if (!this.layerInitialize && this.getDataStore() != null) {
                try {
                    this.init();
                }
                catch (FilePaletteException e) {
                    throw new ReadException("Error in raster legend", (Throwable)e);
                }
                catch (LoadLayerException e) {
                    throw new ReadException("Error initializing the layer", (Throwable)e);
                }
            }
            try {
                if (!this.isOpen()) {
                    return;
                }
                this.enableStopped();
                if (this.recalcLevel) {
                    double pixelSize = vp.getEnvelope().getLength(0) / (double)vp.getImageWidth();
                    this.zoomLevel = this.getDataStore().getNearestLevel(pixelSize);
                }
                this.recalcLevel = true;
                this.strategy = new RasterDrawStrategy(this.getMapContext(), this);
                this.strategy.stackStrategy();
                HashMap<DefaultFLyrRaster, Boolean> tStr = this.strategy.getStrategy();
                if (tStr != null && tStr.get(this) != null && !tStr.get(this).booleanValue()) {
                    this.disableStopped();
                    return;
                }
                if (!this.isWithinScale(scale)) break block18;
                if (this.mustTileDraw) {
                    Point2D p = vp.getOffset();
                    Rectangle r = new Rectangle((int)p.getX(), (int)p.getY(), vp.getImageWidth(), vp.getImageHeight());
                    Tiling tiles = new Tiling(this.maxTileDrawWidth, this.maxTileDrawHeight, (Rectangle2D)r);
                    tiles.setAffineTransform((AffineTransform)vp.getAffineTransform().clone());
                    for (int tileNr = 0; tileNr < tiles.getNumTiles(); ++tileNr) {
                        try {
                            ViewPort vport = tiles.getTileViewPort(vp, tileNr);
                            this.draw(image, g, vport, cancel);
                            continue;
                        }
                        catch (NoninvertibleTransformException | ProcessInterruptedException | QueryException e) {
                            throw new ReadException(this.getDataStore().getFullName(), e);
                        }
                    }
                    break block18;
                }
                try {
                    this.draw(image, g, vp, cancel);
                }
                catch (ProcessInterruptedException | QueryException e) {
                    throw new ReadException(this.getDataStore().getFullName(), e);
                }
            }
            finally {
                this.disableStopped();
                task.setEvent(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(BufferedImage image, Graphics2D g, ViewPort vp, Cancellable cancel) throws QueryException, ProcessInterruptedException {
        Envelope adjustedExtent = vp.getAdjustedExtent();
        if (adjustedExtent == null) {
            return;
        }
        Extent e = this.rManager.getDataStructFactory().createExtent(adjustedExtent.getLowerCorner().getX(), adjustedExtent.getUpperCorner().getY(), adjustedExtent.getUpperCorner().getX(), adjustedExtent.getLowerCorner().getY());
        Dimension imgSz = vp.getImageSize();
        ViewPortData vp2 = this.rManager.getDataStructFactory().createViewPortData(vp.getProjection(), e, (Dimension2D)imgSz);
        vp2.setMat(vp.getAffineTransform());
        vp2.setDPI((int)vp.getDPI());
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        RasterTaskStatus taskStatus = new RasterTaskStatus("Drawing " + this.getName() + "...", cancel);
        manager.add((TaskStatus)taskStatus);
        taskStatus.setAutoremove(true);
        try {
            if (this.getDataStore().isTiled()) {
                this.getRender().drawTiledService(g, vp2, (Dimension2D)vp.getImageSize(), this.getCoordTrans(), (TaskStatus)taskStatus);
            } else {
                this.getRender().draw(g, vp2, this.getCoordTrans(), (TaskStatus)taskStatus);
            }
        }
        finally {
            taskStatus.terminate();
            taskStatus.remove();
        }
    }

    public void setProjection(IProjection proj) {
        try {
            this.getDataStore().setProjection(proj, true);
            super.setProjection(proj);
        }
        catch (RmfSerializerException e) {
            logger.error("Error saving the projection", (Throwable)e);
        }
    }

    @Override
    public void setProjection(IProjection proj, boolean persist) {
        try {
            this.getDataStore().setProjection(proj, persist);
            super.setProjection(proj);
        }
        catch (RmfSerializerException e) {
            logger.error("Error saving the projection", (Throwable)e);
        }
    }

    @Override
    public Envelope getFullEnvelope() {
        if (this.getDataStore() == null || this.getDataStore().getExtent() == null) {
            return null;
        }
        Rectangle2D e = this.getDataStore().getExtent().toRectangle2D();
        try {
            Envelope env = geomManager.createEnvelope(e.getX(), e.getY(), e.getMaxX(), e.getMaxY(), 0);
            if (this.getCoordTrans() != null) {
                return env.convert(this.getCoordTrans());
            }
            return env;
        }
        catch (CreateEnvelopeException e1) {
            logger.error("Error creating the envelope", (Object)e);
            return null;
        }
    }

    public double getMaxX() {
        if (this.getFullEnvelope() != null) {
            return this.getFullEnvelope().getMaximum(0);
        }
        return -1.0;
    }

    public double getMaxY() {
        if (this.getFullEnvelope() != null) {
            return this.getFullEnvelope().getMaximum(1);
        }
        return -1.0;
    }

    public double getMinX() {
        if (this.getFullEnvelope() != null) {
            return this.getFullEnvelope().getMinimum(0);
        }
        return -1.0;
    }

    public double getMinY() {
        if (this.getFullEnvelope() != null) {
            return this.getFullEnvelope().getMinimum(1);
        }
        return -1.0;
    }

    public String queryByPoint(java.awt.Point p) {
        if (!this.isOpen()) {
            return null;
        }
        ColorConversion conv = this.rManager.getColorConversion();
        String data = "<file:" + this.normalizeAsXMLTag(this.getName()) + ">\n";
        ArrayList<Object> attr = this.getAttributes();
        data = data + "  <raster\n";
        data = data + "    File=\"" + this.getFile() + "\"\n";
        for (int i = 0; i < attr.size(); ++i) {
            Object[] a = (Object[])attr.get(i);
            data = data + "    " + a[0].toString() + "=";
            data = a[1].toString() instanceof String ? data + "\"" + a[1].toString() + "\"\n" : data + a[1].toString() + "\n";
        }
        data = data + "    Point=\"" + this.posX + " , " + this.posY + "\"\n";
        data = data + "    Point_WC=\"" + this.mathUtil.format(this.posXWC, 3) + " , " + this.mathUtil.format((double)this.posYWC, 3) + "\"\n";
        data = data + "    RGB=\"" + this.r + ", " + this.g + ", " + this.b + "\"\n";
        double[] cmyk = conv.RGBtoCMYK(this.r & 0xFF, this.g & 0xFF, this.b & 0xFF, 1.0);
        data = data + "    CMYK=\"" + this.mathUtil.format(cmyk[0], 4) + ", " + this.mathUtil.format(cmyk[1], 4) + ", " + this.mathUtil.format(cmyk[2], 4) + "," + this.mathUtil.format(cmyk[3], 4) + "\"\n";
        double[] hsl = conv.RGBtoHSL(this.r & 0xFF, this.g & 0xFF, this.b & 0xFF);
        hsl[0] = (int)(255.0 * hsl[0] / 360.0 + 0.5);
        hsl[2] = (int)(hsl[2] * 255.0 + 0.5);
        hsl[1] = (int)(hsl[1] * 255.0 + 0.5);
        data = data + "    HSL=\"" + this.mathUtil.format(hsl[0], 4) + ", " + this.mathUtil.format(hsl[1], 4) + ", " + this.mathUtil.format(hsl[2], 4) + "\"\n";
        data = data + "  />\n";
        data = data + "</file:" + this.normalizeAsXMLTag(this.getName()) + ">\n";
        return data;
    }

    private String normalizeAsXMLTag(String s) {
        return s.replaceAll("[^a-zA-Z0-9]", "");
    }

    @Override
    public ArrayList<Object> getAttributes() {
        ArrayList<Object> attr = new ArrayList<Object>();
        if (!this.isOpen()) {
            return attr;
        }
        Object[][] a = new Object[][]{{"Filename", this.getDataStore().getName()}, {"Filesize", new Long(this.getDataStore().getFileSize())}, {"Width", new Integer((int)this.getDataStore().getWidth())}, {"Height", new Integer((int)this.getDataStore().getHeight())}, {"Bands", new Integer(this.getDataStore().getBandCount())}};
        for (int i = 0; i < a.length; ++i) {
            attr.add(a[i]);
        }
        return attr;
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintAttributes propeties) throws ReadException {
        if (!this.isVisible() || !this.isWithinScale(scale)) {
            return;
        }
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        RasterTaskStatus taskStatus = new RasterTaskStatus("Printing raster " + this.getName() + "...", cancel);
        manager.add((TaskStatus)taskStatus);
        taskStatus.setAutoremove(true);
        if (!this.mustTilePrint) {
            this.draw(null, g, viewPort, cancel, scale);
        } else {
            Tiling tiles = new Tiling(this.maxTilePrintWidth, this.maxTilePrintHeight, (Rectangle2D)g.getClipBounds());
            tiles.setAffineTransform((AffineTransform)viewPort.getAffineTransform().clone());
            taskStatus.setRangeOfValues(0L, tiles.getNumTiles());
            for (int tileNr = 0; tileNr < tiles.getNumTiles(); ++tileNr) {
                try {
                    ViewPort vp = tiles.getTileViewPort(viewPort, tileNr);
                    this.draw(null, g, vp, cancel, scale);
                    taskStatus.setCurValue(tileNr);
                    continue;
                }
                catch (NoninvertibleTransformException e) {
                    throw new ReadException("Error en la transformaci\u00f3n.", (Throwable)e);
                }
                finally {
                    taskStatus.terminate();
                }
            }
        }
        taskStatus.terminate();
    }

    @Override
    public boolean removeLayerListener(LayerListener o) {
        if (this.isRemoveRasterFlag()) {
            try {
                this.enableClosed();
            }
            catch (NotAvailableStateException notAvailableStateException) {
                // empty catch block
            }
        }
        if (this.getDataStore() != null) {
            try {
                this.getDataStore().saveGeoreferencingToRmf();
            }
            catch (Exception e) {
                logger.info("error_salvando_rmf", (Throwable)e);
            }
        }
        if (this.isRemoveRasterFlag() && this.getDataStore() != null) {
            URI[] uris = (URI[])this.getUris().clone();
            try {
                this.getDataStore().close();
            }
            catch (CloseException closeException) {
                // empty catch block
            }
            this.dataStore = null;
            if (this.render != null) {
                this.render.dispose();
            }
            this.render = null;
            this.setRemoveRasterFlag(true);
            for (int i = 0; i < uris.length; ++i) {
                if (!"FILE".equalsIgnoreCase(uris[i].getScheme())) continue;
                File file = new File(uris[i]);
                File dirTemp = this.fileUtil.getTemporalFile();
                if (!file.exists() || dirTemp.compareTo(file.getParentFile()) != 0) continue;
                file.delete();
                String basefile = file.getName();
                File basepath = file.getParentFile();
                int last = basefile.lastIndexOf(".");
                if (last != -1) {
                    basefile = basefile.substring(0, last + 1);
                }
                File[] list = basepath.listFiles();
                for (int j = 0; j < list.length; ++j) {
                    if (!list[j].getName().startsWith(basefile)) continue;
                    list[j].delete();
                }
            }
        }
        this.updateDrawVersion();
        return this.layerListeners.remove(o);
    }

    @Override
    public boolean isRemoveRasterFlag() {
        return this.removeRasterFlag;
    }

    @Override
    public void setRemoveRasterFlag(boolean removeRasterFlag) {
        this.removeRasterFlag = removeRasterFlag;
    }

    public String getTocImageIcon() {
        return "map-ok-ico";
    }

    @Override
    public int[] getTileSize() {
        int[] size = new int[]{this.maxTileDrawWidth, this.maxTileDrawHeight};
        return size;
    }

    @Override
    public boolean isTiled() {
        return this.mustTileDraw;
    }

    @Override
    public boolean isGeoreferenced() {
        return this.getDataStore().isGeoreferenced();
    }

    @Override
    public NoData getNoDataValue() {
        return this.getDataStore().getNoDataValue();
    }

    @Override
    public void setNoDataValue(NoData nd) {
        if (this.getDataStore() != null) {
            this.getDataStore().setNoDataValue(nd);
        }
    }

    public double getWCHeight() {
        return this.getFullEnvelope().getMaximum(1);
    }

    public double getWCWidth() {
        return this.getFullEnvelope().getMaximum(0);
    }

    public long[] getFileSize() {
        if (this.getDataStore() == null) {
            return null;
        }
        return this.getDataStore().getFileSizeByProvider();
    }

    public URI[] getUris() {
        if (this.getDataStore() == null) {
            return null;
        }
        return this.getDataStore().getURIByProvider();
    }

    public int getFileCount() {
        return this.getDataStore().getProviderCount();
    }

    @Override
    public String getFileFormat() {
        if (this.getDataStore().getSourceType() == 0) {
            String fName = this.getDataStore().getName();
            int index = fName.lastIndexOf(".") + 1;
            String ext = null;
            if (index > 0) {
                ext = fName.substring(fName.lastIndexOf(".") + 1, fName.length());
            }
            return ext;
        }
        if (this.getDataStore().getSourceType() == 1) {
            return "POSTGIS";
        }
        return null;
    }

    public int[] getDataType() {
        return this.getDataStore().getDataType();
    }

    public void setRenderFilterList(RasterFilterList filterList) {
        this.getRender().setFilterList(filterList);
    }

    public DynObjectSet getInfo(Point p, double tolerance) throws LoadLayerException, DataException {
        DynObjectSetRasterInfo info = new DynObjectSetRasterInfo();
        if (!this.isOpen()) {
            info.addField("Layer not open", this.normalizeAsXMLTag(this.getName()), 0);
            return info;
        }
        Point2D.Double pReal = new Point2D.Double(p.getX(), p.getY());
        Point2D px = new Point2D.Double();
        if (((Point2D)pReal).getX() > this.getMinX() && ((Point2D)pReal).getX() < this.getMaxX() && ((Point2D)pReal).getY() > this.getMinY() && ((Point2D)pReal).getY() < this.getMaxY()) {
            px = this.transformPoint(pReal);
        }
        info.addField("File", this.normalizeAsXMLTag(this.getName()), 0);
        info.addField("View Point", "[" + p.getX() + " , " + p.getY() + "]", 1);
        info.addField("World Point", "[" + this.mathUtil.format(((Point2D)pReal).getX(), 3) + " , " + this.mathUtil.format(((Point2D)pReal).getY(), 3) + "]", 2);
        if (px == null) {
            info.addField("Pixel Point", "Out", 3);
        } else {
            info.addField("Pixel Point", "[" + (int)px.getX() + ",  " + (int)px.getY() + "]", 3);
        }
        String data = "[";
        try {
            if (px != null) {
                Point2D pxAux;
                int i;
                if (this.getDataType()[0] >= 0 && this.getDataType()[0] <= 3) {
                    for (i = 0; i < this.getDataStore().getBandCount(); ++i) {
                        if (!this.getDataStore().isInside((Point2D)pReal)) continue;
                        pxAux = this.transformPoint(pReal);
                        int val = (Integer)this.getDataStore().getData((int)pxAux.getX(), (int)pxAux.getY(), i);
                        data = this.getDataType()[0] == 0 ? data + (val & 0xFF) + ",  " : data + val + ",  ";
                    }
                }
                if (this.getDataType()[0] == 4) {
                    for (i = 0; i < this.getDataStore().getBandCount(); ++i) {
                        if (!this.getDataStore().isInside((Point2D)pReal)) continue;
                        pxAux = this.transformPoint(pReal);
                        data = data + ((Float)this.getDataStore().getData((int)pxAux.getX(), (int)pxAux.getY(), i)).floatValue() + ",  ";
                    }
                }
                if (this.getDataType()[0] == 5) {
                    for (i = 0; i < this.getDataStore().getBandCount(); ++i) {
                        if (!this.getDataStore().isInside((Point2D)pReal)) continue;
                        pxAux = this.transformPoint(pReal);
                        data = data + (Double)this.getDataStore().getData((int)pxAux.getX(), (int)pxAux.getY(), i) + ",  ";
                    }
                }
            }
            data = data + "]";
            info.addField("Band Value", data, 7);
        }
        catch (RasterDriverException ex) {
            throw new LoadLayerException("Error en el acceso al dataset", (Throwable)ex);
        }
        catch (InvalidSetViewException ex) {
            throw new LoadLayerException("Error en la asignaci\u00f3n de la vista en getData", (Throwable)ex);
        }
        catch (FileNotOpenException ex) {
            throw new LoadLayerException("Fichero no abierto en el dataset", (Throwable)ex);
        }
        return info;
    }

    private Point2D transformPoint(Point2D pReal) throws LoadLayerException {
        AffineTransform at = this.getDataStore().getAffineTransform();
        Point2D.Double px = new Point2D.Double();
        try {
            at.inverseTransform(pReal, px);
            return px;
        }
        catch (NoninvertibleTransformException e) {
            throw new LoadLayerException("Error en la transformaci\u00f3n del punto", (Throwable)e);
        }
    }

    public Object getInfo(String key) {
        if (key.equals("DriverName")) {
            return "gvSIG Raster Driver";
        }
        return null;
    }

    @Override
    public int[] getBandCountFromDataset() {
        return this.getDataStore().getBandCountByProvider();
    }

    @Override
    public String getColorInterpretation(int band, int dataset) {
        if (this.getDataStore().getColorInterpretation().get(band) == null) {
            return "Undefined";
        }
        return this.getDataStore().getColorInterpretation().get(band);
    }

    @Override
    public String getWktProjection() throws RasterDriverException {
        return this.getDataStore().getWktProjection();
    }

    @Override
    public boolean isRGB() {
        if (this.getDataStore() == null || this.render == null) {
            return false;
        }
        if (this.getDataStore().getDataType()[0] != 0) {
            return false;
        }
        boolean R = false;
        boolean G = false;
        boolean B = false;
        int[] renderBands = this.render.getRenderColorInterpretation().buildRenderBands();
        block5: for (int i = 0; i < renderBands.length; ++i) {
            if (renderBands[i] < 0) continue;
            switch (i) {
                case 0: {
                    R = true;
                    continue block5;
                }
                case 1: {
                    G = true;
                    continue block5;
                }
                case 2: {
                    B = true;
                }
            }
        }
        return R && G && B;
    }

    public double getCellSize() {
        return this.getDataStore() != null ? this.getDataStore().getCellSize() : 1.0;
    }

    @Override
    public Extent getFullRasterExtent() {
        return this.getDataStore().getExtent();
    }

    public File getFile() {
        if (this.getDataStore().getParameters() instanceof RasterFileStoreParameters) {
            return ((RasterFileStoreParameters)this.getDataStore().getParameters()).getFile();
        }
        return new File("");
    }

    public boolean isFileAccepted(File file) {
        return this.getDataStore().isFileSupported(file.getName());
    }

    public static boolean isFileSupported(File file) {
        return RasterLocator.getManager().getProviderServices().isExtensionSupported(file.getName());
    }

    @Override
    public boolean existColorTable() {
        return this.getRender().existColorTable();
    }

    public boolean existsAlphaBand() {
        if (this.getDataStore().getColorInterpretation() != null) {
            return this.getDataStore().getColorInterpretation().hasAlphaBand();
        }
        return false;
    }

    @Override
    public int getAlphaBandNumber() {
        if (this.getDataStore().getColorInterpretation() != null) {
            return this.getDataStore().getColorInterpretation().getBand("Alpha");
        }
        return -1;
    }

    @Override
    public void setLastLegend(ColorTable ct) {
        this.lastLegend = ColorTableLegend.createLegend(ct);
    }

    public ILegend getLegend() {
        if (this.lastLegend != null) {
            return this.lastLegend;
        }
        return null;
    }

    public void addLegendListener(LegendListener listener) {
        if (this.layerChangeSupport != null) {
            this.layerChangeSupport.addLayerListener(listener);
        }
    }

    public int getShapeType() {
        return 3;
    }

    public void removeLegendListener(LegendListener listener) {
        if (this.layerChangeSupport != null) {
            this.layerChangeSupport.removeLayerListener(listener);
        }
    }

    @Override
    public boolean isInside(Point2D p) {
        return this.getDataStore().isInside(p);
    }

    @Override
    public AffineTransform getAffineTransform() {
        AffineTransform storeTransformation = this.getDataStore().getAffineTransform();
        if (this.getCoordTrans() != null) {
            Envelope fullEnvelope = this.getFullEnvelope();
            double newCellSizeX = (fullEnvelope.getMaximum(0) - fullEnvelope.getMinimum(0)) / this.getDataStore().getWidth();
            double newCellSizeY = (fullEnvelope.getMaximum(1) - fullEnvelope.getMinimum(1)) / this.getDataStore().getHeight();
            AffineTransform layerTransformation = new AffineTransform(newCellSizeX, storeTransformation.getShearY(), storeTransformation.getShearX(), -newCellSizeY, fullEnvelope.getMinimum(0), fullEnvelope.getMaximum(1));
            return layerTransformation;
        }
        return storeTransformation;
    }

    @Override
    public void setAffineTransform(AffineTransform transf) {
        if (transf == null) {
            return;
        }
        this.affineTransformList.add((Object)transf);
        this.getDataStore().setAffineTransform(transf);
        this.updateDrawVersion();
    }

    @Override
    public void setAffineTransformWithoutHistorical(AffineTransform transf) {
        this.getDataStore().setAffineTransform(transf);
        this.updateDrawVersion();
    }

    @Override
    public Historical getAffineTransformHistorical() {
        return this.affineTransformList;
    }

    @Override
    public void saveGeoToRmf() throws RmfSerializerException {
        if (!this.isOpen()) {
            return;
        }
        this.getDataStore().saveGeoreferencingToRmf();
        this.affineTransformList.clear();
        this.affineTransformList.add((Object)this.getAffineTransform());
    }

    @Override
    public boolean isActionEnabled(int action) {
        switch (action) {
            case 8: {
                if (!this.existColorTable() && !this.getDataStore().isMosaic()) break;
                return false;
            }
            case 9: {
                if (!this.existColorTable()) break;
                return false;
            }
            case 17: {
                if (this.isReproyectable()) break;
                return false;
            }
            case 16: {
                return this.overviewsSupport();
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                return true;
            }
            case 20: {
                return false;
            }
            case 15: 
            case 23: {
                if (this.getDataStore() == null) {
                    return false;
                }
                return !this.getDataStore().isTiled();
            }
        }
        return true;
    }

    public void setVisible(boolean visibility) {
        if (this.state != null && visibility) {
            this.state.disableStopped();
        } else {
            this.enableStopped();
        }
        if (this.isAwake() || this.isClosed()) {
            try {
                this.load();
            }
            catch (LoadLayerException e) {
                e.printStackTrace();
            }
        }
        if (this.getMapContext() != null) {
            ArrayList<FLayer> listLayers = new ArrayList<FLayer>();
            listLayers = RasterDrawStrategy.getLayerList(this.getMapContext().getLayers(), listLayers);
            for (int i = 0; i < listLayers.size(); ++i) {
                if (!(listLayers.get(i) instanceof DefaultFLyrRaster)) continue;
                ((DefaultFLyrRaster)listLayers.get(i)).updateDrawVersion();
            }
        }
        super.setVisible(visibility);
    }

    public int getTransparency() {
        try {
            return this.getRender().getRenderingTransparency().getOpacity();
        }
        catch (NullPointerException e) {
            return super.getTransparency();
        }
    }

    public boolean isTransparent() {
        return this.getRender().getRenderingTransparency().isTransparencyActive();
    }

    public void setTransparency(int trans) {
        super.setTransparency(trans);
        try {
            this.getRender().getRenderingTransparency().setOpacity(trans);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public List<ROI> getRois() throws ROIException {
        return this.getDataStore().getRois(this.getMapContext().getProjection());
    }

    @Override
    public void setRois(List<ROI> rois) {
        this.getDataStore().setRois(rois);
    }

    @Override
    public void setROIsFiles(List<File> file) throws RmfSerializerException {
        this.getDataStore().saveROIFileListToRmf(file);
    }

    @Override
    public List<File> getROIsFiles() throws RmfSerializerException {
        return this.getDataStore().getROIFileListFromRmf();
    }

    public HashMap<DefaultFLyrRaster, Boolean> getRasterStrategy() {
        if (this.strategy != null) {
            return this.strategy.getStrategy();
        }
        return null;
    }

    public static IConfiguration getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(IConfiguration configuration) {
        DefaultFLyrRaster.configuration = configuration;
    }

    public void reload() throws ReloadLayerException {
        try {
            super.reload();
            this.load();
            if (this.isStopped()) {
                this.disableStopped();
            }
            if (this.getMapContext() != null) {
                this.getMapContext().invalidate();
            }
        }
        catch (LoadLayerException e) {
            this.setAvailable(false);
            throw new ReloadLayerException(this.getName(), (Throwable)e);
        }
    }

    public boolean overviewsSupport() {
        return this.getDataStore() != null && this.getDataStore().overviewsSupport();
    }

    public boolean isRenderingAsGray() {
        int[] renderBands = this.getRender().getRenderColorInterpretation().buildRenderBands();
        return renderBands != null && renderBands.length == 3 && renderBands[0] >= 0 && renderBands[0] == renderBands[1] && renderBands[1] == renderBands[2];
    }

    public void visualPropertyValueChanged(VisualPropertyEvent e) {
        this.updateDrawVersion();
    }

    @Override
    public Point2D adjustWorldRequest(Point2D req) {
        Envelope ext = null;
        ext = this.getFullEnvelope();
        req.setLocation(Math.max(ext.getMinimum(0), req.getX()), Math.max(ext.getMinimum(1), req.getY()));
        req.setLocation(Math.min(ext.getMaximum(0), req.getX()), Math.min(ext.getMaximum(1), req.getY()));
        return req;
    }

    public void setExplorer(RasterDataServerExplorer explorer) {
        if (this.getDataStore() != null) {
            this.getDataStore().setExplorer(explorer);
        }
    }

    public RasterDataServerExplorer getExplorer() {
        try {
            return (RasterDataServerExplorer)this.getDataStore().getExplorer();
        }
        catch (Exception e) {
            logger.debug("Error getting the explorer", (Throwable)e);
            return null;
        }
    }

    @Override
    public FLayer cloneLayer() throws Exception {
        return this.cloneLayer1(this.cloneLayer0());
    }

    protected DefaultFLyrRaster cloneLayer0() throws Exception {
        RasterDataStore ds = this.getDataStore().cloneDataStore();
        DefaultFLyrRaster newLayer = (DefaultFLyrRaster)this.getClass().newInstance();
        newLayer.setName(this.getName());
        newLayer.setOpenRasterStore((DataStore)ds);
        newLayer.firstLoad = this.firstLoad;
        return newLayer;
    }

    protected DefaultFLyrRaster cloneLayer1(DefaultFLyrRaster newLayer) throws Exception {
        newLayer.setExplorer(this.getExplorer());
        List filters = this.getRender().getFilterList().getStatusCloned();
        ColorInterpretation ci = this.getRender().getRenderColorInterpretation();
        if (ci != null) {
            newLayer.getRender().setRenderColorInterpretation(ci.cloneColorInterpretation());
        }
        if (newLayer.getRender().getFilterList() == null) {
            newLayer.getRender().setFilterList(RasterLocator.getManager().createEmptyFilterList(this.getRender().getFilterList().getInitDataType()));
        }
        newLayer.getRender().getFilterList().setEnv(this.getRender().getFilterList().getEnv());
        newLayer.getRender().getFilterList().setStatus(filters);
        newLayer.setNoDataValue((NoData)this.getNoDataValue().clone());
        if (this.getDataStore().getNoDataValue().isDefined()) {
            newLayer.setNoDataTransparent(true);
        }
        newLayer.enableOpen();
        newLayer.setVisible(this.isVisible());
        return newLayer;
    }

    @Override
    public FLayer getFileLayer() throws RasterDriverException {
        try {
            return this.cloneLayer();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void addFile(File file) throws InvalidSourceException {
        this.getDataStore().addFile(file);
    }

    @Override
    public void removeFile(File file) {
        this.getDataStore().removeFile(file);
    }

    @Override
    public void disableStopped() {
        if (this.state != null) {
            this.state.disableStopped();
        }
    }

    @Override
    public void enableAwake() throws NotAvailableStateException {
        if (this.state != null) {
            this.state.enableAwake();
        }
    }

    @Override
    public void enableClosed() throws NotAvailableStateException {
        if (this.state != null) {
            this.state.enableClosed();
        }
    }

    @Override
    public void enableOpen() throws NotAvailableStateException {
        if (this.state != null) {
            this.state.enableOpen();
        }
    }

    @Override
    public void enableStopped() {
        if (this.state != null) {
            this.state.enableStopped();
        }
    }

    @Override
    public boolean isAwake() {
        return this.state != null && this.state.isAwake();
    }

    @Override
    public boolean isClosed() {
        return this.state != null && this.state.isClosed();
    }

    @Override
    public boolean isOpen() {
        return this.state != null && this.state.isOpen();
    }

    @Override
    public boolean isStopped() {
        return this.state != null && this.state.isStopped();
    }

    public Set getMetadataChildren() {
        return null;
    }

    public Object getMetadataID() {
        return this.getName();
    }

    public String getMetadataName() {
        return null;
    }

    @Override
    public RasterDataStore getDataStore() {
        return this.dataStore;
    }

    @Override
    public IProjection getProjection() {
        return this.getDataStore().getProjection();
    }

    public void setOpenRasterStore(DataStore dataStore) throws LoadLayerException {
        if (dataStore instanceof CoverageStoreProviderServices) {
            try {
                this.dataStore = this.rManager.getProviderServices().open(((CoverageStoreProviderServices)dataStore).getProvider(), dataStore.getParameters());
            }
            catch (NotSupportedExtensionException e) {
                throw new LoadLayerException("Extension not supported", (Throwable)e);
            }
            catch (RasterDriverException e) {
                throw new LoadLayerException("Error opening the DataStore", (Throwable)e);
            }
        } else {
            this.dataStore = (RasterDataStore)dataStore;
        }
        try {
            this.enableAwake();
        }
        catch (NotAvailableStateException e) {
            throw new LoadLayerException("Fallo el estado de open. Closed=" + this.isClosed() + " Active=" + this.isOpen(), (Throwable)e);
        }
        if (this.getDataStore().getProjection() != null) {
            try {
                this.getDataStore().setProjection(this.getDataStore().getProjection(), false);
                super.setProjection(this.getDataStore().getProjection());
            }
            catch (RmfSerializerException rmfSerializerException) {
                // empty catch block
            }
        }
    }

    public void setDataStore(DataStore dataStore) throws LoadLayerException {
        this.setOpenRasterStore(dataStore);
        this.load();
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public boolean isReadingData() {
        return this.readingData != null;
    }

    @Override
    public synchronized void setReadingData(String readingData) {
        this.readingData = readingData;
    }

    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        return null;
    }

    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel) throws LoadLayerException, DataException {
        return null;
    }

    protected void doDispose() throws BaseException {
        if (this.render != null) {
            this.render.dispose();
        }
        if (this.getDataStore() != null) {
            this.getDataStore().dispose();
        }
        this.finalize();
    }

    @Override
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
    }

    @Override
    public boolean increaseZoomLevel() {
        if (this.zoomLevel < this.getDataStore().getZoomLevels() - 1) {
            ++this.zoomLevel;
            this.recalcLevel = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean decreaseZoomLevel() {
        if (this.zoomLevel > 0) {
            --this.zoomLevel;
            this.recalcLevel = false;
            return true;
        }
        return false;
    }

    @Override
    public Envelope getCoordsInLevel(Point2D center, int level, int w, int h) throws CreateEnvelopeException {
        Extent ex = this.getDataStore().getCoordsInLevel(center, level, w, h);
        return geomManager.createEnvelope(ex.getULX(), ex.getULY(), ex.getLRX(), ex.getLRY(), 0);
    }

    @Override
    public boolean isEnabledMultiresolution() {
        return this.getDataStore().isTiled();
    }

    @Override
    public void setTileServer(Class<?> tileServer) throws InitializeException {
        this.getDataStore().setTileServer(tileServer);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            super.loadFromState(state);
            this.dataStore = (RasterDataStore)state.get("rasterdatastore");
        }
        catch (PersistenceRuntimeException e) {
            logger.debug("Unable to load store from persistence in layer: " + this.getName(), (Throwable)e);
            this.setAvailable(false);
            return;
        }
        this.lastLegend = (ILegend)state.get("legend");
        this.colorTableLoadedFromProject = (ColorTable)state.get("colortable");
        if (state.get("recalcLevel") != null) {
            this.recalcLevel = state.getBoolean("recalcLevel");
        }
        if (state.get("zoomLevel") != null) {
            this.zoomLevel = state.getInt("zoomLevel");
        }
        this.loadedFromProject = true;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("rasterdatastore", (Persistent)this.getDataStore());
        state.set("legend", (Persistent)this.lastLegend);
        state.set("colortable", (Persistent)this.getRender().getColorTable());
        state.set("zoomLevel", this.zoomLevel);
        state.set("recalcLevel", this.recalcLevel);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultFLyrRaster.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.extend("Persistence", "FLyrDefault");
            DefaultFLyrRaster.registerPersistence(definition);
        }
    }

    public static void registerPersistence(DynStruct definition) {
        definition.addDynFieldObject("rasterdatastore").setClassOfValue(RasterDataStore.class).setMandatory(false);
        definition.addDynFieldObject("legend").setClassOfValue(ILegend.class).setMandatory(false);
        definition.addDynFieldObject("colortable").setClassOfValue(ColorTable.class).setMandatory(false);
        definition.addDynFieldInt("zoomLevel").setMandatory(false);
        definition.addDynFieldBoolean("recalcLevel").setMandatory(false);
    }

    public GeometryType getGeometryType() throws ReadException {
        try {
            return GeometryLocator.getGeometryManager().getGeometryType(3, 0);
        }
        catch (GeometryTypeNotSupportedException e) {
            throw new ReadException(this.getDataStore().getName(), (Throwable)e);
        }
        catch (GeometryTypeNotValidException e) {
            throw new ReadException(this.getDataStore().getName(), (Throwable)e);
        }
    }

    public void setDataStore(DataStore dataStore, String domain) throws LoadLayerException {
        this.setDataStore(dataStore);
    }

    protected void finalize() {
        this.layerChangeSupport = null;
        this.state = null;
        this.lastLegend = null;
        this.colorTableLoadedFromProject = null;
        this.strategy = null;
        configuration = null;
        this.fileUtil = null;
        this.rasterUtil = null;
        this.crsUtil = null;
        this.mathUtil = null;
        this.uri = null;
        this.affineTransformList = null;
        this.readingData = null;
        this.dataStore = null;
        this.render = null;
    }

    public class RasterTaskStatus
    extends BaseTaskStatus {
        Cancellable c;

        public RasterTaskStatus(String tittle, Cancellable c) {
            super(tittle);
            this.c = null;
            this.c = c;
        }

        public boolean isCancellationRequested() {
            if (this.c != null) {
                return this.c.isCanceled();
            }
            return false;
        }

        public void cancelRequest() {
            if (this.c != null) {
                this.c.setCanceled(true);
            }
        }
    }
}

