/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.swing.impl.linelegend;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gvsig.app.project.documents.view.legend.gui.Features;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.UrbanHorizontalSignageLocator;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageLegend;
import org.gvsig.legend.urbanhorizontalsignage.swing.api.linelegend.UrbanHorizontalSignageLegendEditor;
import org.gvsig.legend.urbanhorizontalsignage.swing.impl.linelegend.DefaultUrbanHorizontalSignageConfigPanel;
import org.gvsig.legend.urbanhorizontalsignage.swing.impl.linelegend.DefaultUrbanHorizontalSignageLegendEditorView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUrbanHorizontalSignageLegendEditor
extends DefaultUrbanHorizontalSignageLegendEditorView
implements UrbanHorizontalSignageLegendEditor {
    private static final long serialVersionUID = 4307714097793669675L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUrbanHorizontalSignageLegendEditor.class);
    private UrbanHorizontalSignageLegend legend;
    private FLayer layer;
    private final Class<? extends UrbanHorizontalSignageLegend> legendClass = UrbanHorizontalSignageLocator.getUrbanHorizontalSignageManager().getUrbanHorizontalSignageLegendClass();
    private DefaultUrbanHorizontalSignageConfigPanel configPanel;

    public DefaultUrbanHorizontalSignageLegendEditor() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.configPanel = new DefaultUrbanHorizontalSignageConfigPanel();
        this.grdConfig.setLayout(new BorderLayout());
        this.grdConfig.add((Component)this.configPanel, "Center");
        this.translateAll();
    }

    private void translateAll() {
    }

    public void setData(FLayer layer, ILegend legend) {
        FeatureStore store;
        if (layer == this.layer && legend == this.legend) {
            return;
        }
        this.layer = layer;
        this.legend = this.getLegendClass().isInstance(legend) ? (UrbanHorizontalSignageLegend)legend : UrbanHorizontalSignageLocator.getUrbanHorizontalSignageManager().createUrbanHorizontalSignageLegend();
        if (layer instanceof FLyrVect && (store = ((FLyrVect)layer).getFeatureStore()) != null) {
            try {
                FeatureType ftype = store.getDefaultFeatureType();
                this.configPanel.setFeatureType(ftype);
                this.configPanel.put(this.legend.getConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Can't fill data of legend.", (Throwable)ex);
            }
        }
    }

    public ILegend getLegend() {
        this.configPanel.fetch(this.legend.getConfig());
        return this.legend;
    }

    public String getDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Urban_horizontal_signage_legend_description");
    }

    public ImageIcon getIcon() {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getCurrent();
        return theme.get("legend-overview-vectorial-urbanhorizontalsignage");
    }

    public Class getParentClass() {
        return Features.class;
    }

    public String getTitle() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        return i18n.getTranslation("_Urban_horizontal_signage_legend");
    }

    public JPanel getPanel() {
        return this;
    }

    public Class getLegendClass() {
        return this.legendClass;
    }

    public boolean isSuitableFor(FLayer layer) {
        if (layer instanceof FLyrVect) {
            try {
                int shapeType = ((FLyrVect)layer).getShapeType();
                return GeometryUtils.isSubtype((int)2, (int)shapeType) || GeometryUtils.isSubtype((int)8, (int)shapeType);
            }
            catch (Exception ex) {
                LOGGER.debug("Can't get shape type for layer " + layer.getName(), (Throwable)ex);
                return false;
            }
        }
        return false;
    }
}

