/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.spline;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.FilledSpline;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.prov.spline.SplineEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class FilledSplineEditingProvider
extends SplineEditingProvider
implements EditingProvider {
    public FilledSplineEditingProvider(ProviderServices services, DynObject parameters) {
        super(services, parameters);
    }

    @Override
    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        if (this.values != null && this.values.size() >= 1) {
            for (Point point : this.values) {
                drawingStatus.addStatus((Geometry)point, auxiliaryPointSymbolEditing, "");
            }
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                FilledSpline filledSpline = (FilledSpline)geometryManager.create(25, subtype);
                for (int i = 0; i < this.values.size(); ++i) {
                    filledSpline.addVertex((Point)this.values.get(i));
                }
                filledSpline.addVertex(mousePosition);
                filledSpline.addVertex((Point)this.values.get(0));
                drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                drawingStatus.addStatus((Geometry)filledSpline, polygonSymbolEditing, "");
                drawingStatus.addStatus((Geometry)filledSpline, previewSymbol, "");
            }
            catch (BaseException e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return drawingStatus;
    }

    @Override
    public Geometry finish() throws FinishServiceException {
        if (this.values != null && this.values.size() > 1) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                FilledSpline filledSpline = (FilledSpline)geometryManager.create(25, subtype);
                for (int i = 0; i < this.values.size(); ++i) {
                    filledSpline.addVertex((Point)this.values.get(i));
                }
                filledSpline.addVertex((Point)this.values.get(0));
                return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)filledSpline);
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "insert-filled-spline";
    }
}

