/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.spline;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Spline;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class SplineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    public static final String REMOVE_LAST_POINT = "remove_last_point";
    public static final String FINISH = "finish";
    public static final String CLOSE_SPLINE = "close_spline";
    public static final String KEY_REMOVE_LAST_POINT = "key_remove_last_point";
    public static final String KEY_FINISH = "key_finish";
    public static final String KEY_CLOSE = "key_close";
    protected EditingServiceParameter points;
    protected List<Point> values;
    protected boolean closeSpline;
    protected boolean finishSpline;
    protected FeatureStore featureStore;

    public SplineEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        DefaultEditingServiceParameterOptions options = new DefaultEditingServiceParameterOptions().add(CLOSE_SPLINE, (Object)CLOSE_SPLINE, i18nManager.getTranslation(KEY_CLOSE)).add(FINISH, (Object)FINISH, i18nManager.getTranslation(KEY_FINISH)).add(REMOVE_LAST_POINT, (Object)REMOVE_LAST_POINT, i18nManager.getTranslation(KEY_REMOVE_LAST_POINT));
        String consoleMsg = editingProviderServices.makeConsoleMessage("indicate_new_point", (EditingServiceParameterOptions)options);
        this.points = new DefaultEditingServiceParameter("_point_options", consoleMsg, (EditingServiceParameterOptions)options, null, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.LIST_POSITIONS, EditingServiceParameter.TYPE.OPTION}).setDataType(8);
        this.closeSpline = false;
        this.finishSpline = false;
    }

    public EditingServiceParameter next() {
        if (this.finishSpline) {
            return null;
        }
        return this.points;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        if (this.values != null && this.values.size() >= 1) {
            for (Point point : this.values) {
                drawingStatus.addStatus((Geometry)point, auxiliaryPointSymbolEditing, "");
            }
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Spline spline = editingProviderServices.createSpline(this.values, subtype);
                spline.addVertex(mousePosition);
                drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                drawingStatus.addStatus((Geometry)spline, lineSymbolEditing, "");
                drawingStatus.addStatus((Geometry)spline, previewSymbol, "");
            }
            catch (BaseException e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return drawingStatus;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.points);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.points) {
            if (value instanceof Point) {
                this.values.add((Point)value);
                return;
            }
            if (value instanceof String) {
                String option = (String)parameter.getOptions2().getValue(value, parameter.getDefaultValue());
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                if (this.values.size() > 0 && StringUtils.equalsIgnoreCase((String)option, (String)REMOVE_LAST_POINT)) {
                    this.values.remove(this.values.size() - 1);
                    return;
                }
                if (this.values.size() > 1 && (StringUtils.equalsIgnoreCase((String)option, (String)CLOSE_SPLINE) || StringUtils.equalsIgnoreCase((String)option, (String)FINISH))) {
                    if (StringUtils.equalsIgnoreCase((String)option, (String)CLOSE_SPLINE)) {
                        this.closeSpline = true;
                    }
                    this.finishSpline = true;
                    return;
                }
            }
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        if (this.values != null && this.values.size() > 1) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                if (this.closeSpline) {
                    this.values.add(this.values.get(0));
                }
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Spline spline = editingProviderServices.createSpline(this.values, subtype);
                return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)spline);
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        if (geometry != null) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
        }
    }

    public void start() throws StartServiceException {
        this.values = new ArrayList<Point>();
        this.closeSpline = false;
        this.finishSpline = false;
    }

    public String getName() {
        return "insert-spline";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.points) {
            return this.values;
        }
        return null;
    }
}

