/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.extendline.operation;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.vectorediting.lib.prov.extendline.operation.ExtendLineOperation;

public class ExtendLineOperationUtils {
    public static final String START_SIDE = "start";
    public static final String END_SIDE = "end";
    private static final int PROJECTION_LIMIT = 100;
    private static final int PROJECTION_STEPS = 10;
    private static final Map<Integer, ExtendLineOperation> operations = new HashMap<Integer, ExtendLineOperation>();

    public static void register(ExtendLineOperation operation, int geometryType) {
        operations.put(geometryType, operation);
    }

    public static ExtendLineOperation getOperation(Primitive geom) {
        Integer type = geom.getGeometryType().getType();
        ExtendLineOperation operation = operations.get(type);
        return operation;
    }

    public static Point curveIntersection(Curve line, String sideToExtend, FeatureSelection boundaryObjects) throws CreateGeometryException, DataException, GeometryOperationNotSupportedException, GeometryOperationException {
        Point initPoint = ExtendLineOperationUtils.getExtremeSegmentInitPoint(line, sideToExtend);
        Point endPoint = ExtendLineOperationUtils.getExtremeSegmentEndPoint(line, sideToExtend);
        return ExtendLineOperationUtils.getIntersectionOfProjectedLine(initPoint, endPoint, boundaryObjects);
    }

    public static Point curveIntersection(Curve line, String sideToExtend, Geometry boundaryObject) throws GeometryException, DataException, GeometryOperationNotSupportedException, GeometryOperationException {
        Point initPoint = ExtendLineOperationUtils.getExtremeSegmentInitPoint(line, sideToExtend);
        Point endPoint = ExtendLineOperationUtils.getExtremeSegmentEndPoint(line, sideToExtend);
        return ExtendLineOperationUtils.getIntersectionOfProjectedLine(initPoint, endPoint, boundaryObject);
    }

    private static Point getExtremeSegmentEndPoint(Curve line, String sideToExtend) {
        if (sideToExtend.equalsIgnoreCase(START_SIDE)) {
            return line.getVertex(0);
        }
        if (sideToExtend.equalsIgnoreCase(END_SIDE)) {
            return line.getVertex(line.getNumVertices() - 1);
        }
        return null;
    }

    private static Point getExtremeSegmentInitPoint(Curve line, String sideToExtend) {
        if (sideToExtend.equalsIgnoreCase(START_SIDE)) {
            return line.getVertex(1);
        }
        if (sideToExtend.equalsIgnoreCase(END_SIDE)) {
            return line.getVertex(line.getNumVertices() - 2);
        }
        return null;
    }

    public static Point arcIntersection(Arc arcToBeExtended, String sideToExtend, FeatureSelection boundaryObjects) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException, DataException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = arcToBeExtended.getGeometryType().getSubType();
        Point center = arcToBeExtended.getCenterPoint();
        double radius = center.distance((Geometry)arcToBeExtended.getInitPoint());
        Point intersection = null;
        double minDistance = Double.POSITIVE_INFINITY;
        Arc tmpArc = (Arc)geoManager.create(12, subtype);
        tmpArc.setPoints(center, radius, 0.0, Math.PI * 2);
        DisposableIterator it = boundaryObjects.fastIterator();
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            Geometry geometry = feature.getDefaultGeometry();
            if (!tmpArc.intersects(geometry)) continue;
            Geometry intersectionGeometry = tmpArc.intersection(geometry);
            if (intersectionGeometry instanceof Complex) {
                intersectionGeometry = ((Complex)intersectionGeometry).createAggregate(7, t -> t.getGeometryType().getType() == 7 || t.getGeometryType().getType() == 1);
            }
            if (intersectionGeometry instanceof MultiPoint) {
                MultiPoint intersectionMultiPoint = (MultiPoint)intersectionGeometry;
                for (int i = 0; i < intersectionMultiPoint.getPrimitivesNumber(); ++i) {
                    Point point = intersectionMultiPoint.getPointAt(i);
                    double distance = Double.POSITIVE_INFINITY;
                    if (sideToExtend.equalsIgnoreCase(START_SIDE)) {
                        distance = point.distance((Geometry)arcToBeExtended.getInitPoint());
                    } else if (sideToExtend.equalsIgnoreCase(END_SIDE)) {
                        distance = point.distance((Geometry)arcToBeExtended.getEndPoint());
                    }
                    if (!(distance < minDistance)) continue;
                    intersection = point;
                    minDistance = distance;
                }
                continue;
            }
            if (!(intersectionGeometry instanceof Point)) continue;
            Point intersectionPoint = (Point)intersectionGeometry;
            double distance = Double.POSITIVE_INFINITY;
            if (sideToExtend.equalsIgnoreCase(START_SIDE)) {
                distance = intersectionPoint.distance((Geometry)arcToBeExtended.getInitPoint());
            } else if (sideToExtend.equalsIgnoreCase(END_SIDE)) {
                distance = intersectionPoint.distance((Geometry)arcToBeExtended.getEndPoint());
            }
            if (!(distance < minDistance)) continue;
            intersection = intersectionPoint;
            minDistance = distance;
        }
        it.dispose();
        return intersection;
    }

    public static Point arcIntersection(Arc arcToBeExtended, String sideToExtend, Geometry boundaryObject) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException, DataException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = arcToBeExtended.getGeometryType().getSubType();
        Point center = arcToBeExtended.getCenterPoint();
        double radius = center.distance((Geometry)arcToBeExtended.getInitPoint());
        Point intersection = null;
        Arc tmpArc = (Arc)geoManager.create(12, subtype);
        tmpArc.setPoints(center, radius, 0.0, Math.PI * 2);
        double distance = Double.POSITIVE_INFINITY;
        double minDistance = Double.POSITIVE_INFINITY;
        if (tmpArc.intersects(boundaryObject)) {
            Geometry intersectionGeometry = tmpArc.intersection(boundaryObject);
            if (intersectionGeometry instanceof Complex) {
                intersectionGeometry = ((Complex)intersectionGeometry).createAggregate(7, t -> t.getGeometryType().getType() == 7 || t.getGeometryType().getType() == 1);
            }
            if (intersectionGeometry instanceof MultiPoint) {
                MultiPoint intersectionMultiPoint = (MultiPoint)intersectionGeometry;
                for (int i = 0; i < intersectionMultiPoint.getPrimitivesNumber(); ++i) {
                    Point point = intersectionMultiPoint.getPointAt(i);
                    if (sideToExtend.equalsIgnoreCase(START_SIDE)) {
                        distance = point.distance((Geometry)arcToBeExtended.getInitPoint());
                    } else if (sideToExtend.equalsIgnoreCase(END_SIDE)) {
                        distance = point.distance((Geometry)arcToBeExtended.getEndPoint());
                    }
                    if (!(distance < minDistance)) continue;
                    intersection = point;
                    minDistance = distance;
                }
            } else if (intersectionGeometry instanceof Point) {
                Point intersectionPoint;
                intersection = intersectionPoint = (Point)intersectionGeometry;
            }
        }
        return intersection;
    }

    public static double getAngle(Point start, Point end) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double angle = Math.acos((end.getX() - start.getX()) / start.distance((Geometry)end));
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static Point getIntersectionOfProjectedLine(Point initPoint, Point endPoint, FeatureSelection boundaryObjects) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = initPoint.getGeometryType().getSubType();
        double module = initPoint.distance((Geometry)endPoint);
        double minDistance = Double.POSITIVE_INFINITY;
        Point intersectionPoint = null;
        double x1 = initPoint.getX();
        double y1 = initPoint.getY();
        double x2 = endPoint.getX();
        double y2 = endPoint.getY();
        for (int t = 1; t < 100; t += 10) {
            double x = (x2 - x1) * (double)t + x1;
            double y = (y2 - y1) * (double)t + y1;
            DisposableIterator it = boundaryObjects.fastIterator();
            while (it.hasNext()) {
                double distance;
                int i;
                Point projectedPoint;
                Feature feature = (Feature)it.next();
                Geometry geometry = feature.getDefaultGeometry();
                if (geometry.contains((Geometry)(projectedPoint = geoManager.createPoint(x, y, subtype)))) continue;
                Line tmpLine = geoManager.createLine(subtype);
                tmpLine.setPoints(initPoint, projectedPoint);
                if (!tmpLine.intersects(geometry)) continue;
                Geometry intersectionGeometry = geometry.intersection((Geometry)tmpLine);
                if (intersectionGeometry instanceof Complex) {
                    Aggregate intersection = ((Complex)intersectionGeometry).createAggregate(7, g -> g.getGeometryType().getType() == 7 || g.getGeometryType().getType() == 1);
                    if (intersection.getPrimitivesNumber() > 0) {
                        intersectionGeometry = intersection;
                    } else {
                        intersection = ((Complex)intersectionGeometry).createAggregate(21, g -> GeometryUtils.isSubtype((int)8, (int)g.getGeometryType().getType()) || GeometryUtils.isSubtype((int)2, (int)g.getGeometryType().getType()));
                        if (intersection.getPrimitivesNumber() > 0) {
                            intersectionGeometry = intersection.getPrimitiveAt(0);
                        }
                    }
                }
                if (intersectionGeometry instanceof Point) {
                    double distance2 = ((Point)intersectionGeometry).distance((Geometry)initPoint);
                    if (!(distance2 < minDistance) || !(distance2 > module + 0.01)) continue;
                    intersectionPoint = (Point)intersectionGeometry;
                    minDistance = distance2;
                    continue;
                }
                if (intersectionGeometry instanceof MultiPoint) {
                    MultiPoint intersectionMultiPoint = (MultiPoint)intersectionGeometry;
                    for (i = 0; i < intersectionMultiPoint.getPrimitivesNumber(); ++i) {
                        distance = intersectionMultiPoint.getPointAt(i).distance((Geometry)initPoint);
                        if (!(distance < minDistance) || !(distance > module + 0.01)) continue;
                        intersectionPoint = intersectionMultiPoint.getPointAt(i);
                        minDistance = distance;
                    }
                    continue;
                }
                if (!(intersectionGeometry instanceof Curve)) continue;
                Curve intersectionCurve = (Curve)intersectionGeometry;
                for (i = 0; i < intersectionCurve.getNumVertices(); ++i) {
                    distance = intersectionCurve.getVertex(i).distance((Geometry)endPoint);
                    if (!(distance < minDistance) || !(distance > module + 0.01)) continue;
                    intersectionPoint = intersectionCurve.getVertex(i);
                    minDistance = distance;
                }
            }
            it.dispose();
            if (intersectionPoint != null) break;
        }
        return intersectionPoint;
    }

    public static Point getIntersectionOfProjectedLine(Point initPoint, Point endPoint, Geometry boundaryObject) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, GeometryException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = initPoint.getGeometryType().getSubType();
        double module = initPoint.distance((Geometry)endPoint);
        double minDistance = Double.POSITIVE_INFINITY;
        Point intersectionPoint = null;
        double x1 = initPoint.getX();
        double y1 = initPoint.getY();
        double x2 = endPoint.getX();
        double y2 = endPoint.getY();
        double projectionLimit = 2.0 * endPoint.distance(boundaryObject);
        double step = projectionLimit / 10.0;
        for (double t = 1.0; t < projectionLimit; t += step) {
            double x = (x2 - x1) * t + x1;
            double y = (y2 - y1) * t + y1;
            Point projectedPoint = geoManager.createPoint(x, y, subtype);
            MultiLine boundaryObjectLines = boundaryObject.toLines();
            if (!boundaryObjectLines.contains((Geometry)projectedPoint)) {
                Line tmpLine = geoManager.createLine(subtype);
                tmpLine.setPoints(initPoint, projectedPoint);
                if (tmpLine.intersects(boundaryObject)) {
                    double distance;
                    int i;
                    Geometry intersectionGeometry = boundaryObjectLines.intersection((Geometry)tmpLine);
                    if (intersectionGeometry instanceof Complex) {
                        Aggregate intersection = ((Complex)intersectionGeometry).createAggregate(7, g -> g.getGeometryType().getType() == 7 || g.getGeometryType().getType() == 1);
                        if (intersection.getPrimitivesNumber() > 0) {
                            intersectionGeometry = intersection;
                        } else {
                            intersection = ((Complex)intersectionGeometry).createAggregate(21, g -> GeometryUtils.isSubtype((int)8, (int)g.getGeometryType().getType()) || GeometryUtils.isSubtype((int)2, (int)g.getGeometryType().getType()));
                            if (intersection.getPrimitivesNumber() > 0) {
                                intersectionGeometry = intersection.getPrimitiveAt(0);
                            }
                        }
                    }
                    if (intersectionGeometry instanceof Point) {
                        double distance2 = ((Point)intersectionGeometry).distance((Geometry)initPoint);
                        if (distance2 < minDistance && distance2 > module + 0.01) {
                            intersectionPoint = (Point)intersectionGeometry;
                            minDistance = distance2;
                        }
                    } else if (intersectionGeometry instanceof MultiPoint) {
                        MultiPoint intersectionMultiPoint = (MultiPoint)intersectionGeometry;
                        for (i = 0; i < intersectionMultiPoint.getPrimitivesNumber(); ++i) {
                            distance = intersectionMultiPoint.getPointAt(i).distance((Geometry)initPoint);
                            if (!(distance < minDistance) || !(distance > module + 0.01)) continue;
                            intersectionPoint = intersectionMultiPoint.getPointAt(i);
                            minDistance = distance;
                        }
                    } else if (intersectionGeometry instanceof Curve) {
                        Curve intersectionCurve = (Curve)intersectionGeometry;
                        for (i = 0; i < intersectionCurve.getNumVertices(); ++i) {
                            distance = intersectionCurve.getVertex(i).distance((Geometry)endPoint);
                            if (!(distance < minDistance) || !(distance > module + 0.01)) continue;
                            intersectionPoint = intersectionCurve.getVertex(i);
                            minDistance = distance;
                        }
                    }
                }
            } else {
                intersectionPoint = projectedPoint;
            }
            if (intersectionPoint != null) break;
        }
        return intersectionPoint;
    }
}

