/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.algorithm;

import java.util.List;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class RasterBaseAlgorithmLibrary
extends AbstractLibrary {
    public static final String REGISTER_PROCESS_LABEL = "DataProcess";
    public static final String REGISTER_INPUT_PARAMETERS_LABEL = "DataProcessInputParameters";
    public static final String REGISTER_OUTPUT_PARAMETERS_LABEL = "DataProcessOutputParameters";

    public static void register(String processLabel, Class<?> process) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add(REGISTER_PROCESS_LABEL);
        point.append(processLabel, "", process);
    }

    public static String getProcessName(Class<?> process) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add(REGISTER_PROCESS_LABEL);
        List it = point.getNames();
        for (int i = 0; i < it.size(); ++i) {
            Class value = point.get((String)it.get(i)).getExtension();
            if (value != process) continue;
            return (String)it.get(i);
        }
        return null;
    }

    public static String registerInputParameter(String parameterLabel, Class<?> parameterClass) {
        return RasterBaseAlgorithmLibrary.registerParameter(parameterLabel, parameterClass, REGISTER_INPUT_PARAMETERS_LABEL);
    }

    public static String registerOutputParameter(String parameterLabel, Class<?> parameterClass) {
        return RasterBaseAlgorithmLibrary.registerParameter(parameterLabel, parameterClass, REGISTER_OUTPUT_PARAMETERS_LABEL);
    }

    private static String registerParameter(String parameterLabel, Class<?> parameterClass, String type) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add(type);
        int i = 0;
        if (point.get(parameterLabel) == null) {
            point.append(parameterLabel, "", parameterClass);
            return parameterLabel;
        }
        if (point.get(parameterLabel).getExtension() == parameterClass) {
            return parameterLabel;
        }
        String newName = parameterLabel + "_" + i;
        while (point.get(newName) != null && point.get(newName).getExtension() != parameterClass) {
            newName = parameterLabel + "_" + ++i;
        }
        point.append(parameterLabel + "_" + i, "", parameterClass);
        return parameterLabel + "_" + i;
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        Messages.addResourceFamily((String)"org.gvsig.raster.algorithm.i18n.text", (ClassLoader)RasterBaseAlgorithmLibrary.class.getClassLoader(), (String)RasterBaseAlgorithmLibrary.class.getClass().getName());
    }

    public static RasterBaseAlgorithmManager getManager() {
        return RasterBaseAlgorithmManager.getInstance();
    }
}

