/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.algorithm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.raster.algorithm.gui.IIncrementable;
import org.gvsig.raster.algorithm.gui.IncrementableListener;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public abstract class ProcessParamsManagement
extends ProcessUtils
implements IIncrementable,
IncrementableListener,
Runnable,
Disposable {
    public static String ROI_EPSG = "ROI_EPSG";
    public static String WINDOW = "WINDOW";
    public static String OUTPUT_WIDTH = "OUTPUT_WIDTH";
    public static String OUTPUT_HEIGHT = "OUTPUT_HEIGHT";
    public static String PREVIEW = "PREVIEW";
    public static String TIME = "TIME";
    public static String PROCESS = "PROCESS";
    public static String PROCESS_NAME = "PROCESS_NAME";
    public static final String REGISTER_INPUT_PARAMETERS_LABEL = "RasterProcessInputParam";
    public static final String REGISTER_OUTPUT_PARAMETERS_LABEL = "RasterProcessOutputParam";
    private Extent outputWindow = null;
    private int outputWidth = 0;
    private int outputHeight = 0;
    private String roiEPSG = null;
    private boolean preview = false;
    private boolean globalParametersLoaded = false;
    protected Hashtable<String, Object> inputParameters = new Hashtable();
    protected HashMap<String, Object> outputParameters = new HashMap();

    public static void registerInputParameter(String parameterLabel, Class<?> parameterClass, String processLabel) {
        ProcessParamsManagement.registerParameter(processLabel, parameterLabel, parameterClass, REGISTER_INPUT_PARAMETERS_LABEL);
    }

    public static void registerOutputParameter(String parameterLabel, Class<?> parameterClass, String processLabel) {
        ProcessParamsManagement.registerParameter(processLabel, parameterLabel, parameterClass, REGISTER_OUTPUT_PARAMETERS_LABEL);
    }

    private static void registerParameter(String processLabel, String parameterLabel, Class<?> parameterClass, String type) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add(type + "_" + processLabel);
        point.append(parameterLabel, "", parameterClass);
        ProcessParamsManagement.registerGlobalInputParameters(parameterLabel, parameterClass, processLabel);
        ProcessParamsManagement.registerGlobalOutputParameters(parameterLabel, parameterClass, processLabel);
    }

    public static void registerGlobalInputParameters(String parameterLabel, Class<?> parameterClass, String processLabel) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("RasterProcessInputParam_" + processLabel);
        if (!point.has(ROI_EPSG)) {
            point.append(ROI_EPSG, "", String.class);
        }
        if (!point.has(WINDOW)) {
            point.append(WINDOW, "", Extent.class);
        }
        if (!point.has(OUTPUT_HEIGHT)) {
            point.append(OUTPUT_HEIGHT, "", Integer.class);
        }
        if (!point.has(OUTPUT_WIDTH)) {
            point.append(OUTPUT_WIDTH, "", Integer.class);
        }
        if (!point.has(PREVIEW)) {
            point.append(PREVIEW, "", Boolean.class);
        }
    }

    public static void registerGlobalOutputParameters(String parameterLabel, Class<?> parameterClass, String processLabel) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("RasterProcessOutputParam_" + processLabel);
        if (!point.has(TIME)) {
            point.append(TIME, "", Long.class);
        }
        if (!point.has(PROCESS)) {
            point.append(PROCESS, "", DataProcess.class);
        }
        if (!point.has(PROCESS_NAME)) {
            point.append(PROCESS_NAME, "", String.class);
        }
    }

    public List<String> getRasterTaskInputParameters(String processLabel) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("RasterProcessInputParam_" + processLabel);
        return point.getNames();
    }

    public List<String> getRasterTaskOutputParameters(String processLabel) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.add("RasterProcessOutputParam_" + processLabel);
        return point.getNames();
    }

    public Class<?> getParameterTypeByProcess(String processLabel, String parameterName) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterProcessInputParam_" + processLabel);
        return point.get(parameterName).getExtension();
    }

    public List<Class<?>> getParameterClassList(String processLabel, String parameterName) {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterProcessInputParam_" + processLabel);
        ArrayList classList = new ArrayList();
        for (Object obj : point) {
            classList.add((Class)obj);
        }
        return classList;
    }

    protected void finalize() throws Throwable {
        if (this.inputParameters != null) {
            this.inputParameters.clear();
            this.inputParameters = null;
        }
        super.finalize();
    }

    public void addParam(String key, Object param) {
        if (param != null) {
            this.inputParameters.put(key, param);
        } else {
            this.inputParameters.remove(key);
        }
    }

    public void removeParam(String key) {
        this.inputParameters.remove(key);
    }

    public Object getParam(String key) {
        this.loadGlobalParameters();
        return this.inputParameters.get(key);
    }

    public String getStringParam(String key) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(key);
        return value != null && value instanceof String ? (String)value : null;
    }

    public byte getByteParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof Byte ? (Byte)value : (byte)0;
    }

    public float getFloatParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof Float ? ((Float)value).floatValue() : 0.0f;
    }

    public double getDoubleParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof Double ? (Double)value : 0.0;
    }

    public int getIntParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof Integer ? (Integer)value : 0;
    }

    public boolean getBooleanParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof Boolean ? (Boolean)value : false;
    }

    public int[] getIntArrayParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof int[] ? (int[])value : null;
    }

    public double[] getDoubleArrayParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof double[] ? (double[])value : null;
    }

    public Extent getExtentParam(String name) {
        this.loadGlobalParameters();
        Object value = this.inputParameters.get(name);
        return value != null && value instanceof Extent ? (Extent)value : null;
    }

    protected String getROIEPSG() {
        return this.roiEPSG;
    }

    protected Extent getOutputWindow() {
        return this.outputWindow;
    }

    protected int getOutputWidth() {
        return this.outputWidth;
    }

    protected int getOutputHeight() {
        return this.outputHeight;
    }

    protected boolean isOutputRescaled() {
        return this.outputWidth != 0 || this.outputHeight != 0;
    }

    protected boolean isForPreviews() {
        return this.preview;
    }

    protected void loadGlobalParameters() {
        if (this.globalParametersLoaded) {
            return;
        }
        this.globalParametersLoaded = true;
        this.roiEPSG = this.getStringParam(ROI_EPSG);
        this.outputWindow = this.getParam(WINDOW) != null ? (Extent)this.getParam(WINDOW) : null;
        this.outputWidth = this.getIntParam(OUTPUT_WIDTH);
        this.outputHeight = this.getIntParam(OUTPUT_HEIGHT);
        this.preview = this.getBooleanParam(PREVIEW);
    }
}

