/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.core.ListItem;
import gishur.core.SimpleList;
import gishur.x.AreaIntersectable;
import gishur.x.IntersectionException;
import gishur.x.XHalfplane;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XUPolygon;

public class Area
implements AreaIntersectable {
    public static final byte TEST_CONVEXITY = 0;
    public static final byte ASSUME_NOT_CONVEX = 1;
    public static final byte ASSUME_CONVEX = 2;
    private AreaIntersectable[] _element;
    private byte _convexMode = 0;

    public XUPolygon xupolygon() {
        if (this._element.length == 1 && this._element[0] instanceof XUPolygon) {
            return (XUPolygon)this._element[0];
        }
        return null;
    }

    private Area areaIntersection(int n, AreaIntersectable areaIntersectable, boolean bl) {
        if (this._element[n].supportsIntersection(areaIntersectable, bl)) {
            return this._element[n].intersection(areaIntersectable, bl);
        }
        bl = this.convex(n);
        if (!areaIntersectable.supportsIntersection(this._element[n], bl)) {
            throw new IntersectionException(areaIntersectable, this._element[n]);
        }
        return areaIntersectable.intersection(this._element[n], bl);
    }

    public synchronized void set(AreaIntersectable areaIntersectable) {
        if (areaIntersectable == null) {
            return;
        }
        this._element = new AreaIntersectable[1];
        this._element[0] = areaIntersectable;
    }

    public synchronized void set(AreaIntersectable[] areaIntersectableArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < areaIntersectableArray.length) {
            if (areaIntersectableArray[n2] != null) {
                ++n;
            }
            ++n2;
        }
        this._element = new AreaIntersectable[n];
        n = 0;
        n2 = 0;
        while (n2 < areaIntersectableArray.length) {
            if (areaIntersectableArray[n2] != null) {
                this._element[n++] = areaIntersectableArray[n2];
            }
            ++n2;
        }
    }

    public synchronized void set(AreaIntersectable areaIntersectable, AreaIntersectable areaIntersectable2) {
        if (areaIntersectable == null && areaIntersectable2 == null) {
            return;
        }
        if (areaIntersectable == null) {
            areaIntersectable = areaIntersectable2;
            areaIntersectable2 = null;
        }
        if (areaIntersectable2 == null) {
            this.set(areaIntersectable);
            return;
        }
        this._element = new AreaIntersectable[2];
        this._element[0] = areaIntersectable;
        this._element[1] = areaIntersectable2;
    }

    public synchronized void set(SimpleList simpleList) {
        int n = 0;
        ListItem listItem = simpleList.first();
        while (listItem != null) {
            if (listItem.key() instanceof AreaIntersectable) {
                ++n;
            }
            listItem = listItem.next();
        }
        if (n == 0) {
            return;
        }
        this._element = new AreaIntersectable[n];
        n = 0;
        listItem = simpleList.first();
        while (listItem != null) {
            if (listItem.key() instanceof AreaIntersectable) {
                this._element[n++] = (AreaIntersectable)listItem.key();
            }
            listItem = listItem.next();
        }
    }

    public String toString() {
        String string = this.getClass().getName() + "[{";
        int n = 0;
        while (n < this._element.length - 1) {
            string = string + this._element[n] + ",";
            ++n;
        }
        if (this._element.length > 0) {
            string = string + this._element[this._element.length - 1];
        }
        string = string + "},";
        switch (this._convexMode) {
            case 0: {
                string = string + "test convexity";
                break;
            }
            case 2: {
                string = string + "assume area is convex";
                break;
            }
            case 1: {
                string = string + "assume area is not convex";
                break;
            }
            default: {
                string = string + "unkown convex-mode";
            }
        }
        return string + "]";
    }

    public Area() {
        this.clear();
    }

    public Area(AreaIntersectable areaIntersectable) {
        this.clear();
        this.set(areaIntersectable);
    }

    public Area(AreaIntersectable areaIntersectable, AreaIntersectable areaIntersectable2) {
        this.clear();
        this.set(areaIntersectable, areaIntersectable2);
    }

    public Area(AreaIntersectable[] areaIntersectableArray) {
        this.clear();
        this.set(areaIntersectableArray);
    }

    public Area(SimpleList simpleList) {
        this.clear();
        this.set(simpleList);
    }

    public synchronized void add(AreaIntersectable areaIntersectable) {
        if (areaIntersectable == null) {
            return;
        }
        if (this._element.length < 1) {
            this._element = new AreaIntersectable[1];
            this._element[0] = areaIntersectable;
            return;
        }
        AreaIntersectable[] areaIntersectableArray = new AreaIntersectable[this._element.length + 1];
        try {
            System.arraycopy(this._element, 0, areaIntersectableArray, 0, this._element.length);
            areaIntersectableArray[this._element.length] = areaIntersectable;
            this._element = areaIntersectableArray;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }

    public void setConvexMode(byte by) {
        this._convexMode = by;
    }

    public byte convexMode() {
        return this._convexMode;
    }

    public AreaIntersectable element(int n) {
        if (n < 0 || n >= this._element.length) {
            return null;
        }
        return this._element[n];
    }

    public XHalfplane xhalfplane() {
        if (this._element.length == 1 && this._element[0] instanceof XHalfplane) {
            return (XHalfplane)this._element[0];
        }
        return null;
    }

    public boolean supportsIntersection(AreaIntersectable areaIntersectable, boolean bl) {
        boolean bl2 = true;
        int n = 0;
        while (n < this._element.length && bl2) {
            bl2 = this._element[n].supportsIntersection(areaIntersectable, bl);
            ++n;
        }
        return bl2;
    }

    public byte locate(XPoint xPoint) {
        byte by = 3;
        int n = 0;
        while (n < this._element.length && by == 3) {
            by = this._element[n].locate(xPoint);
            ++n;
        }
        return by;
    }

    public Area intersection(AreaIntersectable areaIntersectable, boolean bl) {
        if (this._element.length <= 0) {
            return new Area();
        }
        Area[] areaArray = new Area[this._element.length];
        int n = 0;
        while (n < this._element.length) {
            areaArray[n] = this.areaIntersection(n, areaIntersectable, bl);
            ++n;
        }
        if (this._element.length == 1) {
            if (areaArray[0] != null) {
                return areaArray[0];
            }
            return new Area();
        }
        Area area = this.concat(areaArray);
        return area;
    }

    public boolean empty() {
        return this._element.length < 1;
    }

    public void clear() {
        this._element = new AreaIntersectable[0];
    }

    public Area intersection(Area area) {
        Area[] areaArray = new Area[area._element.length];
        int n = 0;
        while (n < area._element.length) {
            areaArray[n] = this.intersection(area._element[n], area.convex(n));
            ++n;
        }
        area = this.concat(areaArray);
        return area;
    }

    private Area concat(Area[] areaArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < areaArray.length) {
            if (areaArray[n3] != null) {
                n2 += areaArray[n3].length();
            }
            ++n3;
        }
        if (n2 == 0) {
            return new Area();
        }
        AreaIntersectable[] areaIntersectableArray = new AreaIntersectable[n2];
        boolean bl = true;
        boolean bl2 = true;
        n3 = 0;
        while (n3 < areaArray.length) {
            if (areaArray[n3] != null) {
                if (areaArray[n3].convexMode() == 2) {
                    bl2 = false;
                } else {
                    bl = false;
                }
                int n4 = 0;
                while (n4 < areaArray[n3]._element.length) {
                    areaIntersectableArray[n++] = areaArray[n3]._element[n4];
                    ++n4;
                }
            }
            ++n3;
        }
        Area area = new Area(areaIntersectableArray);
        if (bl) {
            area.setConvexMode((byte)2);
        }
        if (bl2) {
            area.setConvexMode((byte)1);
        }
        return area;
    }

    public int length() {
        return this._element.length;
    }

    public boolean convex() {
        switch (this._convexMode) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 0: {
                boolean bl = true;
                int n = 0;
                while (n < this._element.length && bl) {
                    bl = bl && this._element[n].convex();
                    ++n;
                }
                return bl;
            }
        }
        return false;
    }

    public boolean convex(int n) {
        if (n < 0 || n >= this._element.length) {
            return false;
        }
        switch (this._convexMode) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 0: {
                return this._element[n].convex();
            }
        }
        return false;
    }

    public XPolygon xpolygon() {
        if (this._element.length == 1 && this._element[0] instanceof XPolygon) {
            return (XPolygon)this._element[0];
        }
        return null;
    }
}

