/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.x.AffineXTransformable;
import gishur.x.Intersectable;
import gishur.x.Intersection;
import gishur.x.IntersectionException;
import gishur.x.XLine;
import gishur.x.XObject;
import gishur.x.XPoint;
import gishur.x.XPolygon;
import gishur.x.XSegment;

public class XBaseline
extends XObject
implements Intersectable,
AffineXTransformable {
    public static final byte DIRECTION_RIGHT = 1;
    public static final byte DIRECTION_LEFT = 2;
    public static final byte DIRECTION_UP = 3;
    public static final byte DIRECTION_DOWN = 4;
    private static final double _EPSILON = 5.0E-8;
    public static final double INFINITE_BOUND = 2.0E7;
    XPoint _source;
    XPoint _target;

    public final XPoint getPointInLineDirection(XPoint xPoint, double d) {
        XPoint xPoint2 = new XPoint(xPoint.x, xPoint.y);
        xPoint2.translatePolar(this._source.angle(this._target), d);
        return xPoint2;
    }

    Object simpleIntersection(XBaseline xBaseline) {
        double d = this.slope();
        double d2 = xBaseline.slope();
        double d3 = this.y_abs();
        double d4 = xBaseline.y_abs();
        if (d == d2) {
            if (this.liesOn(xBaseline._source)) {
                return this;
            }
            return null;
        }
        double d5 = this.vertical() ? this._source.x : (xBaseline.vertical() ? xBaseline._source.x : (d4 - d3) / (d - d2));
        double d6 = this.vertical() ? d2 * d5 + d4 : d * d5 + d3;
        return new XPoint(d5, d6);
    }

    public boolean liesOn(XPoint xPoint) {
        if (xPoint == null) {
            return false;
        }
        return this.contains(xPoint.x, xPoint.y);
    }

    boolean inBounds(double d, double d2) {
        return true;
    }

    public boolean parallel(XBaseline xBaseline) {
        return this.slope() == xBaseline.slope();
    }

    public static final int getInfiniteBoundIndex(XPoint xPoint) {
        if (xPoint.y <= -2.0E7) {
            return 0;
        }
        if (xPoint.x >= 2.0E7) {
            return 1;
        }
        if (xPoint.y >= 2.0E7) {
            return 2;
        }
        if (xPoint.x <= -2.0E7) {
            return 3;
        }
        return -1;
    }

    public double angle() {
        return this._source.angle(this._target);
    }

    public double angle(XBaseline xBaseline) {
        return XPoint.angle(0.0, 0.0, this._target.x - this._source.x, this._target.y - this._source.y, xBaseline._target.x - xBaseline._source.x, xBaseline._target.y - xBaseline._source.y);
    }

    public boolean supportsIntersection(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof XPoint;
    }

    public XPoint source() {
        return this._source;
    }

    public double slope() {
        if (this.vertical()) {
            return Double.POSITIVE_INFINITY;
        }
        return (this._source.y - this._target.y) / (this._source.x - this._target.x);
    }

    public boolean similarDirection(XBaseline xBaseline) {
        XPoint xPoint = this.getDirectionVector();
        XPoint xPoint2 = xBaseline.getDirectionVector();
        double d = XPoint.angle(0.0, 0.0, xPoint2.x, xPoint2.y, xPoint.x, xPoint.y);
        return d <= 1.5707963267948966 || d >= 4.71238898038469;
    }

    public XPoint plumbTo(XPoint xPoint, XBaseline xBaseline) {
        Intersection intersection = xBaseline.intersection(this.orthogonal(xPoint));
        return intersection.xpoint();
    }

    public boolean incident(XBaseline xBaseline) {
        return false;
    }

    public static final XPoint getInfinitePoint(int n) {
        switch (n) {
            case 0: {
                return new XPoint(-2.0E7, -2.0E7);
            }
            case 1: {
                return new XPoint(2.0E7, -2.0E7);
            }
            case 2: {
                return new XPoint(2.0E7, 2.0E7);
            }
            case 3: {
                return new XPoint(-2.0E7, 2.0E7);
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof XBaseline) {
            return this.slope() == ((XBaseline)object).slope() && this.y_abs() == ((XBaseline)object).y_abs();
        }
        return false;
    }

    public XPoint getDirectionVector() {
        return new XPoint(this._target.x - this._source.x, this._target.y - this._source.y);
    }

    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d * this._source.x + d2 * this._source.y + d3;
        double d8 = d4 * this._source.x + d5 * this._source.y + d6;
        this._source.set(d7, d8);
        d7 = d * this._target.x + d2 * this._target.y + d3;
        d8 = d4 * this._target.x + d5 * this._target.y + d6;
        this._target.set(d7, d8);
    }

    public static final XPolygon getInfiniteBounds() {
        XPoint[] xPointArray = new XPoint[]{new XPoint(-2.0E7, -2.0E7), new XPoint(2.0E7, -2.0E7), new XPoint(2.0E7, 2.0E7), new XPoint(-2.0E7, 2.0E7)};
        return new XPolygon(xPointArray);
    }

    public XPoint target() {
        return this._target;
    }

    public boolean vertical() {
        return this._source.x == this._target.x;
    }

    public double y_abs() {
        if (this.vertical()) {
            return Double.NEGATIVE_INFINITY;
        }
        return this._source.y - (this._source.y - this._target.y) / (this._source.x - this._target.x) * this._source.x;
    }

    public void scale(XPoint xPoint, double d, double d2) {
        this.transform(d, 0.0, -d * xPoint.x + xPoint.x, 0.0, d2, -d2 * xPoint.y + xPoint.y);
    }

    private static final boolean infiniteBefore(XPoint xPoint, XPoint xPoint2) {
        if (xPoint.y <= -2.0E7) {
            return xPoint.x < xPoint2.x;
        }
        if (xPoint.x >= 2.0E7) {
            return xPoint.y < xPoint2.y;
        }
        if (xPoint.y >= 2.0E7) {
            return xPoint.x > xPoint2.x;
        }
        if (xPoint.x <= -2.0E7) {
            return xPoint.y > xPoint2.y;
        }
        return true;
    }

    public XPoint plumb(XPoint xPoint) {
        Intersection intersection = this.intersection(this.orthogonal(xPoint));
        return intersection.xpoint();
    }

    public static final byte oppositeDirection(byte by) {
        switch (by) {
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return by;
    }

    Object baseIntersection(XBaseline xBaseline) {
        double d = this._target.x - this._source.x;
        double d2 = this._target.y - this._source.y;
        double d3 = xBaseline._target.x - xBaseline._source.x;
        double d4 = xBaseline._target.y - xBaseline._source.y;
        double d5 = d * d4 - d2 * d3;
        double d6 = (Math.abs(this._target.x) + Math.abs(this._source.x)) * (Math.abs(xBaseline._target.y) + Math.abs(xBaseline._source.y)) + (Math.abs(this._target.y) + Math.abs(this._source.y)) * (Math.abs(xBaseline._target.x) + Math.abs(xBaseline._source.x));
        if (d == 0.0 && d4 == 0.0) {
            return new XPoint(this._source.x, xBaseline._source.y);
        }
        if (d3 == 0.0 && d2 == 0.0) {
            return new XPoint(xBaseline._source.x, this._source.y);
        }
        if (Math.abs(d5) <= d6 * 5.0E-8) {
            if (this.liesOn(xBaseline._source)) {
                return this;
            }
            return null;
        }
        double d7 = xBaseline._source.x - this._source.x;
        double d8 = xBaseline._source.y - this._source.y;
        double d9 = (d7 * d4 - d8 * d3) / d5;
        double d10 = (d7 * d2 - d8 * d) / d5;
        double d11 = 0.0;
        double d12 = 0.0;
        d11 = d3 == 0.0 || d10 == 0.0 ? xBaseline._source.x : this._source.x + d9 * d;
        d12 = d4 == 0.0 || d10 == 0.0 ? xBaseline._source.y : this._source.y + d9 * d2;
        return new XPoint(d11, d12);
    }

    public void set(double d, double d2, double d3, double d4) {
        this._source = new XPoint(d, d2);
        this._target = new XPoint(d3, d4);
    }

    public void set(XPoint xPoint, XPoint xPoint2) {
        if (xPoint == null || xPoint2 == null) {
            return;
        }
        this.set(xPoint.x, xPoint.y, xPoint2.x, xPoint2.y);
    }

    public XLine orthogonal(XPoint xPoint) {
        double d = this._target.x - this._source.x;
        double d2 = this._target.y - this._source.y;
        XPoint xPoint2 = (XPoint)xPoint.clone();
        XPoint xPoint3 = new XPoint(xPoint2.x + d2, xPoint2.y - d);
        return new XLine(xPoint2, xPoint3);
    }

    public String toString() {
        return this.getClass().getName() + "[slope=" + this.slope() + ",(0," + this.y_abs() + ")]";
    }

    public void rotate(XPoint xPoint, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.transform(d2, -d3, -xPoint.x * d2 + xPoint.y * d3 + xPoint.x, d3, d2, -xPoint.x * d3 - xPoint.y * d2 + xPoint.y);
    }

    public void rotate(XPoint xPoint, XPoint xPoint2, XPoint xPoint3) {
        this.rotate(xPoint, xPoint.angle(xPoint2, xPoint3));
    }

    public void translate(double d, double d2) {
        this.transform(1.0, 0.0, d, 0.0, 1.0, d2);
    }

    public XLine orthogonal() {
        return this.orthogonal(this._source);
    }

    public static final void copyInfiniteChain(XPoint xPoint, XPoint xPoint2, XPoint[] xPointArray, int n) {
        int n2 = XBaseline.getInfiniteBoundIndex(xPoint);
        int n3 = XBaseline.getInfiniteBoundIndex(xPoint2);
        int n4 = n2;
        int n5 = n;
        xPointArray[n5] = xPoint;
        while (n4 != n3 || n4 == n3 && XBaseline.infiniteBefore(xPoint2, xPointArray[n5])) {
            n4 = (n4 + 1) % 4;
            xPointArray[++n5] = XBaseline.getInfinitePoint(n4);
        }
        xPointArray[++n5] = xPoint2;
    }

    public XSegment getInfiniteSegment() {
        return new XSegment(this.getInfiniteEndPoint(false), this.getInfiniteEndPoint(true));
    }

    public boolean contains(double d, double d2) {
        if (this.vertical()) {
            return Math.abs(d - this._source.x) < 1.0E-7;
        }
        XPoint xPoint = this.calculatePoint(d);
        if (xPoint != null) {
            return xPoint.equals(d, d2);
        }
        return false;
    }

    public void flip() {
        XPoint xPoint = this._source;
        this._source = this._target;
        this._target = xPoint;
    }

    public XPoint vector(boolean bl, boolean bl2, boolean bl3) {
        XPoint xPoint = new XPoint(this._target.x - this._source.x, this._target.y - this._source.y);
        if (bl3) {
            xPoint.normalize();
        }
        if (bl2) {
            xPoint.set(-xPoint.y, xPoint.x);
        }
        if (!bl) {
            xPoint.set(-xPoint.x, -xPoint.y);
        }
        return xPoint;
    }

    public Intersection intersection(Object object) {
        if (this.supportsIntersection(object)) {
            if (object instanceof XPoint) {
                if (this.liesOn((XPoint)object)) {
                    return new Intersection(((XPoint)object).clone());
                }
                return new Intersection();
            }
        } else {
            if (object instanceof Intersectable && ((Intersectable)object).supportsIntersection(this)) {
                return ((Intersectable)object).intersection(this);
            }
            throw new IntersectionException(this, this, object);
        }
        throw new IntersectionException(this, this, object);
    }

    public byte direction() {
        if (this._source.x < this._target.x) {
            return 1;
        }
        if (this._source.x > this._target.x) {
            return 2;
        }
        if (this._source.y < this._target.y) {
            return 3;
        }
        return 4;
    }

    public XObject transform_XObject(double d, double d2, double d3, double d4, double d5, double d6) {
        this.transform(d, d2, d3, d4, d5, d6);
        return this;
    }

    public void rotateTo(double d, double d2) {
        this.set(this._source.x, this._source.y, d, d2);
    }

    public XPoint calculatePoint(double d) {
        if (this.vertical()) {
            if (Math.abs(d - this._source.x) <= 1.0E-7) {
                return new XPoint(this._source.x, Double.POSITIVE_INFINITY);
            }
            return null;
        }
        double d2 = (this._source.y - this._target.y) / (this._source.x - this._target.x);
        double d3 = this._source.y - d2 * this._source.x;
        return new XPoint(d, d2 * d + d3);
    }

    public XPoint closestPoint(XPoint xPoint) {
        XPoint xPoint2 = this.plumb(xPoint);
        if (xPoint2 != null) {
            return xPoint2;
        }
        xPoint2 = xPoint.squareDistance(this._source) <= xPoint.squareDistance(this._target) ? new XPoint(this._source) : new XPoint(this._target);
        return xPoint2;
    }

    public XPoint getInfiniteEndPoint(boolean bl) {
        XPoint xPoint;
        boolean bl2 = bl;
        if (this.vertical()) {
            if (this._source.y > this._target.y) {
                boolean bl3 = bl2 = !bl2;
            }
            xPoint = bl2 ? new XPoint(this._source.x, 2.0E7) : new XPoint(this._source.x, -2.0E7);
        } else {
            double d = (this._source.y - this._target.y) / (this._source.x - this._target.x);
            double d2 = this._source.y - d * this._source.x;
            if (this._source.x > this._target.x) {
                bl2 = !bl2;
            }
            xPoint = bl2 ? new XPoint(2.0E7, d * 2.0E7 + d2) : new XPoint(-2.0E7, d * -2.0E7 + d2);
            if (xPoint.y < -2.0E7 || xPoint.y > 2.0E7) {
                bl2 = bl;
                if (this._source.y > this._target.y) {
                    bl2 = !bl2;
                }
                xPoint = bl2 ? new XPoint((2.0E7 - d2) / d, 2.0E7) : new XPoint((-2.0E7 - d2) / d, -2.0E7);
            }
        }
        if (this.liesOn(xPoint)) {
            return xPoint;
        }
        if (bl) {
            return this._target;
        }
        return this._source;
    }

    public boolean horizontal() {
        return this._source.y == this._target.y;
    }

    public byte orientation(XPoint xPoint) {
        return xPoint.orientation(this._source, this._target);
    }
}

