/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.configurableactions.ConfigurableActionsMamager;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.DoubleDocumentFilter;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyDataSetResolver;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.swing.api.JTopologyPlanProperties;
import org.gvsig.topology.swing.impl.DefaultJTopologyPlanPropertiesView;
import org.gvsig.topology.swing.impl.RuleProperties;
import org.gvsig.topology.swing.impl.SelectDataSetDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJTopologyPlanProperties
extends DefaultJTopologyPlanPropertiesView
implements JTopologyPlanProperties,
TopologyDataSetResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJTopologyPlanProperties.class);

    public DefaultJTopologyPlanProperties() {
        this.initComponents();
    }

    private void initComponents() {
        ConfigurableActionsMamager cfgActionsManager = ToolsUtilLocator.getConfigurableActionsMamager();
        JComponent c = cfgActionsManager.getConfigurableActionsComponent("TopologyPlanPropertiesPanel", (Object)this);
        this.pnlCfgActions.setLayout(new BorderLayout(0, 0));
        this.pnlCfgActions.add((Component)c, "Center");
        this.rdbAcceptExceptions.setVisible(true);
        this.rdbAcceptExceptions.setSelected(false);
        this.rdbAcceptExceptions.setEnabled(false);
        this.translate();
        this.btnAddDataSet.addActionListener(e -> this.performAddDataSet());
        this.btnRemoveDataSet.addActionListener(e -> this.performRemoveDataSet());
        this.btnAddRule.addActionListener(e -> this.performAddRule());
        this.btnEditRule.addActionListener(e -> this.performEditRule());
        this.btnRemoveRule.addActionListener(e -> this.performRemoveRule());
        this.lstDataSets.setModel(new DefaultListModel());
        this.lstDataSets.addListSelectionListener(e -> this.performDataSetSelected());
        this.lstRules.setModel(new DefaultListModel());
        this.lstRules.addListSelectionListener(e -> this.performRuleSelected());
        DoubleDocumentFilter.install((JTextField)this.txtTolerance);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)12, (int)60, (int)20, (int)110);
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String name = FilenameUtils.getBaseName((String)imageName);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = this.getClass().getResource("/" + imageName);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    private void translate() {
        ToolsSwingManager tsm = ToolsSwingLocator.getToolsSwingManager();
        tsm.translate((AbstractButton)this.btnAddRule);
        tsm.translate((AbstractButton)this.btnRemoveRule);
        tsm.translate((AbstractButton)this.btnAddDataSet);
        tsm.translate((AbstractButton)this.btnRemoveDataSet);
        tsm.translate(this.lblName);
        tsm.translate(this.tabPanel);
        tsm.translate(this.lblTolerance);
        tsm.translate((AbstractButton)this.rdbAcceptExceptions);
    }

    public void performDataSetSelected() {
        if (this.lstDataSets.getValueIsAdjusting()) {
            return;
        }
        this.btnRemoveDataSet.setEnabled(!this.lstDataSets.isSelectionEmpty());
    }

    public void performRuleSelected() {
        if (this.lstRules.getValueIsAdjusting()) {
            return;
        }
        this.btnRemoveRule.setEnabled(!this.lstRules.isSelectionEmpty());
    }

    public void put(TopologyPlan thePlan) {
        this.txtName.setText(thePlan.getName());
        this.txtTolerance.setText(String.valueOf(thePlan.getTolerance()));
        this.lstDataSets.removeAll();
        DefaultListModel<TopologyDataSet> modelDataSets = new DefaultListModel<TopologyDataSet>();
        for (TopologyDataSet dataSet : thePlan.getDataSets()) {
            modelDataSets.addElement(dataSet);
        }
        this.lstDataSets.setModel(modelDataSets);
        this.lstRules.removeAll();
        DefaultListModel<ListElement> modelRules = new DefaultListModel<ListElement>();
        for (TopologyRule rule : thePlan.getRules()) {
            try {
                modelRules.addElement(new ListElement(rule.getName() + " [" + rule.getDataSet1().getName() + "]", (Object)rule.clone()));
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.warn("Can't clone rule,", (Throwable)ex);
            }
        }
        this.lstRules.setModel(modelRules);
        this.rdbAcceptExceptions.setSelected(thePlan.getAcceptExceptions());
    }

    public TopologyPlan fetch(TopologyPlan thePlan) {
        if (thePlan == null) {
            thePlan = TopologyLocator.getTopologyManager().createTopologyPlan();
        } else {
            thePlan.clear();
        }
        thePlan.setName(thePlan.getName());
        if (!DoubleDocumentFilter.isEmpty((JTextField)this.txtTolerance)) {
            thePlan.setTolerance(DoubleDocumentFilter.getValue((JTextField)this.txtTolerance));
        }
        ListModel modelDataSets = this.lstDataSets.getModel();
        for (int i = 0; i < modelDataSets.getSize(); ++i) {
            thePlan.addDataSet((TopologyDataSet)modelDataSets.getElementAt(i));
        }
        ListModel modelRules = this.lstRules.getModel();
        for (int i = 0; i < modelRules.getSize(); ++i) {
            thePlan.addRule((TopologyRule)((ListElement)modelRules.getElementAt(i)).getValue());
        }
        thePlan.setAcceptExceptions(this.rdbAcceptExceptions.isSelected());
        return thePlan;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void performAddDataSet() {
        List<TopologyDataSet> dataSets;
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        SelectDataSetDialog panel = new SelectDataSetDialog();
        Dialog dlg = winManager.createDialog((JComponent)panel, i18n.getTranslation("_Select_a_dataset"), null, 3);
        panel.setDialog(dlg);
        dlg.show(WindowManager.MODE.DIALOG);
        if (dlg.getAction() == 1 && (dataSets = panel.getDataSets()) != null) {
            for (TopologyDataSet dataSet : dataSets) {
                ThreadSafeDialogsManager dialogs;
                int res;
                int subtype;
                FeatureAttributeDescriptor geomAttr;
                FeatureType featType = dataSet.getFeatureStore().getDefaultFeatureTypeQuietly();
                if (featType != null && (geomAttr = featType.getDefaultGeometryAttribute()) != null && (subtype = geomAttr.getGeomType().getSubType()) != 0 && subtype != 2 && (res = (dialogs = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_The_dataset_XnameX_is_neither_2D_nor_2DM_The_result_of_the_topological_checks_may_not_be_what_you_expect_Do_you_want_to_continue", new String[]{dataSet.getName()}), i18n.getTranslation("_Add_dataset"), 0, 2, "_Add_non_2D_topology_dataset")) != 0) continue;
                DefaultListModel model = (DefaultListModel)this.lstDataSets.getModel();
                model.addElement(dataSet);
            }
        }
    }

    private void performRemoveDataSet() {
        if (this.lstDataSets.getValueIsAdjusting()) {
            return;
        }
        if (this.lstDataSets.isSelectionEmpty()) {
            return;
        }
        int index = this.lstDataSets.getSelectedIndex();
        ((DefaultListModel)this.lstDataSets.getModel()).remove(index);
    }

    private void performAddRule() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        TopologyPlan plan = this.fetch(null);
        RuleProperties panel = new RuleProperties(plan, 0);
        Dialog dlg = winManager.createDialog((JComponent)panel, i18n.getTranslation("_Add_new_rule"), null, 3);
        panel.setDialog(dlg);
        dlg.addActionListener(e -> {
            TopologyRule rule;
            if (dlg.getAction() == 1 && (rule = panel.getRule()) != null) {
                rule.setDataSetResolver((TopologyDataSetResolver)this);
                DefaultListModel model = (DefaultListModel)this.lstRules.getModel();
                model.addElement(new ListElement(rule.getName() + " [" + rule.getDataSet1().getName() + "]", (Object)rule));
            }
        });
        dlg.show(WindowManager.MODE.WINDOW);
    }

    private void performEditRule() {
        if (this.lstRules.getValueIsAdjusting()) {
            return;
        }
        if (this.lstRules.isSelectionEmpty()) {
            return;
        }
        TopologyRule rule = (TopologyRule)ListElement.getSelected((JList)this.lstRules);
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        TopologyPlan plan = this.fetch(null);
        RuleProperties panel = new RuleProperties(plan, 1);
        panel.setRule(rule);
        Dialog dlg = winManager.createDialog((JComponent)panel, i18n.getTranslation("_Modify_rule"), null, 3);
        panel.setDialog(dlg);
        dlg.addActionListener(e -> {
            TopologyRule r;
            if (dlg.getAction() == 1 && (r = panel.getRule()) != null) {
                rule.fromJson(r.toJson());
            }
        });
        dlg.show(WindowManager.MODE.WINDOW);
    }

    private void performRemoveRule() {
        if (this.lstRules.getValueIsAdjusting()) {
            return;
        }
        if (this.lstRules.isSelectionEmpty()) {
            return;
        }
        int index = this.lstRules.getSelectedIndex();
        TopologyRule rule = (TopologyRule)ListElement.getSelected((JList)this.lstRules);
        ((DefaultListModel)this.lstRules.getModel()).remove(index);
    }

    private void doCopyTopologyPlanToClipboard() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        TopologyPlan plan = this.fetch(null);
        String s = plan.toJson().toString();
        toolsSwingManager.putInClipboard(s);
    }

    public TopologyDataSet getDataSet(String name) {
        ListModel modelDataSets = this.lstDataSets.getModel();
        for (int i = 0; i < modelDataSets.getSize(); ++i) {
            TopologyDataSet dataset = (TopologyDataSet)modelDataSets.getElementAt(i);
            if (!StringUtils.equals((CharSequence)dataset.getName(), (CharSequence)name)) continue;
            return dataset;
        }
        return null;
    }

    public static class CopyTopologyPlanToClipboardAction
    extends AbstractAction {
        public CopyTopologyPlanToClipboardAction() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.putValue("Name", i18n.getTranslation("_Copy_topology_Plan_to_clipboard"));
            this.putValue("ActionCommandKey", "CopyTopologyPLanToClipboard");
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                return i18n.getTranslation("_Copy_topology_Plan_to_clipboard");
            }
            return super.getValue(key);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultJTopologyPlanProperties panel = (DefaultJTopologyPlanProperties)ae.getSource();
            panel.doCopyTopologyPlanToClipboard();
        }
    }
}

