/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.topology.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.documentfilters.DoubleDocumentFilter;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.topology.lib.api.TopologyDataSet;
import org.gvsig.topology.lib.api.TopologyLocator;
import org.gvsig.topology.lib.api.TopologyManager;
import org.gvsig.topology.lib.api.TopologyPlan;
import org.gvsig.topology.lib.api.TopologyRule;
import org.gvsig.topology.lib.api.TopologyRuleFactory;
import org.gvsig.topology.swing.impl.RulePropertiesView;

public class RuleProperties
extends RulePropertiesView {
    public static final int MODE_CREATE = 0;
    public static final int MODE_MODIFY = 1;
    private final TopologyPlan plan;
    private Dialog dialog;
    private DynObject parameters;
    private JDynForm form;
    private final int mode;
    private final JDynForm.JDynFormListener formListener;

    RuleProperties(TopologyPlan plan, int mode) {
        this.plan = plan;
        this.mode = mode;
        this.dialog = null;
        this.parameters = null;
        this.form = null;
        this.formListener = new JDynForm.JDynFormListener(){

            public void message(String message) {
            }

            public void fieldChanged(JDynFormField field) {
                RuleProperties.this.updateEnabledComponents();
            }
        };
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.translate();
        ToolsSwingUtils.ensureRowsCols((JComponent)this.lblDataSet1, (int)-1, (int)30, (int)-1, (int)50);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtDescription);
        DefaultComboBoxModel<TopologyDataSet> model1 = new DefaultComboBoxModel<TopologyDataSet>();
        for (TopologyDataSet dataSet : this.plan.getDataSets()) {
            model1.addElement(dataSet);
        }
        this.cboDataSet1.setModel(model1);
        this.cboDataSet1.setSelectedIndex(-1);
        this.cboDataSet1.addItemListener(e -> this.performDataSet1Selected());
        this.cboDataSet1.setRenderer(new DataSetListCellRenderer());
        this.cboDataSet2.setRenderer(new DataSetListCellRenderer());
        this.cboRule.addItemListener(e -> this.performRuleSelected());
        DoubleDocumentFilter.install((JTextField)this.txtTolerance);
        DoubleDocumentFilter.setValue((JTextField)this.txtTolerance, (double)this.plan.getTolerance());
        this.setOkButtonEnabled(false);
        this.cboRule.setSelectedIndex(-1);
        this.cboRule.setEnabled(false);
        this.cboDataSet2.setEnabled(false);
        this.cboDataSet2.setSelectedItem(-1);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)12, (int)80, (int)20, (int)110);
        this.updateEnabledComponents();
    }

    public void setDialog(Dialog dialog) {
        this.dialog = dialog;
        this.updateEnabledComponents();
    }

    private void setOkButtonEnabled(boolean enabled) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setButtonEnabled(1, enabled);
    }

    private void translate() {
        ToolsSwingManager tsm = ToolsSwingLocator.getToolsSwingManager();
        tsm.translate(this.lblDataSet1);
        tsm.translate(this.lblDataSet2);
        tsm.translate(this.lblRule);
        tsm.translate(this.lblTolerance);
    }

    private void updateEnabledComponents() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::updateEnabledComponents);
            return;
        }
        switch (this.mode) {
            case 0: {
                this.cboDataSet1.setEnabled(true);
                this.cboRule.setEnabled(true);
                break;
            }
            case 1: {
                this.cboDataSet1.setEnabled(false);
                this.cboRule.setEnabled(false);
            }
        }
        TopologyDataSet dataSet = (TopologyDataSet)this.cboDataSet1.getSelectedItem();
        if (dataSet == null) {
            this.cboRule.setEnabled(false);
            this.cboDataSet2.setEnabled(false);
            this.txtTolerance.setEnabled(false);
            this.tabCreateRulePanel.setEnabledAt(1, false);
            this.setOkButtonEnabled(false);
            return;
        }
        TopologyRuleFactory ruleFactory = (TopologyRuleFactory)this.cboRule.getSelectedItem();
        if (ruleFactory == null) {
            this.cboDataSet2.setEnabled(false);
            this.txtTolerance.setEnabled(false);
            this.tabCreateRulePanel.setEnabledAt(1, false);
            this.setOkButtonEnabled(false);
            return;
        }
        this.cboDataSet2.setEnabled(ruleFactory.hasSecondaryDataSet());
        this.txtTolerance.setEnabled(true);
        this.tabCreateRulePanel.setEnabledAt(1, ruleFactory.hasRuleParameters());
        if (this.parameters != null && this.form != null && !this.form.hasValidValues()) {
            this.setOkButtonEnabled(false);
            return;
        }
        this.setOkButtonEnabled(!DoubleDocumentFilter.isEmpty((JTextField)this.txtTolerance));
    }

    private void performDataSet1Selected() {
        TopologyDataSet dataSet = (TopologyDataSet)this.cboDataSet1.getSelectedItem();
        if (dataSet == null) {
            this.updateEnabledComponents();
            return;
        }
        TopologyManager manager = TopologyLocator.getTopologyManager();
        List rules = manager.getRuleFactories(dataSet);
        Collections.sort(rules, (o1, o2) -> {
            try {
                return o1.getName().compareTo(o2.getName());
            }
            catch (Throwable th) {
                return 0;
            }
        });
        DefaultComboBoxModel<TopologyRuleFactory> model1 = new DefaultComboBoxModel<TopologyRuleFactory>();
        for (TopologyRuleFactory ruleFactory : rules) {
            model1.addElement(ruleFactory);
        }
        this.cboRule.setModel(model1);
        this.cboRule.setSelectedIndex(-1);
        this.updateEnabledComponents();
    }

    private void performRuleSelected() {
        TopologyRuleFactory ruleFactory = (TopologyRuleFactory)this.cboRule.getSelectedItem();
        if (ruleFactory == null) {
            this.updateEnabledComponents();
            return;
        }
        DefaultComboBoxModel<TopologyDataSet> model2 = new DefaultComboBoxModel<TopologyDataSet>();
        if (ruleFactory.hasSecondaryDataSet()) {
            for (TopologyDataSet dataSet : this.plan.getSecondaryDataSets(ruleFactory)) {
                model2.addElement(dataSet);
            }
        }
        this.cboDataSet2.setModel(model2);
        this.cboDataSet2.setSelectedItem(-1);
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        html.append(ruleFactory.getDescription().replace("\n", "<br>")).append("<br>\n");
        html.append("</html>\n");
        this.txtDescription.setContentType("text/html");
        this.txtDescription.setText(html.toString());
        this.txtDescription.setCaretPosition(0);
        DynObject prev = this.parameters;
        this.parameters = ruleFactory.createRuleParameters();
        if (prev != null && this.parameters != null) {
            ToolsLocator.getDynObjectManager().copy(prev, this.parameters);
        }
        if (ruleFactory.hasRuleParameters()) {
            if (this.form != null) {
                this.form.removeListener(this.formListener);
            }
            this.form = DynFormLocator.getDynFormManager().createJDynForm(this.parameters);
            this.form.addListener(this.formListener);
            this.form.setLayoutMode(0);
            this.pnlParametros.setLayout(new BorderLayout());
            this.pnlParametros.removeAll();
            this.pnlParametros.add((Component)this.form.asJComponent(), "Center");
            this.tabCreateRulePanel.setEnabledAt(1, true);
        } else {
            this.tabCreateRulePanel.setEnabledAt(1, false);
        }
        this.updateEnabledComponents();
    }

    public TopologyRule getRule() {
        TopologyDataSet dataSet1 = (TopologyDataSet)this.cboDataSet1.getSelectedItem();
        TopologyRuleFactory ruleFactory = (TopologyRuleFactory)this.cboRule.getSelectedItem();
        if (dataSet1 == null || ruleFactory == null) {
            return null;
        }
        TopologyDataSet dataSet2 = (TopologyDataSet)this.cboDataSet2.getSelectedItem();
        double tolerance = this.plan.getTolerance();
        if (!DoubleDocumentFilter.isEmpty((JTextField)this.txtTolerance)) {
            tolerance = DoubleDocumentFilter.getValue((JTextField)this.txtTolerance);
        }
        TopologyRule rule = dataSet2 == null ? ruleFactory.createRule(dataSet1.getName(), null, tolerance) : ruleFactory.createRule(dataSet1.getName(), dataSet2.getName(), tolerance);
        if (ruleFactory.hasRuleParameters()) {
            this.form.getValues(this.parameters);
            rule.setParameters(this.parameters);
        }
        return rule;
    }

    public void setRule(TopologyRule rule) {
        this.cboDataSet1.setSelectedItem(rule.getDataSet1());
        this.performDataSet1Selected();
        this.cboRule.setSelectedItem(rule.getFactory());
        this.cboDataSet2.setSelectedItem(rule.getDataSet2());
        this.txtTolerance.setText(String.valueOf(rule.getTolerance()));
        this.parameters = rule.getParameters();
        this.performRuleSelected();
    }

    private class DataSetListCellRenderer
    extends DefaultListCellRenderer {
        private Icon pointIcon;
        private Icon lineIcon;
        private Icon polygonIcon;
        private Icon multipolygonIcon;
        private Icon multilineIcon;
        private Icon multipointIcon;

        public DataSetListCellRenderer() {
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getActive();
            if (iconTheme.exists("store-geomtype-point")) {
                this.pointIcon = iconTheme.get("store-geomtype-point");
            }
            if (iconTheme.exists("store-geomtype-line")) {
                this.lineIcon = iconTheme.get("store-geomtype-line");
            }
            if (iconTheme.exists("store-geomtype-polygon")) {
                this.polygonIcon = iconTheme.get("store-geomtype-polygon");
            }
            if (iconTheme.exists("store-geomtype-multipoint")) {
                this.multipointIcon = iconTheme.get("store-geomtype-multipoint");
            }
            if (iconTheme.exists("store-geomtype-multiline")) {
                this.multilineIcon = iconTheme.get("store-geomtype-multiline");
            }
            if (iconTheme.exists("store-geomtype-multipolygon")) {
                this.multipolygonIcon = iconTheme.get("store-geomtype-multipolygon");
            }
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DataStore store;
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(Objects.toString(value, ""));
            this.setIcon(null);
            if (value instanceof TopologyDataSet && (store = ((TopologyDataSet)value).getStore()) instanceof FeatureStore) {
                try {
                    FeatureAttributeDescriptor attr = ((FeatureStore)store).getDefaultFeatureType().getDefaultGeometryAttribute();
                    if (attr != null) {
                        int geomtype = attr.getGeomType().getType();
                        if (GeometryUtils.isSubtype((int)1, (int)geomtype)) {
                            this.setIcon(this.pointIcon);
                        } else if (GeometryUtils.isSubtype((int)2, (int)geomtype)) {
                            this.setIcon(this.lineIcon);
                        } else if (GeometryUtils.isSubtype((int)3, (int)geomtype)) {
                            this.setIcon(this.polygonIcon);
                        } else if (GeometryUtils.isSubtype((int)7, (int)geomtype)) {
                            this.setIcon(this.multipointIcon);
                        } else if (GeometryUtils.isSubtype((int)8, (int)geomtype)) {
                            this.setIcon(this.multilineIcon);
                        } else if (GeometryUtils.isSubtype((int)9, (int)geomtype)) {
                            this.setIcon(this.multipolygonIcon);
                        }
                    }
                }
                catch (DataException dataException) {
                    // empty catch block
                }
            }
            return label;
        }
    }
}

