/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.regularpolygon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Circumference;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class RegularPolygonEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected final Integer DEFAULT_VALUE_SIDES = 5;
    protected final String DEFAULT_VALUE_MODE = "key_inscribed";
    protected final String SIDES_KEY = "sides";
    protected final String MODE_KEY = "mode";
    protected EditingServiceParameter polygonSides;
    protected EditingServiceParameter center;
    protected EditingServiceParameter mode;
    protected EditingServiceParameter pointOfCircle;
    protected Map<EditingServiceParameter, Object> values;
    protected Map<String, String> defaultValues = null;
    DefaultEditingServiceParameterOptions options2;
    protected FeatureStore featureStore;

    public RegularPolygonEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        Integer sideDefaultValue = Integer.valueOf(this.getDefaultValues().get("sides"));
        if (sideDefaultValue == null) {
            sideDefaultValue = this.DEFAULT_VALUE_SIDES;
        }
        this.polygonSides = new DefaultEditingServiceParameter("sides", (Object)sideDefaultValue, "sides_of_regular_polygon", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        String modeDefaultValue = this.getDefaultValues().get("mode");
        if (modeDefaultValue == null) {
            modeDefaultValue = "key_inscribed";
        }
        this.options2 = new DefaultEditingServiceParameterOptions().add("inscribed", (Object)"key_inscribed", i18nManager.getTranslation("key_inscribed")).add("circumscribed", (Object)"key_circumscribed", i18nManager.getTranslation("key_circumscribed"));
        String consoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(null, (EditingServiceParameterOptions)this.options2);
        this.mode = new DefaultEditingServiceParameter("mode", consoleMsg, (EditingServiceParameterOptions)this.options2, (Object)modeDefaultValue, true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(8);
        this.center = new DefaultEditingServiceParameter("center", "center_of_regular_polygon", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.pointOfCircle = new DefaultEditingServiceParameter("point_of_circle", "point_of_circle", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    private Map<String, String> getDefaultValues() {
        if (this.defaultValues == null) {
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            this.defaultValues = editingProviderManager.getDefaultValues("regularpolygon");
        }
        return this.defaultValues;
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.polygonSides) == null) {
            return this.polygonSides;
        }
        if (this.values.get(this.mode) == null) {
            return this.mode;
        }
        if (this.values.get(this.center) == null) {
            return this.center;
        }
        if (this.values.get(this.pointOfCircle) == null) {
            return this.pointOfCircle;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        if (this.values != null) {
            Integer sidesValue = (Integer)this.values.get(this.polygonSides);
            String modeValue = (String)this.values.get(this.mode);
            Point centerValue = (Point)this.values.get(this.center);
            if (centerValue != null) {
                try {
                    EditingProviderServices editingProviderServices = this.getProviderServices();
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    if (modeValue == null) {
                        modeValue = this.getDefaultValues().get("mode");
                    }
                    Curve polygon = this.calculateRegularPolygon(modeValue, centerValue, mousePosition, sidesValue);
                    Line line = editingProviderServices.createLine(centerValue, mousePosition, subtype);
                    double radius = mousePosition.distance((Geometry)centerValue);
                    Circumference circumference = (Circumference)geometryManager.create(23, 0);
                    circumference.setPoints(centerValue, radius);
                    drawingStatus.addStatus((Geometry)circumference, auxiliaryLineSymbolEditing, "");
                    if (polygon != null) {
                        drawingStatus.addStatus((Geometry)polygon, lineSymbolEditing, "");
                        drawingStatus.addStatus((Geometry)polygon, previewSymbol, "");
                    }
                    drawingStatus.addStatus((Geometry)centerValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                }
                catch (BaseException e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
        }
        return drawingStatus;
    }

    protected Curve calculateRegularPolygon(String modeValue, Point centerValue, Point pointOfCircle, int sidesValue) throws BaseException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        int subtype = editingProviderServices.getSubType(this.featureStore);
        Curve polygon = (Curve)geometryManager.create(2, subtype);
        double initAngle = editingProviderServices.getAngle(centerValue, pointOfCircle);
        double radiusValue = pointOfCircle.distance((Geometry)centerValue);
        if (radiusValue == 0.0) {
            return null;
        }
        double theta = Math.PI * -2 / (double)sidesValue;
        if (modeValue.equalsIgnoreCase("key_inscribed")) {
            for (int i = 0; i < sidesValue; ++i) {
                double x = centerValue.getX() + radiusValue * Math.cos(theta * (double)i + initAngle);
                double y = centerValue.getY() + radiusValue * Math.sin(theta * (double)i + initAngle);
                Point createPoint = editingProviderServices.createPoint(x, y, subtype);
                polygon.addVertex(createPoint);
            }
        } else if (modeValue.equalsIgnoreCase("key_circumscribed")) {
            for (int i = 0; i < sidesValue; ++i) {
                double x = centerValue.getX() + radiusValue * Math.cos(theta * (double)i + initAngle);
                double y = centerValue.getY() + radiusValue * Math.sin(theta * (double)i + initAngle);
                Point apothemPoint = editingProviderServices.createPoint(x, y, subtype);
                Double[] apothemParams = editingProviderServices.getLineParams(centerValue, apothemPoint);
                Point[] perpendicular = editingProviderServices.getPerpendicular(apothemParams[0], apothemParams[1], apothemPoint, subtype);
                double x1 = centerValue.getX() + radiusValue * Math.cos(theta * (double)(i + 1) + initAngle);
                double y1 = centerValue.getY() + radiusValue * Math.sin(theta * (double)(i + 1) + initAngle);
                Point nextApothemPoint = editingProviderServices.createPoint(x1, y1, subtype);
                Double[] nextApothemParams = editingProviderServices.getLineParams(centerValue, nextApothemPoint);
                Point[] nextPerpendicular = editingProviderServices.getPerpendicular(nextApothemParams[0], nextApothemParams[1], nextApothemPoint, subtype);
                Point vertex = editingProviderServices.getIntersection(perpendicular, nextPerpendicular, subtype);
                polygon.addVertex(vertex);
            }
        }
        polygon = (Curve)this.closeGeometry((Geometry)polygon);
        return polygon;
    }

    protected Geometry closeGeometry(Geometry geometry) {
        if (!this.isClose(geometry) && geometry != null) {
            if (geometry instanceof Surface) {
                Surface surface = (Surface)geometry;
                Point firstp = surface.getVertex(0);
                firstp = firstp.cloneGeometry();
                surface.addVertex(firstp);
                return surface;
            }
            if (geometry instanceof Curve) {
                Curve line = (Curve)geometry;
                Point firstp = line.getVertex(0);
                firstp = firstp.cloneGeometry();
                line.addVertex(firstp);
                return line;
            }
        }
        return geometry;
    }

    private boolean isClose(Geometry geometry) {
        Point lastPoint;
        OrientablePrimitive orientablePrimitive;
        Point firstPoint;
        return geometry != null && geometry instanceof OrientablePrimitive && (firstPoint = (orientablePrimitive = (OrientablePrimitive)geometry).getVertex(0)).equals(lastPoint = orientablePrimitive.getVertex(orientablePrimitive.getNumVertices() - 1));
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.polygonSides);
        parameters.add(this.mode);
        parameters.add(this.center);
        parameters.add(this.pointOfCircle);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.polygonSides) {
            if (value instanceof Double) {
                Integer sides = ((Double)value).intValue();
                if (sides > 2) {
                    this.values.put(param, sides);
                    this.getDefaultValues().put("sides", sides.toString());
                    this.polygonSides.setDefaultValue((Object)sides.toString());
                    return;
                }
                throw new InvalidEntryException(null);
            }
            if (value instanceof Point) {
                this.values.put(param, Integer.valueOf(this.getDefaultValues().get("sides")));
                this.values.put(this.center, (Point)value);
                return;
            }
        } else if (param == this.mode) {
            if (value instanceof String) {
                Object modeValue = param.getOptions2().getValue(value, param.getDefaultValue());
                this.values.put(param, modeValue);
                this.mode.setDefaultValue(modeValue);
                return;
            }
            if (value instanceof Point) {
                this.values.put(param, this.getDefaultValues().get("mode"));
                if (this.values.get(this.center) != null) {
                    this.values.put(this.pointOfCircle, (Point)value);
                } else {
                    this.values.put(this.center, (Point)value);
                }
                return;
            }
        } else if (param == this.center) {
            if (value instanceof Point) {
                this.values.put(param, value);
                return;
            }
        } else if (param == this.pointOfCircle && value instanceof Point) {
            this.values.put(param, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            Integer sidesValue = (Integer)this.values.get(this.polygonSides);
            String modeValue = (String)this.values.get(this.mode);
            Point centerValue = (Point)this.values.get(this.center);
            Point pointOfCircleValue = (Point)this.values.get(this.pointOfCircle);
            try {
                Curve polygon = this.calculateRegularPolygon(modeValue, centerValue, pointOfCircleValue, sidesValue);
                return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)polygon);
            }
            catch (Exception e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        try {
            Geometry geometry = this.finish();
            if (geometry != null) {
                EditingProviderServices editingProviderServices = this.getProviderServices();
                editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
            }
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-regular-polygon";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }
}

