/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization;

import java.util.List;
import net.sf.jasperreports.components.items.ItemCompiler;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.customvisualization.CVComponent;
import net.sf.jasperreports.customvisualization.design.CVDesignComponent;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class CVCompiler
implements ComponentCompiler {
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        CVComponent cmp = (CVComponent)component;
        for (ItemProperty p : cmp.getItemProperties()) {
            collector.addExpression(p.getValueExpression());
        }
        List<ItemData> cvDataList = cmp.getItemData();
        if (cvDataList != null) {
            for (ItemData cvData : cvDataList) {
                ItemCompiler.collectExpressions((ItemData)cvData, (JRExpressionCollector)collector);
            }
        }
    }

    public static void collectExpressions(ItemData data, JRExpressionCollector collector) {
        ItemCompiler.collectExpressions((ItemData)data, (JRExpressionCollector)collector);
    }

    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        CVComponent cmp = (CVComponent)component;
        CVDesignComponent compiledComponent = new CVDesignComponent(cmp, baseFactory);
        return compiledComponent;
    }

    public void verify(Component component, JRVerifier verifier) {
        CVComponent cmp = (CVComponent)component;
        EvaluationTimeEnum evaluationTime = cmp.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Auto evaluation time is not supported for this component", (Object)cmp);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = cmp.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set", (Object)cmp);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Evalution group \"" + (String)evaluationGroup + " not found", (Object)cmp);
            }
        }
        for (ItemProperty p : cmp.getItemProperties()) {
            verifier.verifyExpression(p.getValueExpression(), (Object)p, null);
        }
        List<ItemData> pathDataList = cmp.getItemData();
        if (pathDataList != null && pathDataList.size() > 0) {
            for (ItemData pathData : pathDataList) {
                ItemCompiler.verifyItemData((JRVerifier)verifier, (ItemData)pathData, null, null, null);
            }
        }
    }
}

