/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.app;

import org.gvsig.andami.plugins.Extension;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.raster.gdal.io.GdalProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdalExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(GdalExtension.class);

    public void execute(String actionCommand) {
    }

    public void postInitialize() {
        try {
            InstallerManager installerManager = InstallerLocator.getInstallerManager();
            PackageInfo[] pkgs = installerManager.getInstalledPackages();
            boolean needECW = true;
            boolean needMrSID = true;
            for (PackageInfo pkg : pkgs) {
                if ("org.gvsig.raster.ermapper.app".equalsIgnoreCase(pkg.getCode())) {
                    needECW = false;
                }
                if (!"org.gvsig.raster.lizardtech.app".equalsIgnoreCase(pkg.getCode())) continue;
                needMrSID = false;
            }
            ProviderServices providerServices = RasterLocator.getManager().getProviderServices();
            if (needECW) {
                providerServices.addFormat("ecw", GdalProvider.class);
                providerServices.addFormat("jp2", GdalProvider.class);
            }
            if (needMrSID) {
                providerServices.addFormat("mrsid", GdalProvider.class);
            }
        }
        catch (Exception ex) {
            logger.warn("Can't determine the use of gdal drivers for ecw, jp2 and mrsid", (Throwable)ex);
        }
    }

    public void initialize() {
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }
}

