/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl.contextmenu;

import java.awt.Color;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.swing.CalculatorController;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.temporarystorage.TemporaryStorageGroup;
import org.gvsig.temporarystorage.TemporaryStorageLocator;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.vectorediting.lib.api.exceptions.ParsePointException;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.JPointPanel;
import org.gvsig.vectorediting.swing.impl.contextmenu.DefaultHierarchyListener;
import org.gvsig.vectorediting.swing.impl.contextmenu.DynamicEditingPointPanelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynamicEditingPointPanel
extends DynamicEditingPointPanelView
implements JPointPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDynamicEditingPointPanel.class);
    private static final long serialVersionUID = 2398169399771503091L;
    private final CalculatorController[] pickers;
    private CalculatorController pickerX;
    private CalculatorController pickerY;
    private CalculatorController pickerZ;
    private CalculatorController pickerM;
    private final GeometryType geomType;
    private final EditingContext editingContext;
    private ExpressionPickerController expressionToBuildPointPicker;
    private final Color buildPointExpressionBackgroundOk;
    private String lastPhrase = null;
    private Point lastPoint;

    public DefaultDynamicEditingPointPanel(EditingContext editingContext, Point point) {
        this.editingContext = editingContext;
        this.geomType = this.editingContext.getGeometryType();
        this.pickers = new CalculatorController[this.geomType.getDimension()];
        this.initComponents();
        this.buildPointExpressionBackgroundOk = this.txtBuildPointExpression.getBackground();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ExpressionEvaluatorSwingManager evaluatorManager = ExpressionEvaluatorSwingLocator.getManager();
        toolsSwingManager.translate((AbstractButton)this.rdbEnterTheCoordinatesManually);
        toolsSwingManager.translate((AbstractButton)this.rdbUseAPointPreviouslyCaptured);
        toolsSwingManager.translate((AbstractButton)this.rdbEnterExpressionToBuildPoint);
        toolsSwingManager.addClearButton((JTextComponent)this.txtX);
        toolsSwingManager.addClearButton((JTextComponent)this.txtY);
        toolsSwingManager.addClearButton((JTextComponent)this.txtZ);
        toolsSwingManager.addClearButton((JTextComponent)this.txtM);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtX);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtY);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtZ);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtM);
        this.pickerX = evaluatorManager.createCalculatorController((JTextComponent)this.txtX, 7);
        this.pickerY = evaluatorManager.createCalculatorController((JTextComponent)this.txtY, 7);
        this.pickerZ = evaluatorManager.createCalculatorController((JTextComponent)this.txtZ, 7);
        this.pickerM = evaluatorManager.createCalculatorController((JTextComponent)this.txtM, 7);
        this.pickers[0] = this.pickerX;
        this.pickers[1] = this.pickerY;
        if (this.geomType.hasZ() && this.geomType.hasM()) {
            this.pickers[2] = this.pickerZ;
            this.pickers[3] = this.pickerM;
        } else if (this.geomType.hasZ()) {
            this.pickers[2] = this.pickerZ;
        } else if (this.geomType.hasM()) {
            this.pickers[2] = this.pickerM;
        }
        this.addHierarchyChanged();
        TemporaryStorageGroup points = TemporaryStorageLocator.getTemporaryStorageManager().create("Points", Point.class);
        DefaultComboBoxModel<ListElement> model = new DefaultComboBoxModel<ListElement>();
        model.addElement(new ListElement("", null));
        for (Pair pair : points.asList()) {
            model.addElement(new ListElement((String)pair.getKey(), (Object)((Point)pair.getValue())));
        }
        this.cboCapturedPoints.setModel(model);
        this.cboCapturedPoints.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setPoint((Point)((ListElement)e.getItem()).getValue());
            }
        });
        this.rdbEnterTheCoordinatesManually.addActionListener(e -> this.updateEnabledState());
        this.rdbUseAPointPreviouslyCaptured.addActionListener(e -> this.updateEnabledState());
        this.rdbEnterExpressionToBuildPoint.addActionListener(e -> this.updateEnabledState());
        this.expressionToBuildPointPicker = evaluatorManager.createExpressionPickerController((JTextComponent)this.txtBuildPointExpression, this.btnBuildPointDialog, this.btnBuildPointHistory, this.btnBuildPointBookmarks);
        this.expressionToBuildPointPicker.addChangeListener(e -> this.doUpdatePointFromExpression());
        this.expressionToBuildPointPicker.setBookmarks(this.editingContext.getBookmarksForInsertPoints());
        this.expressionToBuildPointPicker.setHistory(this.editingContext.getHistoryForInsertPoints());
        this.rdbEnterTheCoordinatesManually.setSelected(true);
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        if (this.rdbEnterTheCoordinatesManually.isSelected()) {
            this.expressionToBuildPointPicker.setEnabled(false);
            this.cboCapturedPoints.setEnabled(false);
            this.txtX.setEnabled(true);
            this.txtY.setEnabled(true);
            this.txtZ.setEnabled(false);
            this.txtM.setEnabled(false);
            this.lblX.setEnabled(true);
            this.lblY.setEnabled(true);
            this.lblZ.setEnabled(false);
            this.lblM.setEnabled(false);
            if (this.geomType.hasZ() && this.geomType.hasM()) {
                this.txtZ.setEnabled(true);
                this.lblZ.setEnabled(true);
                this.txtM.setEnabled(true);
                this.lblM.setEnabled(true);
            } else if (this.geomType.hasZ()) {
                this.txtZ.setEnabled(true);
                this.lblZ.setEnabled(true);
            } else if (this.geomType.hasM()) {
                this.txtM.setEnabled(true);
                this.lblM.setEnabled(true);
            }
        }
        if (this.rdbUseAPointPreviouslyCaptured.isSelected()) {
            this.expressionToBuildPointPicker.setEnabled(false);
            this.cboCapturedPoints.setEnabled(true);
            this.txtX.setEnabled(false);
            this.txtY.setEnabled(false);
            this.txtZ.setEnabled(false);
            this.txtM.setEnabled(false);
            this.lblX.setEnabled(false);
            this.lblY.setEnabled(false);
            this.lblZ.setEnabled(false);
            this.lblM.setEnabled(false);
        }
        if (this.rdbEnterExpressionToBuildPoint.isSelected()) {
            this.expressionToBuildPointPicker.setEnabled(true);
            this.cboCapturedPoints.setEnabled(false);
            this.txtX.setEnabled(false);
            this.txtY.setEnabled(false);
            this.txtZ.setEnabled(false);
            this.txtM.setEnabled(false);
            this.lblX.setEnabled(false);
            this.lblY.setEnabled(false);
            this.lblZ.setEnabled(false);
            this.lblM.setEnabled(false);
        }
    }

    public void setPoint(Point point) {
        if (point == null) {
            this.pickerX.set(null);
            this.pickerY.set(null);
            this.pickerZ.set(null);
            this.pickerM.set(null);
            return;
        }
        this.pickerX.set((Object)point.getX());
        this.pickerY.set((Object)point.getY());
        GeometryType theGeomType = point.getGeometryType();
        if (theGeomType.hasZ()) {
            this.pickerZ.set((Object)point.getCoordinateAt(2));
        }
        if (theGeomType.hasM()) {
            this.pickerM.set((Object)point.getCoordinateAt(point.getDimension() - 1));
        }
    }

    public Point getPoint() {
        if (this.rdbEnterExpressionToBuildPoint.isSelected()) {
            this.doUpdatePointFromExpression();
        }
        int dimension = this.geomType.getDimension();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            String value = this.getValue(i);
            buffer.append(value);
            if (i >= dimension - 1) continue;
            buffer.append(",");
        }
        try {
            Point p = this.editingContext.parsePoint(buffer.toString());
            return p;
        }
        catch (ParsePointException ex) {
            return null;
        }
    }

    private void addHierarchyChanged() {
        this.txtX.addHierarchyListener(new DefaultHierarchyListener());
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getValue(int i) {
        if (this.rdbEnterExpressionToBuildPoint.isSelected()) {
            this.doUpdatePointFromExpression();
        }
        return Objects.toString(this.pickers[i].get(), "");
    }

    public void setValue(int i, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.pickers[i].set(null);
            return;
        }
        this.pickers[i].coerceAndSet((Object)value);
    }

    private void doUpdatePointFromExpression() {
        try {
            Point p = this.getPointFromExpression();
            if (p != null) {
                this.setPoint(p);
                this.expressionToBuildPointPicker.get();
                this.txtBuildPointExpression.setBackground(this.buildPointExpressionBackgroundOk);
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Can't update point from expression", t);
        }
    }

    private Point getPointFromExpression() {
        String phrase = null;
        try {
            String phrase0;
            Expression exp = this.expressionToBuildPointPicker.getWithOutHistory();
            phrase = phrase0 = exp.getPhrase();
            if (StringUtils.equals((CharSequence)phrase, (CharSequence)this.lastPhrase)) {
                return this.lastPoint;
            }
            exp = ExpressionUtils.createExpression((String)(phrase = this.fixExpressionUsingBookmarks(phrase)));
            Object p = exp.execute(this.editingContext.getContextSymbolTable());
            if (p instanceof Point) {
                this.lastPoint = (Point)p;
                this.lastPhrase = phrase0;
                return this.lastPoint;
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Can't parse expression:" + phrase, t);
        }
        return null;
    }

    private String fixExpressionUsingBookmarks(String expression) throws LocatorException {
        if (expression != null) {
            expression = expression.trim();
            int firstBlank = StringUtils.indexOf((CharSequence)expression, (CharSequence)" ");
            int firstParenthesis = StringUtils.indexOf((CharSequence)expression, (CharSequence)"(");
            if (firstBlank > 0 && (firstParenthesis < 0 || firstBlank < firstParenthesis)) {
                String name = StringUtils.left((String)expression, (int)firstBlank);
                Function fn = this.editingContext.getContextSymbolTable().function(name);
                if (fn != null) {
                    expression = name + "(" + expression.substring(firstBlank) + ")";
                }
            }
        }
        return expression;
    }
}

