/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.app.extension;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.Arguments;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.scripting.app.extension.ScriptingExtension;
import org.gvsig.scripting.app.extension.ScriptingUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcessArguments
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostProcessArguments.class);

    private PluginServices getPlugin() {
        PluginsManager pluginsManager = PluginsLocator.getPluginsManager();
        PluginServices plugin = pluginsManager.getPlugin(ScriptingExtension.class);
        return plugin;
    }

    private ScriptingUtils getUtils() {
        PluginsManager pluginsManager = PluginsLocator.getPluginsManager();
        ScriptingExtension ext = (ScriptingExtension)pluginsManager.getExtension(ScriptingExtension.class);
        return ext.getScriptingUtils();
    }

    @Override
    public void run() {
        String arg;
        DynObject preferences;
        ApplicationManager app = ApplicationLocator.getApplicationManager();
        Arguments args = app.getArguments();
        if (args.contains("scriptsEditorMode", "embed")) {
            LOGGER.info("scriptsEditorMode=embed");
            preferences = this.getPlugin().getPluginProperties();
            preferences.setDynValue("ComposerUseHisWindowManager", (Object)false);
        } else if (args.contains("scriptsEditorMode", "standalone")) {
            LOGGER.info("scriptsEditorMode=standalone");
            preferences = this.getPlugin().getPluginProperties();
            preferences.setDynValue("ComposerUseHisWindowManager", (Object)true);
        }
        if (args.contains("runScriptsEditor", "true")) {
            LOGGER.info("runScriptsEditor");
            this.getUtils().runComposer();
        }
        if (args.contains("runScriptsLauncher", "true")) {
            LOGGER.info("runScriptsLauncher");
            this.getUtils().runLauncher();
        }
        if (StringUtils.isNotBlank((CharSequence)(arg = args.get("runScript")))) {
            LOGGER.info("runScript=" + arg);
            this.getUtils().runScript(arg, null);
        }
    }
}

