/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.ellipse;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.PeriEllipse;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.prov.ellipse.FilledEllipseEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class EllipseEditingProvider
extends FilledEllipseEditingProvider
implements EditingProvider {
    public EllipseEditingProvider(ProviderServices services, DynObject parameters) {
        super(services, parameters);
    }

    @Override
    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            EditingProviderServices editingProviderService = this.getProviderServices();
            Point firstPointAxis1Value = (Point)this.values.get(this.firstPointAxisA);
            Point secondPointAxis1Value = (Point)this.values.get(this.secondPointAxisA);
            double lengthSemiaxis2Value = (Double)this.values.get(this.lengthSemiAxisB);
            if (firstPointAxis1Value != null && secondPointAxis1Value != null && lengthSemiaxis2Value > 0.0) {
                try {
                    GeometryType storeGeomType = editingProviderService.getGeomType(this.featureStore);
                    int subtype = storeGeomType.getSubType();
                    PeriEllipse periEllipse = (PeriEllipse)GeometryLocator.getGeometryManager().create(24, subtype);
                    periEllipse.setPoints(firstPointAxis1Value, secondPointAxis1Value, lengthSemiaxis2Value);
                    return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)periEllipse);
                }
                catch (Exception e) {
                    throw new FinishServiceException((Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "insert-ellipse";
    }

    @Override
    protected void addTemporaryGeometryToDrawingStatus(DefaultDrawingStatus drawingStatus, Point firstPointAxis1Value, Point secondPointAxis1Value, int subtype, double distance) throws CreateGeometryException {
        PeriEllipse periEllipse = (PeriEllipse)GeometryLocator.getGeometryManager().create(24, subtype);
        periEllipse.setPoints(firstPointAxis1Value, secondPointAxis1Value, distance);
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        drawingStatus.addStatus((Geometry)periEllipse, lineSymbolEditing, "");
        drawingStatus.addStatus((Geometry)periEllipse, drawingStatus.getPreviewSymbol(), "");
    }
}

