/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.jdbc.service.ExportJDBCAttributeNamesTranslator;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.jdbc.service.ExportJDBCServiceFactory;
import org.gvsig.export.spi.AbstractExportParametersGeometry;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCStoreProviderFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class ExportJDBCParametersImpl
extends AbstractExportParametersGeometry
implements ExportJDBCParameters {
    private JDBCServerExplorerParameters explorerParameters;
    private String schema;
    private String tableName;
    private boolean canCreatetable;
    private String primaryKeyName;
    private String storeName;
    private String explorerName;
    private boolean removeSpacesInIdentifiers;
    private boolean translateHyphens;
    private String selectRole;
    private String insertRole;
    private String updateRole;
    private String deleteRole;
    private String truncateRole;
    private String referenceRole;
    private String triggerRole;
    private String allRole;
    private String postCreatingStatement;
    private boolean createIndexInGeometryRow;
    private boolean updateTableStatistics;
    private int caseIdentifierMode;
    private boolean deleteRows;
    private Expression deleteRowsFilter;

    public ExportJDBCParametersImpl(ExportJDBCServiceFactory factory) {
        super((ExportServiceFactory)factory);
        this.exportAttributes.setNamesTranslator((NamesTranslator)new ExportJDBCAttributeNamesTranslator(this));
        this.canCreatetable = true;
        this.caseIdentifierMode = 1;
        this.removeSpacesInIdentifiers = true;
        this.translateHyphens = true;
        this.createIndexInGeometryRow = true;
        this.updateTableStatistics = true;
    }

    public ExportJDBCParametersImpl() {
        super(null);
    }

    public String getServiceName() {
        return "JDBC";
    }

    @Override
    public JDBCServerExplorerParameters getExplorerParameters() {
        return this.explorerParameters;
    }

    @Override
    public void setExplorerParameters(JDBCServerExplorerParameters explorerParameters) {
        this.explorerParameters = explorerParameters;
        String provider = this.explorerParameters.getProviderName();
        JDBCStoreProviderFactory providerFactory = (JDBCStoreProviderFactory)DALLocator.getDataManager().getStoreProviderFactory(provider);
        int caseMode = providerFactory.caseIndentifierPreferedMode();
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public boolean canCreatetable() {
        return this.canCreatetable;
    }

    @Override
    public void setCanCreatetable(boolean canCreatetable) {
        this.canCreatetable = canCreatetable;
    }

    @Override
    public String getPrimaryKey() {
        return this.primaryKeyName;
    }

    @Override
    public void setPrimaryKey(String primaryKey) {
        this.primaryKeyName = primaryKey;
    }

    @Override
    public String getStoreName() {
        return this.storeName;
    }

    @Override
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    @Override
    public String getExplorerName() {
        return this.explorerName;
    }

    @Override
    public void setExplorerName(String explorerName) {
        this.explorerName = explorerName;
    }

    @Override
    public void setCaseIdentifiersMode(int mode) {
        if (mode != this.caseIdentifierMode) {
            this.caseIdentifierMode = mode;
            this.exportAttributes.getNamesTranslator().rebuild();
        }
    }

    @Override
    public void setRemoveSpacesInIdentifiers(boolean removeSpacesInIdentifiers) {
        if (removeSpacesInIdentifiers != this.removeSpacesInIdentifiers) {
            this.removeSpacesInIdentifiers = removeSpacesInIdentifiers;
            this.exportAttributes.getNamesTranslator().rebuild();
        }
    }

    @Override
    public void setTranslateHyphens(boolean translateHyphens) {
        if (translateHyphens != this.translateHyphens) {
            this.translateHyphens = translateHyphens;
            List sourceNames = this.exportAttributes.getNamesTranslator().getSourceNames();
            this.exportAttributes.getNamesTranslator().rebuild();
        }
    }

    @Override
    public String getSelectRole() {
        return this.selectRole;
    }

    @Override
    public void setSelectRole(String selectRole) {
        this.selectRole = selectRole;
    }

    @Override
    public String getInsertRole() {
        return this.insertRole;
    }

    @Override
    public void setInsertRole(String insertRole) {
        this.insertRole = insertRole;
    }

    @Override
    public String getUpdateRole() {
        return this.updateRole;
    }

    @Override
    public void setUpdateRole(String updateRole) {
        this.updateRole = updateRole;
    }

    @Override
    public String getDeleteRole() {
        return this.deleteRole;
    }

    @Override
    public void setDeleteRole(String deleteRole) {
        this.deleteRole = deleteRole;
    }

    @Override
    public String getTruncateRole() {
        return this.truncateRole;
    }

    @Override
    public void setTruncateRole(String truncateRole) {
        this.truncateRole = truncateRole;
    }

    @Override
    public String getReferenceRole() {
        return this.referenceRole;
    }

    @Override
    public void setReferenceRole(String referenceRole) {
        this.referenceRole = referenceRole;
    }

    @Override
    public String getTriggerRole() {
        return this.triggerRole;
    }

    @Override
    public void setTriggerRole(String triggerRole) {
        this.triggerRole = triggerRole;
    }

    @Override
    public String getAllRole() {
        return this.allRole;
    }

    @Override
    public void setAllRole(String allRole) {
        this.allRole = allRole;
    }

    @Override
    public String getPostCreatingStatement() {
        return this.postCreatingStatement;
    }

    @Override
    public void setPostCreatingStatement(String postCreatingStatement) {
        this.postCreatingStatement = postCreatingStatement;
    }

    @Override
    public boolean getCreateIndexInGeometryRow() {
        return this.createIndexInGeometryRow;
    }

    @Override
    public void setCreateIndexInGeometryRow(boolean createIndexInGeometryRow) {
        this.createIndexInGeometryRow = createIndexInGeometryRow;
    }

    @Override
    public boolean getUpdateTableStatistics() {
        return this.updateTableStatistics;
    }

    @Override
    public void setUpdateTableStatistics(boolean updateTableStatistics) {
        this.updateTableStatistics = updateTableStatistics;
    }

    @Override
    public boolean getTranslateHyphens() {
        return this.translateHyphens;
    }

    @Override
    public boolean getRemoveSpacesInIdentifiers() {
        return this.removeSpacesInIdentifiers;
    }

    @Override
    public int getCaseIdentifiersMode() {
        return this.caseIdentifierMode;
    }

    @Override
    public void setDeleteRows(boolean deleteRows) {
        this.deleteRows = deleteRows;
    }

    @Override
    public boolean isDeleteRows() {
        return this.deleteRows;
    }

    @Override
    public void setDeleteRowsFilter(Expression deleteRowsFilter) {
        this.deleteRowsFilter = deleteRowsFilter;
    }

    @Override
    public Expression getDeleteRowsFilter() {
        return this.deleteRowsFilter;
    }

    public ExportJDBCParameters clone() throws CloneNotSupportedException {
        ExportJDBCParameters clone = (ExportJDBCParameters)super.clone();
        clone.setExplorerParameters((JDBCServerExplorerParameters)this.explorerParameters.getCopy());
        return clone;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("ExportJDBCParametersImpl") == null) {
            DynStruct definition = manager.addDefinition(ExportJDBCParametersImpl.class, "ExportJDBCParametersImpl", "ExportJDBCParametersImpl persistence definition", null, null);
            definition.addDynFieldObject("explorerParameters").setClassOfValue(JDBCServerExplorerParameters.class);
            definition.addDynFieldString("schema");
            definition.addDynFieldString("tableName");
            definition.addDynFieldBoolean("canCreatetable");
            definition.addDynFieldString("primaryKeyName");
            definition.addDynFieldString("storeName");
            definition.addDynFieldString("explorerName");
            definition.addDynFieldInt("caseIdentifierMode").setMandatory(false);
            definition.addDynFieldBoolean("removeSpacesInIdentifiers");
            definition.addDynFieldBoolean("translateHyphens");
            definition.addDynFieldString("selectRole");
            definition.addDynFieldString("insertRole");
            definition.addDynFieldString("updateRole");
            definition.addDynFieldString("deleteRole");
            definition.addDynFieldString("truncateRole");
            definition.addDynFieldString("referenceRole");
            definition.addDynFieldString("triggerRole");
            definition.addDynFieldString("allRole");
            definition.addDynFieldString("postCreatingStatement");
            definition.addDynFieldBoolean("createIndexInGeometryRow");
            definition.addDynFieldBoolean("updateTableStatistics");
            definition.addDynFieldBoolean("deleteRows").setMandatory(false);
            definition.addDynFieldObject("deleteRowsFilter").setClassOfValue(Expression.class).setMandatory(false);
            definition.extend(manager.getDefinition("AbstractExportParametersGeometry"));
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("explorerParameters", (Persistent)this.explorerParameters);
        state.set("schema", this.schema);
        state.set("tableName", this.tableName);
        state.set("canCreatetable", this.canCreatetable);
        state.set("primaryKeyName", this.primaryKeyName);
        state.set("storeName", this.storeName);
        state.set("explorerName", this.explorerName);
        state.set("caseIdentifierMode", this.caseIdentifierMode);
        state.set("removeSpacesInIdentifiers", this.removeSpacesInIdentifiers);
        state.set("translateHyphens", this.translateHyphens);
        state.set("selectRole", this.selectRole);
        state.set("insertRole", this.insertRole);
        state.set("updateRole", this.updateRole);
        state.set("deleteRole", this.deleteRole);
        state.set("truncateRole", this.truncateRole);
        state.set("referenceRole", this.referenceRole);
        state.set("triggerRole", this.triggerRole);
        state.set("allRole", this.allRole);
        state.set("postCreatingStatement", this.postCreatingStatement);
        state.set("createIndexInGeometryRow", this.createIndexInGeometryRow);
        state.set("updateTableStatistics", this.updateTableStatistics);
        state.set("deleteRows", this.deleteRows);
        state.set("deleteRowsFilter", (Persistent)this.deleteRowsFilter);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.explorerParameters = (JDBCServerExplorerParameters)state.get("explorerParameters");
        this.schema = state.getString("schema");
        this.tableName = state.getString("tableName");
        this.canCreatetable = state.getBoolean("canCreatetable");
        this.primaryKeyName = state.getString("primaryKeyName");
        this.storeName = state.getString("storeName");
        this.explorerName = state.getString("explorerName");
        this.caseIdentifierMode = state.getInt("caseIdentifierMode", 1);
        this.removeSpacesInIdentifiers = state.getBoolean("removeSpacesInIdentifiers");
        this.translateHyphens = state.getBoolean("translateHyphens");
        this.selectRole = state.getString("selectRole");
        this.insertRole = state.getString("insertRole");
        this.updateRole = state.getString("updateRole");
        this.deleteRole = state.getString("deleteRole");
        this.truncateRole = state.getString("truncateRole");
        this.referenceRole = state.getString("referenceRole");
        this.triggerRole = state.getString("triggerRole");
        this.allRole = state.getString("allRole");
        this.postCreatingStatement = state.getString("postCreatingStatement");
        this.createIndexInGeometryRow = state.getBoolean("createIndexInGeometryRow");
        this.updateTableStatistics = state.getBoolean("updateTableStatistics");
        this.deleteRows = state.getBoolean("deleteRows");
        this.deleteRowsFilter = (Expression)state.get("deleteRowsFilter");
        ExportJDBCAttributeNamesTranslator nameTranslator = (ExportJDBCAttributeNamesTranslator)this.exportAttributes.getNamesTranslator();
        nameTranslator.setParameters(this);
    }

    @Override
    public String fixIdentifier(String name) {
        String target_name = name;
        if (this.getRemoveSpacesInIdentifiers()) {
            target_name = StringUtils.normalizeSpace((String)target_name).replace(" ", "_");
        }
        if (this.getTranslateHyphens()) {
            target_name = target_name.replace("-", "_");
        }
        switch (this.getCaseIdentifiersMode()) {
            case 1: {
                target_name = target_name.toUpperCase();
                break;
            }
            case 2: {
                target_name = target_name.toLowerCase();
            }
        }
        return target_name;
    }
}

