/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.swing.panels;

import javax.swing.AbstractButton;
import javax.swing.JComponent;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.jdbc.swing.panels.IdentifiersOptionsPanelView;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class IdentifiersOptionsPanel
extends IdentifiersOptionsPanelView
implements ExportPanel {
    private static final long serialVersionUID = -6390855050271511346L;
    private final ExportJDBCParameters parameters;
    private final JExportProcessPanel processPanel;

    public IdentifiersOptionsPanel(JExportProcessPanel processPanel, ExportJDBCParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        this.chkRemoveSpaces.setSelected(true);
        this.translate();
    }

    private void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.rdbIndiferentCase);
        swingManager.translate((AbstractButton)this.rdbLowerCase);
        swingManager.translate((AbstractButton)this.rdbUpperCase);
        swingManager.translate((AbstractButton)this.chkRemoveSpaces);
        swingManager.translate((AbstractButton)this.chkTraslateHyphens);
        swingManager.translate(this.lblHeader, true);
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Table_and_fields_name_options");
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        ExportJDBCParameters params = this.parameters;
        params.setRemoveSpacesInIdentifiers(this.chkRemoveSpaces.isSelected());
        params.setCaseIdentifiersMode(this.getCaseIndentifiersMode());
        params.setTranslateHyphens(this.chkTraslateHyphens.isSelected());
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
        this.chkRemoveSpaces.setSelected(this.parameters.getRemoveSpacesInIdentifiers());
        this.chkTraslateHyphens.setSelected(this.parameters.getTranslateHyphens());
        switch (this.parameters.getCaseIdentifiersMode()) {
            case 0: {
                this.rdbIndiferentCase.setSelected(true);
                break;
            }
            case 2: {
                this.rdbLowerCase.setSelected(true);
                break;
            }
            default: {
                this.rdbUpperCase.setSelected(true);
            }
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public int getCaseIndentifiersMode() {
        if (this.rdbIndiferentCase.isSelected()) {
            return 0;
        }
        if (this.rdbLowerCase.isSelected()) {
            return 2;
        }
        if (this.rdbUpperCase.isSelected()) {
            return 1;
        }
        return 1;
    }

    public boolean getRemoveSpacesInTableName() {
        return this.chkRemoveSpaces.isSelected();
    }

    public boolean getTranslateHyphens() {
        return this.chkTraslateHyphens.isSelected();
    }
}

