/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;

public class CoordinateSequenceDimensionFilter
implements CoordinateSequenceFilter {
    private boolean isDone = false;
    private int largestDimSoFar = 0;
    public static final int XY = 2;
    public static final int XYZ = 3;
    public static final int XYZM = 4;
    private int maxDim = 4;
    private boolean exists2D = false;
    private boolean exists3D = false;

    public void filter(CoordinateSequence seq, int i) {
        int currentDim = 0;
        if (Double.isNaN(seq.getOrdinate(i, 2))) {
            this.exists2D = true;
            currentDim = 2;
        } else {
            this.exists3D = true;
            currentDim = Double.isNaN(seq.getOrdinate(i, 3)) ? 3 : 4;
        }
        if (currentDim > this.largestDimSoFar) {
            this.largestDimSoFar = currentDim;
        }
        if (i == seq.size() || this.largestDimSoFar >= this.maxDim && this.isMixed()) {
            this.isDone = true;
        }
    }

    public static CoordinateSequenceDimensionFilter apply(Geometry geometry) {
        CoordinateSequenceDimensionFilter cd = new CoordinateSequenceDimensionFilter();
        geometry.apply((CoordinateSequenceFilter)cd);
        return cd;
    }

    public int getDimension() {
        return this.largestDimSoFar;
    }

    public boolean isMixed() {
        return this.exists2D && this.exists3D;
    }

    public boolean is2D() {
        return !this.exists3D;
    }

    public void setMAXDim(int maxDim) {
        this.maxDim = maxDim;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean isGeometryChanged() {
        return false;
    }
}

