/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.gui.LayerProperties;
import org.gvsig.app.project.documents.view.toc.gui.FPopupMenu;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanel;
import org.gvsig.fmap.dal.swing.dataStoreParameters.DataStoreParametersPanelManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;

public class LayerPropertiesExtension
extends Extension {
    public void initialize() {
    }

    public void postInitialize() {
        FPopupMenu.registerExtensionPoint();
        IconThemeHelper.registerIcon((String)"action", (String)"layer-properties", (Object)((Object)this));
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        viewManager.addTOCContextAction("layer-properties", "group-last", 10000, 900);
    }

    public void execute(String s) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        if (!document.getMapContext().hasActiveLayers()) {
            return;
        }
        if (s.equalsIgnoreCase("layer-properties")) {
            DataStore store;
            ThreadSafeDialogsManager dialogs;
            int n;
            I18nManager i18n = ToolsLocator.getI18nManager();
            FLayer[] activeLayers = document.getMapContext().getLayers().getActives();
            FLayer layer = activeLayers[0];
            if (activeLayers.length > 1 && (n = (dialogs = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_There_is_more_than_one_active_layer") + "\n" + i18n.getTranslation("_If_you_continue_the_properties_of_layer_0_will_be_displayed", new String[]{layer.getName()}) + "\n" + i18n.getTranslation("_Do_you_wish_to_continue"), i18n.getTranslation("_Show_properties"), 0, 3, "_If_you_continue_the_properties_of_layer_0_will_be_displayed")) != 0) {
                return;
            }
            String title = null;
            if (layer instanceof SingleLayer && (store = ((SingleLayer)layer).getDataStore()) != null) {
                title = application.makeTitle(i18n.getTranslation("propiedades_de_la_capa"), layer.getName(), store.getName());
            }
            if (title == null) {
                title = application.makeTitle(i18n.getTranslation("propiedades_de_la_capa"), layer.getName(), null);
            }
            LayerProperties dlg = new LayerProperties(layer);
            WindowManager wm = ToolsSwingLocator.getWindowManager();
            wm.showWindow(dlg.asJComponent(), title, WindowManager.MODE.WINDOW);
        } else if (s.equalsIgnoreCase("layer-edit-openparameters")) {
            ThreadSafeDialogsManager dialogs;
            int n;
            I18nManager i18n = ToolsLocator.getI18nManager();
            FLayer[] activeLayers = document.getMapContext().getLayers().getActives();
            FLayer layer = activeLayers[0];
            if (activeLayers.length > 1 && (n = (dialogs = ToolsSwingLocator.getThreadSafeDialogsManager()).confirmDialog(i18n.getTranslation("_There_is_more_than_one_active_layer") + "\n" + i18n.getTranslation("_If_you_continue_the_open_parameters_of_layer_0_will_be_displayed", new String[]{layer.getName()}) + "\n" + i18n.getTranslation("_Do_you_wish_to_continue"), i18n.getTranslation("_Show_properties"), 0, 3, "_If_you_continue_the_open_parameters_of_layer_0_will_be_displayed")) != 0) {
                return;
            }
            this.editOpenParameters(layer);
        } else if (s.equalsIgnoreCase("layer-reload")) {
            FLayer[] activeLayers;
            I18nManager i18n = ToolsLocator.getI18nManager();
            for (FLayer layer : activeLayers = document.getMapContext().getLayers().getActives()) {
                try {
                    layer.reload();
                }
                catch (Exception ex) {
                    logger.info("While reloading layer", (Throwable)ex);
                    layer.setAvailable(false);
                }
            }
            document.getMapContext().invalidate();
        }
    }

    public void editOpenParameters(FLayer layer) {
        try {
            if (layer instanceof FLyrVect) {
                DataStoreParameters parameters = ((FLyrVect)layer).getDataStoreParameters();
                DataStoreParametersPanelManager manager = DALSwingLocator.getDataStoreParametersPanelManager();
                DataStoreParametersPanel panel = manager.createDataStoreParametersPanel((DynObject)parameters);
                panel.setExcludeGeometryOptions(true);
                manager.showPropertiesDialog((DynObject)parameters, panel);
            }
        }
        catch (Exception ex) {
            logger.info("Can't edit open parameters for layer", (Throwable)ex);
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasActiveLayers();
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasLayers();
    }
}

