/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.List;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSelectionControls
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(ViewSelectionControls.class);

    public void initialize() {
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-select-by-rectangle", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"selection-select-by-polygon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"selection-clear", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        MapControl mapCtrl = view.getMapControl();
        if (actionCommand.equalsIgnoreCase("selection-select-by-rectangle-view")) {
            mapCtrl.setTool("rectSelection");
            document.setModified(true);
        } else if (actionCommand.equalsIgnoreCase("selection-select-by-polygon")) {
            mapCtrl.setTool("polSelection");
            document.setModified(true);
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        if (document == null) {
            return false;
        }
        List layers = document.getMapContext().getLayers().getLayers(FLayers.LAYER_ACTIVE.and(FLayers.LAYER_AVALAIBLE).and(FLayers.LAYER_SELECTION_AVAILABLE));
        return layers.size() >= 1;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument document = (ViewDocument)application.getActiveDocument(ViewDocument.class);
        if (document == null) {
            return false;
        }
        return document.getMapContext().hasVectorLayers();
    }
}

