/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.dispose;

import java.awt.Dimension;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.extension.dispose.DisposablesDoListLayout;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableInfo;
import org.gvsig.tools.dispose.DisposableManager;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisposableManagementExtension
extends Extension {
    public static String SHOW_COMMAND = "tools-devel-disposables-show-pendings";
    public static String DISPOSE_ALL_COMMAND = "tools-devel-disposables-free-all";
    private static final Logger LOG = LoggerFactory.getLogger(DisposableManagementExtension.class);

    public void initialize() {
    }

    public void postInitialize() {
        super.postInitialize();
    }

    public void execute(String actionCommand) {
        if (DISPOSE_ALL_COMMAND.equals(actionCommand)) {
            this.disposeAll();
        } else if (SHOW_COMMAND.equals(actionCommand)) {
            DisposablesDoList panel = new DisposablesDoList();
            panel.showPanel();
        }
    }

    private void disposeAll() {
        DisposableManager manager = ToolsLocator.getDisposableManager();
        try {
            manager.releaseAll();
        }
        catch (BaseException ex) {
            LOG.error("Error disposing all bound disposable objects", (Throwable)ex);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    class DisposablesDoList
    extends DisposablesDoListLayout {
        private DisposableManager manager = ToolsLocator.getDisposableManager();
        private JTable disposablesTable = null;
        private JTextPane infoTextArea = null;

        public DisposablesDoList() {
            this.initComponents();
            SwingUtilities.invokeLater(() -> {
                this.refreshList();
                this.updateMemoryUsage();
            });
        }

        private void initComponents() {
            ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
            this.setPreferredSize(new Dimension(600, 550));
            this.disposablesTable = new JTable(new DisposablesTableModel());
            this.disposablesTable.setAutoCreateColumnsFromModel(false);
            DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
            columnModel.addColumn(this.createTableColumn(0, ToolsSwingUtils.cols2px((int)5), "refs"));
            columnModel.addColumn(this.createTableColumn(1, ToolsSwingUtils.cols2px((int)12), "class"));
            columnModel.addColumn(this.createTableColumn(2, ToolsSwingUtils.cols2px((int)10), "code"));
            columnModel.addColumn(this.createTableColumn(3, ToolsSwingUtils.cols2px((int)12), "fullClass"));
            columnModel.addColumn(this.createTableColumn(4, ToolsSwingUtils.cols2px((int)25), "toString"));
            this.disposablesTable.setColumnModel(columnModel);
            this.disposablesTable.setSelectionMode(2);
            this.infoTextArea = new JTextPane();
            this.infoTextArea.setContentType("text/html");
            toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.infoTextArea, "Disposable information");
            JScrollPane listScroller = new JScrollPane(this.disposablesTable);
            JScrollPane infoScroller = new JScrollPane(this.infoTextArea);
            this.splitPanel.setLeftComponent(listScroller);
            this.splitPanel.setRightComponent(infoScroller);
            this.splitPanel.setDividerLocation(0.3);
            this.closeButton.addActionListener(arg0 -> this.closeWindow());
            this.closeButton.setEnabled(true);
            this.disposeAllButton.addActionListener(e -> {
                this.disposeAll();
                this.refreshList();
                this.updateMemoryUsage();
            });
            this.disposeAllButton.setEnabled(true);
            this.disposeButton.addActionListener(e -> {
                this.disposeSelecteds();
                this.refreshList();
                this.updateMemoryUsage();
            });
            this.disposeButton.setEnabled(true);
            this.disposablesTable.getSelectionModel().addListSelectionListener(arg0 -> {
                this.ListItemSelected();
                this.updateMemoryUsage();
            });
            this.disposablesTable.setEnabled(true);
            this.refreshButton.addActionListener(arg0 -> {
                this.refreshList();
                this.updateMemoryUsage();
            });
            this.refreshButton.setEnabled(true);
            this.btnGC.addActionListener(arg0 -> {
                System.gc();
                this.updateMemoryUsage();
            });
            this.btnGC.setEnabled(true);
            this.btnRefreshMemory.addActionListener(arg0 -> this.updateMemoryUsage());
            this.btnRefreshMemory.setEnabled(true);
        }

        private TableColumn createTableColumn(int col, int size, String name) {
            TableColumn tableColumn = new TableColumn(col, size);
            tableColumn.setHeaderValue(name);
            return tableColumn;
        }

        private void refreshList() {
            this.fillTable();
        }

        private void ListItemSelected() {
            DisposablesTableModel model = (DisposablesTableModel)this.disposablesTable.getModel();
            DisposableInfo info = model.get(this.disposablesTable.getSelectedRow());
            if (info == null) {
                this.infoTextArea.setText("");
            } else {
                this.infoTextArea.setText(this.toHTML(info));
                this.infoTextArea.setCaretPosition(0);
            }
        }

        private void fillTable() {
            Set disposables = this.manager.getBoundDisposables();
            this.messageLabel.setText("Disposables " + disposables.size());
            this.disposablesTable.setModel(new DisposablesTableModel(new ArrayList<DisposableInfo>(disposables)));
            this.messageLabel.setText("Pending " + disposables.size());
            this.infoTextArea.setText("");
        }

        private void updateMemoryUsage() {
            Runtime rt = Runtime.getRuntime();
            this.lblTotalMemory.setText(String.valueOf(rt.totalMemory() / 1024L));
            this.lblMaxMemory.setText(String.valueOf(rt.maxMemory() / 1024L));
            this.lblFreeMemory.setText(String.valueOf(rt.freeMemory() / 1024L));
            this.lblActiveThreads.setText(String.valueOf(Thread.activeCount()));
            int objectPendingFinalizationCount = -1;
            try {
                MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
                objectPendingFinalizationCount = memBean.getObjectPendingFinalizationCount();
            }
            catch (ThreadDeath threadDeath) {
                // empty catch block
            }
            this.lblObjectPendingFinalization.setText(String.valueOf(objectPendingFinalizationCount));
        }

        public String toHTML(DisposableInfo disposableInfo) {
            StringBuilder buffer = new StringBuilder();
            Disposable disposable = disposableInfo.getDisposable();
            int code = disposable.hashCode();
            buffer.append("<b>Class</b>: ").append(disposable.getClass().getSimpleName()).append("<br>\n");
            buffer.append("<b>Full class</b>: ").append(disposable.getClass().getName()).append("<br>\n");
            buffer.append("<b>References</b>: ").append(disposableInfo.getReferencesCount()).append("<br>\n");
            buffer.append(String.format("<b>Code</b>: %x (%d)<br>\n", code, code));
            buffer.append("<b>toString</b>: ").append(disposable.toString()).append("<br>\n");
            try {
                List allStackTraces = disposableInfo.getAllStackTrace();
                for (int i = 0; i < allStackTraces.size(); ++i) {
                    LabeledValue trace = (LabeledValue)allStackTraces.get(i);
                    buffer.append("<b>#");
                    buffer.append(i + 1);
                    buffer.append(" ");
                    buffer.append(trace.getLabel());
                    buffer.append(" from (stack)</b>:<br>\n");
                    for (StackTraceElement stackTrace1 : (StackTraceElement[])trace.getValue()) {
                        buffer.append("&nbsp;&nbsp;").append(stackTrace1.toString().replaceAll("[<]", "&lt;").replace("[>]", "&gt;")).append("<br>\n");
                    }
                }
            }
            catch (Exception ex) {
                buffer.append("<br>\n<br>\nError showing stack.<br>\n").append(ex.getMessage());
            }
            return buffer.toString();
        }

        public void closeWindow() {
            this.setVisible(false);
        }

        public void disposeAll() {
            try {
                this.manager.releaseAll();
            }
            catch (BaseException ex) {
                LOG.error("Error disposing all bound disposable objects", (Throwable)ex);
            }
        }

        public void disposeSelecteds() {
            DisposablesTableModel model = (DisposablesTableModel)this.disposablesTable.getModel();
            for (int row : this.disposablesTable.getSelectedRows()) {
                DisposableInfo info = model.get(row);
                this.manager.release(info.getDisposable());
            }
            this.refreshList();
        }

        public void showPanel() {
            WindowManager wm = ToolsSwingLocator.getWindowManager();
            wm.showWindow((JComponent)this, "Disposable do list", WindowManager.MODE.WINDOW);
        }

        private class DisposablesTableModel
        extends AbstractTableModel {
            private List<DisposableInfo> disposables;
            private final String[] columnNames;
            private final Class[] columnClass;

            public DisposablesTableModel() {
                this(Collections.EMPTY_LIST);
            }

            public DisposablesTableModel(List<DisposableInfo> disposables) {
                this.disposables = disposables;
                this.columnNames = new String[]{"Refs.", "Class", "Code", "Full class", "To str."};
                this.columnClass = new Class[]{Integer.class, String.class, String.class, String.class, String.class};
            }

            public DisposableInfo get(int rowIndex) {
                try {
                    return this.disposables.get(rowIndex);
                }
                catch (Throwable th) {
                    return null;
                }
            }

            @Override
            public int getRowCount() {
                return this.disposables.size();
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return this.columnNames[columnIndex];
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.columnClass[columnIndex];
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                DisposableInfo info = this.disposables.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return info.getReferencesCount();
                    }
                    case 1: {
                        try {
                            return info.getDisposable().getClass().getSimpleName();
                        }
                        catch (Throwable th) {
                            return "(unknown)";
                        }
                    }
                    case 2: {
                        try {
                            return String.format("%x", info.getDisposable().hashCode());
                        }
                        catch (Throwable th) {
                            return -1;
                        }
                    }
                    case 3: {
                        try {
                            return info.getDisposable().getClass().getName();
                        }
                        catch (Throwable th) {
                            return "(unknown)";
                        }
                    }
                    case 4: {
                        try {
                            return info.getDisposable().toString();
                        }
                        catch (Throwable th) {
                            return "(unknown)";
                        }
                    }
                }
                return null;
            }
        }
    }
}

