/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.evalexpression;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.evalexpression.EvaluateExpressionPanelView;
import org.gvsig.app.extension.evalexpression.notifierfactory.UpdaterFactory;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.swing.Element;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateExpressionPanel
extends EvaluateExpressionPanelView {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateExpressionPanel.class);
    private ExpressionPickerController pickerExpression;
    private static Map<String, UpdaterFactory> updaterFactories = new HashMap<String, UpdaterFactory>();
    private JListWithCheckbox chklstUpdaters;
    private Arguments arguments = Arguments.create(null);

    public EvaluateExpressionPanel(FeatureStore store) {
        this.initComponents(store);
    }

    public static void registerUpdater(UpdaterFactory factory) {
        updaterFactories.put(factory.getName(), factory);
    }

    private void initComponents(FeatureStore store) {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.pickerExpression = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtExpression, this.btnExpression, this.btnExpressionHistory, this.btnExpressionBookmarks);
        if (store != null) {
            this.pickerExpression.getConfig().addElement((Element)DALSwingLocator.getDataSwingManager().createFeatureStoreElement(store));
        }
        MutableSymbolTable symbolTable = ExpressionUtils.createSymbolTable();
        IWindow window = application.getActiveWindow();
        symbolTable.setVar("window", (Object)window);
        symbolTable.setVar("arguments", (Object)this.arguments);
        symbolTable.setVar("notification", (Object)new BaseNotification("Unknown", 1));
        this.pickerExpression.getConfig().setPreviewSymbolTable((SymbolTable)symbolTable);
        this.btnExecute.addActionListener(e -> this.doExecuteExpression());
        this.txtTitle.setText("Expresion");
        this.chklstUpdaters = toolsSwingManager.createJListWithCheckbox(this.lstUpdaters);
        DefaultListModel<UpdaterFactory> model = new DefaultListModel<UpdaterFactory>();
        for (UpdaterFactory factory : updaterFactories.values()) {
            model.addElement(factory);
        }
        this.chklstUpdaters.setModel(model);
        this.btnMakeScript.addActionListener(e -> this.doMakeScript());
    }

    private void doMakeScript() {
    }

    private void doExecuteExpression() {
        Object value;
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        WindowManager windowManager = ToolsSwingLocator.getWindowManager();
        Expression exp = this.pickerExpression.get();
        if (exp == null) {
            return;
        }
        MutableSymbolTable symbolTable = ExpressionUtils.createSymbolTable();
        IWindow window = application.getActiveWindow();
        symbolTable.setVar("window", (Object)window);
        symbolTable.setVar("arguments", (Object)this.arguments);
        symbolTable.setVar("notification", (Object)new BaseNotification("Unknown", 1));
        this.pickerExpression.getConfig().setPreviewSymbolTable((SymbolTable)symbolTable);
        try {
            value = exp.execute((SymbolTable)symbolTable);
        }
        catch (Throwable th) {
            LOGGER.warn("", th);
            return;
        }
        if (value == null) {
            return;
        }
        MyPanel panel = new MyPanel(symbolTable, exp, (String)this.cboContentType.getSelectedItem());
        ListSelectionModel checkModel = this.chklstUpdaters.getCheckedModel();
        ListModel model = this.chklstUpdaters.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!checkModel.isSelectedIndex(i)) continue;
            UpdaterFactory factory = (UpdaterFactory)model.getElementAt(i);
            panel.addUpdater(factory.create(panel));
        }
        panel.setValue(value);
        if (this.arguments.contains("width") && this.arguments.contains("height")) {
            int w = (Integer)this.arguments.get("width", (Object)100);
            int h = (Integer)this.arguments.get("height", (Object)100);
            panel.setPreferredSize(new Dimension(w, h));
        } else if (this.arguments.contains("rows") && this.arguments.contains("columns")) {
            int rows = (Integer)this.arguments.get("rows", (Object)2);
            int columns = (Integer)this.arguments.get("columns", (Object)50);
            ToolsSwingUtils.ensureRowsCols((JComponent)panel, (int)rows, (int)columns);
        }
        windowManager.showWindow((JComponent)panel, this.txtTitle.getText(), this.getWindowMode());
    }

    private WindowManager.MODE getWindowMode() {
        String s = (String)this.cboWindowType.getSelectedItem();
        switch (s.toLowerCase()) {
            case "modal": 
            case "dialog": {
                return WindowManager.MODE.DIALOG;
            }
            case "tool": 
            case "palette": 
            case "semimodal": {
                return WindowManager.MODE.TOOL;
            }
        }
        return WindowManager.MODE.WINDOW;
    }

    public void setParameters(Arguments arguments) {
        this.arguments = arguments;
        if (this.arguments.contains("title")) {
            this.txtTitle.setText((String)this.arguments.get("title"));
        }
        if (this.arguments.contains("windowtype")) {
            this.cboWindowType.setSelectedItem(this.arguments.get("windowtype"));
        }
        if (this.arguments.contains("conenttype")) {
            this.cboContentType.setSelectedItem(this.arguments.get("conenttype"));
        }
        if (this.arguments.contains("expression")) {
            this.pickerExpression.set((Object)ExpressionUtils.createExpression((String)((String)this.arguments.get("expression"))));
        }
        ListModel updatersModel = this.chklstUpdaters.getModel();
        ListSelectionModel checksUpdaters = this.chklstUpdaters.getCheckedModel();
        for (int i = 0; i < updatersModel.getSize(); ++i) {
            UpdaterFactory factory = (UpdaterFactory)updatersModel.getElementAt(i);
            if (StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)((CharSequence)this.arguments.get("set" + factory.getName(), (Object)"false")))) {
                checksUpdaters.setSelectionInterval(i, i);
                continue;
            }
            checksUpdaters.removeSelectionInterval(i, i);
        }
        if (this.arguments.contains("execute")) {
            this.doExecuteExpression();
        }
    }

    private static class MyPanel
    extends JPanel
    implements Observer {
        private final Expression expression;
        private final String contentType;
        private final MutableSymbolTable symbolTable;
        private boolean isProcessing;
        private Thread lastUpdate = null;
        private final List<UpdaterFactory.Updater> updaters;

        public MyPanel(MutableSymbolTable symbolTable, Expression expression, String contentType) {
            this.setOpaque(false);
            this.updaters = new ArrayList<UpdaterFactory.Updater>();
            this.symbolTable = symbolTable;
            this.expression = expression;
            this.contentType = contentType;
            this.isProcessing = false;
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    this.removeUpdaters();
                }
            });
        }

        private synchronized void doUpdate(Object notification) {
            Thread th = new Thread(() -> {
                MutableSymbolTable mutableSymbolTable = this.symbolTable;
                synchronized (mutableSymbolTable) {
                    this.isProcessing = true;
                    Object value = null;
                    try {
                        this.symbolTable.setVar("notification", notification == null ? new BaseNotification("Unknown", 0) : notification);
                        value = this.expression.execute((SymbolTable)this.symbolTable);
                        this.setValue(value);
                    }
                    catch (Throwable tt) {
                        LOGGER.warn("", tt);
                    }
                    if (this.lastUpdate != null) {
                        this.lastUpdate.start();
                        this.lastUpdate = null;
                    } else {
                        this.isProcessing = false;
                    }
                }
            }, "EvaluateExpressionPanel_update");
            if (this.isProcessing) {
                this.lastUpdate = th;
                return;
            }
            th.start();
        }

        public void setValue(Object value) {
            JComponent component;
            if (!SwingUtilities.isEventDispatchThread()) {
                Object v = value;
                SwingUtilities.invokeLater(() -> this.setValue(v));
                return;
            }
            if (value == null) {
                this.removeAll();
                this.revalidate();
                return;
            }
            if (value instanceof SimpleImage) {
                value = ((SimpleImage)value).getBufferedImage();
            }
            if (value instanceof Image) {
                JLabel label = new JLabel();
                label.setIcon(new ImageIcon((Image)value));
                value = label;
            }
            if (value instanceof JComponent) {
                component = (JComponent)value;
            } else {
                JEditorPane browser = new JEditorPane();
                browser.setEditable(false);
                browser.setOpaque(false);
                browser.setContentType(this.contentType);
                browser.setText(Objects.toString(value));
                component = browser;
            }
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add(component);
            this.revalidate();
        }

        public void removeUpdaters() {
            for (UpdaterFactory.Updater updater : this.updaters) {
                updater.remove();
            }
        }

        public void addUpdater(UpdaterFactory.Updater updater) {
            this.updaters.add(updater);
            updater.add();
        }

        public void update(Observable observable, Object notification) {
            this.doUpdate(notification);
        }
    }
}

