/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.evalexpression.notifierfactory;

import org.gvsig.app.extension.evalexpression.notifierfactory.UpdaterFactory;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpdaterFactory
implements UpdaterFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractUpdaterFactory.class);
    private final String label;
    private final String name;

    public AbstractUpdaterFactory(String name, String label) {
        this.name = name;
        this.label = label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public AbstractUpdaterFactory getValue() {
        return this;
    }

    public String toString() {
        return this.getLabel();
    }

    public static abstract class AbstractUpdater
    implements UpdaterFactory.Updater {
        private final UpdaterFactory factory;
        private final Observer observer;

        public AbstractUpdater(UpdaterFactory factory, Observer observer) {
            if (observer == null || factory == null) {
                throw new IllegalArgumentException();
            }
            this.factory = factory;
            this.observer = observer;
        }

        @Override
        public UpdaterFactory getFactory() {
            return this.factory;
        }

        public void addObserver(Observer o) {
        }

        public void deleteObserver(Observer o) {
        }

        public void deleteObservers() {
        }

        @Override
        public void update() {
            this.update(null);
        }

        @Override
        public void update(Notification n) {
            try {
                if (n == null) {
                    n = new BaseNotification(this.getFactory().getName(), 0);
                }
                this.observer.update((Observable)this, (Object)n);
            }
            catch (Throwable ex) {
                LOGGER.warn("Can't update expression panel", ex);
            }
        }
    }
}

