/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.geometriespalette;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.extension.geometriespalette.GeometriesPalettePanelView;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.featuretype.FeatureAttributeListCellRenderer;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.SimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.SimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.SimpleMarkerSymbol;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.FilteredListController;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class GeometriesPalettePanel
extends GeometriesPalettePanelView
implements Component {
    private AttributeDescriptorPickerController labelPicker;
    private FeatureAttributeDescriptor attributeLabel;
    private ISymbol symbol;
    private FeatureAttributeDescriptor geomattr;
    private FeatureStore store;
    private FilteredListController dataController;
    private AttributeDescriptorPickerController colorPicker;
    private ExpressionPickerController filterPicker;

    public GeometriesPalettePanel() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getDataSwingManager();
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        FeatureAttributeListCellRenderer renderer = dataSwingManager.createDefaultFeatureAttributeListCellRenderer();
        renderer.setUseLabels(Integer.valueOf(1));
        this.cboLabel.setRenderer(renderer);
        this.labelPicker = dataSwingManager.createAttributeDescriptorPickerController(this.cboLabel);
        this.labelPicker.addChangeListener(e -> this.doChangeAttrLabel());
        renderer = dataSwingManager.createDefaultFeatureAttributeListCellRenderer();
        renderer.setUseLabels(Integer.valueOf(1));
        this.cboColor.setRenderer(renderer);
        this.colorPicker = dataSwingManager.createAttributeDescriptorPickerController(this.cboColor);
        this.colorPicker.addChangeListener(e -> this.doChangeAttrColor());
        this.colorPicker.setAllowNull(true);
        renderer = dataSwingManager.createDefaultFeatureAttributeListCellRenderer();
        renderer.setUseLabels(Integer.valueOf(1));
        this.filterPicker = expressionSwingManager.createExpressionPickerController((JTextComponent)this.txtFilter, this.btnFilter);
        this.filterPicker.addChangeListener(e -> this.doChangeAttrLabel());
        SpinnerNumberModel spnSizeModel = new SpinnerNumberModel(100, 30, 600, 10);
        this.spnSize.setModel(spnSizeModel);
        this.spnSize.addChangeListener(e -> this.doChangeSize());
        this.lstData.setCellRenderer(new FeratureWithGeomCellRenderer());
        this.lstData.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.doCopyFeature();
        });
        this.dataController = toolsSwingManager.createFilteredListController(this.lstData, (JTextComponent)this.txtDataFilter, this.btnDataFilter);
        this.colorPicker.setEnabled(false);
        this.filterPicker.setEnabled(true);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)25, (int)40, (int)25, (int)80);
    }

    private void doChangeSize() {
        this.lstData.updateUI();
    }

    private void doChangeAttrGroup() {
    }

    private void doChangeAttrColor() {
    }

    private void doCopyFeature() {
        try {
            LabeledValue x = (LabeledValue)this.lstData.getSelectedValue();
            if (x == null) {
                return;
            }
            DataManager dataManager = DALLocator.getDataManager();
            FeatureSelection selection = this.store.createFeatureSelection();
            for (Feature feature : (List)x.getValue()) {
                selection.select(feature);
            }
            dataManager.putFeaturesInClipboard((FeatureSet)selection);
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    private Image drawGeometry(List<Feature> features) {
        int pixels = (Integer)this.spnSize.getValue();
        Dimension size = new Dimension(pixels, pixels);
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        ViewPort viewPort = new ViewPort();
        viewPort.setImageSize(size);
        viewPort.setProjection(this.geomattr.getSRS());
        if (features.size() == 1) {
            Geometry geom = (Geometry)features.get(0).get(this.geomattr.getName());
            viewPort.setEnvelope(geom.getEnvelope());
        } else {
            Envelope envelope = GeometryUtils.createEnvelope((int)0);
            for (Feature feature : features) {
                Geometry geom = (Geometry)feature.get(this.geomattr.getName());
                envelope.add(geom);
            }
            viewPort.setEnvelope(envelope);
        }
        for (Feature feature : features) {
            Geometry geom = (Geometry)feature.get(this.geomattr.getName());
            this.symbol.draw((Graphics2D)img.getGraphics(), viewPort.getAffineTransform(), geom, feature, null);
        }
        return img;
    }

    private void doChangeAttrLabel() {
        this.attributeLabel = (FeatureAttributeDescriptor)this.labelPicker.get();
        this.lstData.setModel(new DataModel(this.store, this.getFilter(), this.attributeLabel));
    }

    public void setFilter(String filter) {
        this.filterPicker.set((Object)ExpressionUtils.createExpression((String)filter));
    }

    public void setFilter(Expression filter) {
        this.filterPicker.set((Object)filter);
    }

    public void setFeatureStore(FeatureStore store) {
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        this.store = store;
        FeatureType featureType = store.getDefaultFeatureTypeQuietly();
        this.lstData.setModel(new DataModel());
        this.labelPicker.setFeatureType(featureType);
        this.colorPicker.setFeatureType(featureType);
        dataSwingManager.configureExpressionBuilder(this.filterPicker.getConfig(), this.store);
        this.geomattr = featureType.getDefaultGeometryAttribute();
        GeometryType geomtype = this.geomattr.getGeomType();
        if (GeometryUtils.isSubtype((int)1, (int)geomtype.getType()) || GeometryUtils.isSubtype((int)7, (int)geomtype.getType())) {
            this.symbol = new SimpleMarkerSymbol();
        } else if (GeometryUtils.isSubtype((int)3, (int)geomtype.getType()) || GeometryUtils.isSubtype((int)9, (int)geomtype.getType())) {
            this.symbol = new SimpleFillSymbol();
        } else if (GeometryUtils.isSubtype((int)2, (int)geomtype.getType()) || GeometryUtils.isSubtype((int)8, (int)geomtype.getType())) {
            this.symbol = new SimpleLineSymbol();
        }
    }

    public void updateListContents() {
        this.lstData.setModel(new DataModel(this.store, this.getFilter(), this.attributeLabel));
    }

    public static void showPalette(FLyrVect layer) {
        GeometriesPalettePanel.showPalette(layer.getFeatureStore(), null, null, null);
    }

    public static void showPalette(FeatureStore store, String labelattr, String title, String filter) {
        WindowManager windowManager = ToolsSwingLocator.getWindowManager();
        FeatureType featureType = store.getDefaultFeatureTypeQuietly();
        Tags tags = featureType.getTags();
        if (StringUtils.isBlank((CharSequence)title)) {
            title = tags.getString("geometriespalette.title", "");
        }
        if (StringUtils.isBlank((CharSequence)filter)) {
            filter = tags.getString("geometriespalette.filter", null);
        }
        if (StringUtils.isBlank((CharSequence)labelattr)) {
            labelattr = tags.getString("geometriespalette.attribute.label", null);
        }
        String attrColor = tags.getString("geometriespalette.attribute.color", null);
        int size = tags.getInt("geometriespalette.size", -1);
        GeometriesPalettePanel palette = new GeometriesPalettePanel();
        palette.setFilter(filter);
        palette.setFeatureStore(store);
        palette.setColorAttributeName(attrColor);
        if (size > 0) {
            palette.setSize(size);
        }
        if (StringUtils.isNotBlank((CharSequence)labelattr)) {
            palette.setLabelAttributeName(labelattr);
        }
        if (StringUtils.isBlank((CharSequence)title)) {
            title = ToolsSwingUtils.makeTitle((String)"Palette", (String)store.getName(), null);
        }
        windowManager.showWindow(palette.asJComponent(), title, WindowManager.MODE.TOOL);
    }

    void setLabelAttributeName(String labelattr) {
        this.labelPicker.set(labelattr);
    }

    void setColorAttributeName(String attrColor) {
        this.colorPicker.set(attrColor);
    }

    public void setSize(int size) {
        this.spnSize.setValue(size);
    }

    private static FeatureSet createFeatureSet(FeatureStore store, Expression filter, String groupAttributeName) {
        try {
            FeatureSet features = store.getFeatureSet(filter, groupAttributeName);
            return features;
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't create feature set", ex);
        }
    }

    public JComponent asJComponent() {
        if (this.lstData.getModel().getSize() == 0) {
            this.updateListContents();
        }
        return this;
    }

    public Expression getFilter() {
        return this.filterPicker.get();
    }

    private static class DataModel
    extends AbstractListModel<LabeledValue<List<Feature>>> {
        private List<LabeledValue<List<Feature>>> elements = Collections.EMPTY_LIST;
        private FeatureAttributeDescriptor attributeLabel;

        public DataModel() {
        }

        public DataModel(FeatureAttributeDescriptor attributeLabel) {
            this();
            this.attributeLabel = attributeLabel;
        }

        public DataModel(FeatureStore store, Expression filter, final FeatureAttributeDescriptor attributeLabel) {
            this(attributeLabel);
            String order = null;
            if (attributeLabel != null) {
                order = attributeLabel.getName();
            }
            final List features = store.getFeatures(filter, order);
            this.elements = new AbstractList<LabeledValue<List<Feature>>>(){

                @Override
                public LabeledValue<List<Feature>> get(int index) {
                    Feature feature = (Feature)features.get(index);
                    String label = "";
                    if (attributeLabel != null) {
                        label = feature.getLabelOfValue(attributeLabel.getName());
                    }
                    return new LabeledValueImpl(label, Collections.singletonList(feature));
                }

                @Override
                public int size() {
                    return features.size();
                }
            };
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        @Override
        public LabeledValue<List<Feature>> getElementAt(int index) {
            LabeledValue<List<Feature>> element = this.elements.get(index);
            return element;
        }
    }

    private class FeratureWithGeomCellRenderer
    extends DefaultListCellRenderer {
        private FeratureWithGeomCellRenderer() {
        }

        @Override
        public java.awt.Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            try {
                LabeledValue x = (LabeledValue)value;
                if (x != null && x.getValue() != null && GeometriesPalettePanel.this.symbol != null) {
                    Image img = GeometriesPalettePanel.this.drawGeometry((List)x.getValue());
                    label.setHorizontalAlignment(0);
                    label.setHorizontalTextPosition(0);
                    label.setVerticalTextPosition(3);
                    label.setIcon(new ImageIcon(img));
                    if (StringUtils.isBlank((CharSequence)x.getLabel())) {
                        label.setText("(Configure label)");
                    } else {
                        label.setText(x.getLabel());
                    }
                }
            }
            catch (Throwable th) {
                label.setText("Error");
            }
            return label;
        }
    }
}

