/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.extension.Version;
import org.gvsig.utils.BrowserControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FPanelAbout
extends JPanel
implements IWindow {
    private static final Logger logger = LoggerFactory.getLogger(FPanelAbout.class);
    private JEditorPane jEditorPane = null;
    private JScrollPane jScrollPane = null;
    private JEditorPane jEditorPane1 = null;
    private JPanel jPanel = null;
    private JButton jButton = null;
    private JLabel jLblVersion = null;
    private JLabel jLblJavaVersion = null;
    private JTabbedPane jTabbedPane = null;

    public FPanelAbout() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(600, 450);
        this.add((Component)this.getJTabbedPane(), "Center");
        this.add((Component)this.getJPanel(), "South");
    }

    private JScrollPane getJScrollPane(URL url) {
        this.jScrollPane = new JScrollPane();
        this.jScrollPane.setPreferredSize(new Dimension(300, 400));
        this.jScrollPane.setViewportView(this.getJEditorPane(url));
        return this.jScrollPane;
    }

    private JEditorPane getJEditorPane(URL aboutURL) {
        this.jEditorPane = new JEditorPane();
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setPreferredSize(new Dimension(300, 200));
        if (aboutURL != null) {
            try {
                this.jEditorPane.setPage(aboutURL);
                this.jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            JEditorPane pane = (JEditorPane)e.getSource();
                            System.out.println("hyperlinkUpdate()");
                            BrowserControl.displayURL((String)e.getURL().toString());
                        }
                    }
                });
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + aboutURL);
            }
        } else {
            System.err.println("Couldn't find file: about.html" + aboutURL.getPath());
        }
        return this.jEditorPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLblVersion = new JLabel();
            this.jLblJavaVersion = new JLabel();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setPreferredSize(new Dimension(10, 50));
            this.jLblVersion.setBounds(10, 16, 205, 17);
            this.jLblVersion.setText("Version " + Version.longFormat());
            this.jLblJavaVersion.setBounds(415, 16, 150, 17);
            this.jLblJavaVersion.setText("Java " + System.getProperties().get("java.version"));
            this.jPanel.add((Component)this.getJButton(), null);
            this.jPanel.add((Component)this.jLblVersion, null);
            this.jPanel.add((Component)this.jLblJavaVersion, null);
        }
        return this.jPanel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setHorizontalTextPosition(0);
            this.jButton.setText(PluginServices.getText((Object)this, (String)"Cerrar"));
            this.jButton.setBounds(266, 12, 94, 25);
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("actionPerformed()");
                    if (PluginServices.getMainFrame() != null) {
                        PluginServices.getMDIManager().closeWindow((IWindow)FPanelAbout.this);
                    } else {
                        ((JDialog)FPanelAbout.this.getParent().getParent().getParent().getParent()).dispose();
                    }
                }
            });
        }
        return this.jButton;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_ViewInfo = new WindowInfo(9);
        m_ViewInfo.setTitle(PluginServices.getText((Object)this, (String)"acerca_de"));
        return m_ViewInfo;
    }

    public void viewActivated() {
    }

    public void addAboutUrl(String pluginName, URL url) {
        this.getJTabbedPane().addTab(pluginName, this.getJScrollPane(url));
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setPreferredSize(new Dimension(5, 50));
        }
        return this.jTabbedPane;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }
}

