/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage.dialogreminder;

import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.app.gui.preferencespage.dialogreminder.DialogReminderView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.JListWithCheckbox;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.reminder.DialogReminder;
import org.gvsig.tools.swing.api.reminder.DialogReminderManager;

public class DialogReminderPage
extends DialogReminderView
implements IPreference {
    private static final long serialVersionUID = 3811078625224506453L;
    private JListWithCheckbox lstCheckdsRemembers;
    public static String id = DialogReminderPage.class.getName();
    private ImageIcon icon;

    public DialogReminderPage() {
        this.initComponents();
    }

    private void initComponents() {
        this.icon = IconThemeHelper.getImageIcon((String)"dialog-remember-preferences");
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        this.lstCheckdsRemembers = swingManager.createJListWithCheckbox(this.lstRemembers);
        final ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        checkModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int n = e.getFirstIndex();
                if (n <= DialogReminderPage.this.lstCheckdsRemembers.getModel().getSize()) {
                    return;
                }
                ListElement element = (ListElement)DialogReminderPage.this.lstCheckdsRemembers.getModel().getElementAt(n);
                if (element == null) {
                    return;
                }
                if (checkModel.isSelectedIndex(n) && !((DialogReminder)element.getValue()).hasValue()) {
                    checkModel.removeIndexInterval(n, n);
                }
            }
        });
        this.translateAll();
    }

    private void translateAll() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.lblTitle.setText(i18n.getTranslation(this.lblTitle.getText()));
    }

    public boolean isResizeable() {
        return true;
    }

    public void initializeValues() {
        DialogReminderManager remembers = ToolsSwingLocator.getDialogReminderManager();
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        checkModel.clearSelection();
        int n = 0;
        for (DialogReminder remember : remembers.reminders()) {
            model.addElement(new ListElement(remember.getId(), (Object)remember));
            if (remember.hasValue()) {
                checkModel.addSelectionInterval(n, n);
            }
            ++n;
        }
        this.lstCheckdsRemembers.setModel(model);
    }

    public void initializeDefaults() {
        DialogReminderManager remembers = ToolsSwingLocator.getDialogReminderManager();
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        for (DialogReminder remember : remembers.reminders()) {
            model.addElement(new ListElement(remember.getId(), (Object)remember));
        }
        this.lstCheckdsRemembers.setModel(model);
        checkModel.clearSelection();
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Remembered_dialogs");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        DialogReminderManager remembers = ToolsSwingLocator.getDialogReminderManager();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        int n = 0;
        for (DialogReminder remember : remembers.reminders()) {
            if (!checkModel.isSelectedIndex(n)) {
                remember.reset();
            }
            ++n;
        }
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isValueChanged() {
        DialogReminderManager remembers = ToolsSwingLocator.getDialogReminderManager();
        ListSelectionModel checkModel = this.lstCheckdsRemembers.getCheckedModel();
        int n = 0;
        for (DialogReminder remember : remembers.reminders()) {
            if (checkModel.isSelectedIndex(n) != remember.hasValue()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setChangesApplied() {
    }
}

