/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.extension.Version;
import org.gvsig.app.project.DocumentsContainer;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectExtent;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.ProjectNotification;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.exceptions.SaveException;
import org.gvsig.app.project.documents.gui.IDocumentWindow;
import org.gvsig.app.project.documents.gui.ProjectWindow;
import org.gvsig.app.project.documents.view.DefaultViewDocument;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.mapcontext.layers.ExtendedPropertiesHelper;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.utils.StringUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProject
implements Serializable,
PropertyChangeListener,
Project {
    private Logger LOG = LoggerFactory.getLogger(DefaultProject.class);
    public static String VERSION = Version.format();
    private ExtendedPropertiesHelper propertiesHelper = new ExtendedPropertiesHelper();
    private ObservableHelper observableHelper = new ObservableHelper();
    private static final long serialVersionUID = -4449622027521773178L;
    private static final Logger logger = LoggerFactory.getLogger(Project.class);
    private static ProjectPreferences preferences = new ProjectPreferences();
    private Map<String, Integer> nextDocumentIndexByType = new HashMap<String, Integer>();
    private PropertyChangeSupport change = new PropertyChangeSupport(this);
    private boolean modified = false;
    private String name = null;
    private String creationDate = null;
    private String modificationDate = null;
    private String owner = null;
    private String comments = null;
    private Color selectionColor = null;
    private List<Document> documents = null;
    private List<ProjectExtent> extents = null;
    private IProjection projection;
    private File fname = null;
    private Set<String> unloadedObjects;
    private PersistenceException loadErrors = null;

    DefaultProject() {
        this.clean();
        this.notifyProjectManagerEvent(21);
    }

    protected void clean() {
        this.owner = "";
        this.comments = "";
        this.name = PluginServices.getText((Object)this, (String)"untitled");
        this.modificationDate = this.creationDate = DateFormat.getDateInstance().format(new Date());
        this.documents = new ArrayList<Document>();
        this.extents = new ArrayList<ProjectExtent>();
        this.setSelectionColor(DefaultProject.getPreferences().getDefaultSelectionColor());
        this.projection = null;
    }

    public static ProjectPreferences getPreferences() {
        return preferences;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.change.firePropertyChange(evt);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener arg0) {
        this.change.addPropertyChangeListener(arg0);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.change.removePropertyChangeListener(listener);
    }

    @Override
    public String getCreationDate() {
        return this.creationDate;
    }

    protected void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
        this.change.firePropertyChange("setCreationDate", null, null);
    }

    @Override
    public Document createDocument(String type) {
        logger.info("createDocument('{}')", (Object)type);
        return ProjectManager.getInstance().createDocument(type);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.change.firePropertyChange("setName", null, null);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String string) {
        this.comments = string;
        this.change.firePropertyChange("setComments", null, null);
    }

    @Override
    public String getModificationDate() {
        return this.modificationDate;
    }

    protected void setModificationDate(String string) {
        this.modificationDate = string;
        this.change.firePropertyChange("setModificationDate", null, null);
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
        this.change.firePropertyChange("setOwner", null, null);
    }

    @Override
    public Color getSelectionColor() {
        return this.selectionColor;
    }

    @Override
    public void setSelectionColor(String selectionColor) {
        if (StringUtils.isBlank((CharSequence)selectionColor)) {
            return;
        }
        this.setSelectionColor(StringUtilities.string2Color((String)selectionColor));
    }

    @Override
    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            return;
        }
        this.selectionColor = selectionColor;
        this.change.firePropertyChange("selectionColor", null, selectionColor);
    }

    @Override
    public IProjection getProjection() {
        if (this.projection == null) {
            this.projection = DefaultProject.getPreferences().getDefaultProjection();
        }
        return this.projection;
    }

    @Override
    public void setProjection(IProjection projection) {
        this.projection = projection;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
        if (!modified) {
            List<Document> documents = this.getDocuments();
            for (int i = 0; i < documents.size(); ++i) {
                documents.get(i).setModified(false);
            }
        }
    }

    @Override
    public boolean hasChanged() {
        if (this.modified) {
            return true;
        }
        if (this.getDocuments().isEmpty()) {
            return false;
        }
        for (Document document : this.getDocuments()) {
            if (document.isTemporary() || !document.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Document> getDocuments() {
        return this.getDocuments((Predicate<Document>)null);
    }

    @Override
    public List<Document> getDocuments(String type) {
        return this.getDocuments((Document t) -> t != null && (type == null || StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)t.getTypeName())));
    }

    @Override
    public List<Document> getDocuments(Class<? extends Document> documentClass) {
        return this.getDocuments((Document t) -> t != null && (documentClass == null || documentClass.isAssignableFrom(t.getClass())));
    }

    @Override
    public List<Document> getDocuments(Predicate<Document> filter) {
        ArrayList<Object> docs;
        if (filter == null) {
            docs = new ArrayList<Document>(this.documents);
        } else {
            docs = new ArrayList();
            for (Document document : this.documents) {
                if (!filter.test(document)) continue;
                docs.add(document);
            }
        }
        Collections.sort(docs, (o1, o2) -> StringUtils.compareIgnoreCase((String)o1.getName(), (String)o2.getName()));
        return Collections.unmodifiableList(docs);
    }

    @Override
    public void add(Document document) {
        this.addDocument(document);
    }

    @Override
    public void addDocument(Document document) {
        logger.info("add('{}')", (Object)document.toString());
        if (this.notifyObservers(1, document).isProcessCanceled()) {
            return;
        }
        document.addPropertyChangeListener(this);
        document.setProject(this);
        document.setName(this.getUniqueNameForDocument(document.getTypeName(), document.getName()));
        this.documents.add(document);
        DisposeUtils.bind((Object)document);
        document.afterAdd();
        this.setModified(true);
        this.notifyObservers(2, document);
        this.change.firePropertyChange("addDocument", null, document);
    }

    @Override
    public void remove(Document doc) {
        this.removeDocument(doc);
    }

    @Override
    public void removeDocument(Document doc) {
        logger.info("remove('{}')", (Object)doc.toString());
        if (this.notifyObservers(3, doc).isProcessCanceled()) {
            return;
        }
        this.documents.remove(doc);
        this.setModified(true);
        this.change.firePropertyChange("delDocument", doc, null);
        doc.afterRemove();
        this.notifyObservers(4, doc);
        DisposeUtils.disposeQuietly((Object)doc);
    }

    @Override
    public Iterator<Document> iterator() {
        return this.documents.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.documents.isEmpty();
    }

    @Override
    public String getViewName(FLayer layer) {
        List<Document> views = this.getDocuments(ViewManager.TYPENAME);
        for (int v = 0; v < views.size(); ++v) {
            DefaultViewDocument pView = (DefaultViewDocument)views.get(v);
            FLayers layers = pView.getMapContext().getLayers();
            if (!this.isView(layers, layer)) continue;
            return pView.getName();
        }
        throw new RuntimeException(MessageFormat.format("The layer '{1}' is not in a view", layer.getName()));
    }

    private boolean isView(FLayers layers, FLayer layer) {
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            if (layers.getLayer(i) instanceof FLayers && this.isView((FLayers)layers.getLayer(i), layer)) {
                return true;
            }
            if (layers.getLayer(i) != layer) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addExtent(ProjectExtent arg1) {
        this.extents.add(arg1);
        this.change.firePropertyChange("addExtent", null, null);
    }

    @Override
    public ProjectExtent removeExtent(int arg0) {
        this.change.firePropertyChange("delExtent", null, null);
        return this.extents.remove(arg0);
    }

    @Override
    public ProjectExtent[] getExtents() {
        return this.extents.toArray(new ProjectExtent[0]);
    }

    @Override
    public Document getDocument(String name, String type) {
        if (type == null) {
            for (int i = 0; i < this.documents.size(); ++i) {
                Document document = this.documents.get(i);
                if (document == null || !StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)document.getName())) continue;
                return document;
            }
        } else {
            for (int i = 0; i < this.documents.size(); ++i) {
                Document document = this.documents.get(i);
                if (document == null || !StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)document.getTypeName()) || !StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)document.getName())) continue;
                return document;
            }
        }
        return null;
    }

    @Override
    public Document getDocument(Predicate<Document> condition) {
        for (Document document : this.documents) {
            if (document == null || !condition.test(document)) continue;
            return document;
        }
        return null;
    }

    @Override
    public Document getDocument(String name) {
        return this.getDocument(name, null);
    }

    public String getUniqueNameForDocument(String type, String name) {
        Document document = this.getDocument(name, type);
        if (document == null) {
            return name;
        }
        String newName = null;
        int num = this.getNextDocumentIndex(type);
        while (document != null) {
            newName = name + " - " + num++;
            document = this.getDocument(newName, type);
        }
        this.setNextDocumentIndex(type, num);
        return newName;
    }

    private int getNextDocumentIndex(String type) {
        if (this.nextDocumentIndexByType.get(type) == null) {
            this.nextDocumentIndexByType.put(type, 1);
            return 1;
        }
        return this.nextDocumentIndexByType.get(type);
    }

    private void setNextDocumentIndex(String type, int newIndex) {
        if (this.nextDocumentIndexByType.get(type) == null) {
            this.nextDocumentIndexByType.put(type, newIndex);
        } else {
            this.nextDocumentIndexByType.put(type, newIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidZIP(File file) {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(file);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                    zipfile = null;
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public File getFile() {
        return this.fname;
    }

    @Override
    public void saveState(File file, BufferedImage preview) {
        ZipOutputStream zout;
        FileOutputStream fout;
        block14: {
            if (file == null) {
                throw new IllegalArgumentException("file");
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialog = ToolsSwingLocator.getThreadSafeDialogsManager();
            File tmpfile = this.getTempProjectFile(file);
            fout = null;
            zout = null;
            try {
                fout = new FileOutputStream(tmpfile);
                zout = new ZipOutputStream(fout);
                if (this.saveState(zout, tmpfile.getParentFile())) {
                    zout.putNextEntry(new ZipEntry("preview.jpg"));
                    try {
                        ImageIO.write((RenderedImage)preview, "jpg", zout);
                    }
                    catch (IOException ex) {
                        this.LOG.warn("Can't save preview image'.", (Throwable)ex);
                    }
                    IOUtils.closeQuietly((OutputStream)zout);
                    IOUtils.closeQuietly((OutputStream)fout);
                    if (!this.isValidZIP(tmpfile)) {
                        throw new ZipException("Invalid project file '" + tmpfile.getAbsolutePath() + "'");
                    }
                    if (file.exists()) {
                        File bakFile = new File(file.getAbsolutePath() + ".bak");
                        if (bakFile.exists()) {
                            FileUtils.deleteQuietly((File)bakFile);
                        }
                        FileUtils.moveFile((File)file, (File)bakFile);
                    }
                    FileUtils.moveFile((File)tmpfile, (File)file);
                    this.fname = file;
                    dialog.message(i18n.getTranslation("wrote_project"), 1);
                    break block14;
                }
                dialog.message(i18n.getTranslation("The project save was canceled."), 1);
            }
            catch (Exception ex) {
                try {
                    File f;
                    try {
                        if (file.exists()) {
                            f = new File(StringUtils.replaceOnce((String)tmpfile.getAbsolutePath(), (String)"-temp.gvsproj", (String)"-prev.gvsproj"));
                            FileUtils.copyFile((File)file, (File)f);
                        }
                    }
                    catch (Exception e) {
                        this.LOG.warn("Can't copy ");
                    }
                    f = new File(StringUtils.replaceOnce((String)tmpfile.getAbsolutePath(), (String)"-temp.gvsproj", (String)"-err.txt"));
                    this.logExceptionToFile(ex, f, false);
                    throw new RuntimeException("Can't write project in '" + file.getAbsolutePath() + ".\nTemporal file saved in " + tmpfile.getAbsolutePath(), ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zout);
                    IOUtils.closeQuietly((OutputStream)fout);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((OutputStream)zout);
        IOUtils.closeQuietly((OutputStream)fout);
    }

    public void logExceptionToFile(Exception ex, File file, boolean append) {
        try (PrintWriter writer = new PrintWriter(new FileWriter(file, append));){
            writer.println("--- ERROR LOGGED AT " + LocalDateTime.now() + " ---");
            ex.printStackTrace(writer);
            writer.println();
        }
        catch (IOException e) {
            this.LOG.warn("Could not write exception to log file: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    private boolean saveState(OutputStream out, File rootFolder) throws PersistenceException {
        if (this.notifyObservers(11, rootFolder).isProcessCanceled()) {
            return false;
        }
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        PersistentState state = null;
        state = manager.getState((Object)this, true);
        try {
            if (rootFolder != null) {
                state.relativizeFiles(rootFolder);
            }
        }
        catch (Exception ex) {
            state.getContext().addError((Throwable)ex);
        }
        manager.saveState(state, out, true);
        if (state.getContext().getErrors() != null) {
            throw state.getContext().getErrors();
        }
        this.notifyObservers(12, rootFolder);
        return true;
    }

    private File getTempProjectFile(File basefile) {
        if (basefile == null) {
            this.LOG.info("Doesn't have previous project to create a bak");
            return null;
        }
        String qualifier = "temp";
        String ext = ".gvsproj";
        File folder = basefile.getParentFile();
        String basename = FilenameUtils.getBaseName((String)basefile.getAbsolutePath());
        basename = basename.replaceFirst("_[0-9][0-9][0-1][0-9][0-3][0-9][0-2][0-9][0-6][0-9][0-6][0-9][-][a-z]*[.]gvsproj$", "");
        basename = basename.replaceFirst("_[0-9][0-9][0-1][0-9][0-3][0-9][0-2][0-9][0-6][0-9][0-6][0-9]_[0-9]+[-][a-z]*[.]gvsproj$", "");
        int code = 0;
        String timeCode = new SimpleDateFormat("_YYMMddHHmmss").format(new Date());
        File tmpfile = new File(folder, basename + timeCode + "-" + qualifier + ext);
        while (tmpfile.exists()) {
            tmpfile = new File(folder, basename + timeCode + "_" + ++code + "-" + qualifier + ext);
        }
        return tmpfile;
    }

    public void loadState(InputStream in, File rootFolder) {
        if (this.notifyObservers(15, rootFolder).isProcessCanceled()) {
            return;
        }
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        try {
            PersistentContext context = manager.getNewContext();
            context.setCollectErrors(true);
            PersistentState state = manager.loadState(in, context);
            try {
                if (rootFolder != null) {
                    state.derelativizeFiles(rootFolder);
                }
            }
            catch (Exception ex) {
                state.getContext().addError((Throwable)ex);
            }
            this.loadFromState(state);
            this.unloadedObjects = this.getUnloadedObjects(state.getContext());
            this.loadErrors = state.getContext().getErrors();
        }
        catch (PersistenceException e) {
            this.LOG.info("Can't load project to stream", (Throwable)e);
        }
        this.fname = null;
        this.notifyObservers(16, rootFolder);
    }

    private Set<String> getUnloadedObjects(PersistentContext context) {
        HashSet<String> unloadedObjects = new HashSet<String>();
        Iterator statesIterator = context.iterator();
        String className = null;
        while (statesIterator.hasNext()) {
            PersistentState aState = (PersistentState)statesIterator.next();
            try {
                className = aState.getTheClassName();
                DynStruct definition = aState.getDefinition();
                if (definition != null) continue;
                unloadedObjects.add(className);
            }
            catch (Throwable throwable) {}
        }
        if (unloadedObjects.isEmpty()) {
            return null;
        }
        return unloadedObjects;
    }

    @Override
    public Set<String> getUnloadedObjects() {
        return this.unloadedObjects;
    }

    @Override
    public List<Exception> getLoadErrors() {
        return this.loadErrors;
    }

    @Override
    public void loadState(File in) {
        if (this.notifyObservers(13, in).isProcessCanceled()) {
            return;
        }
        try {
            FileInputStream fin = new FileInputStream(in);
            this.loadState(fin, new File(in.getParent()));
        }
        catch (FileNotFoundException e) {
            this.LOG.info("Can't load project to stream", (Throwable)e);
        }
        this.fname = "bak".equals(FilenameUtils.getExtension((String)in.getAbsolutePath())) ? null : in;
        this.notifyObservers(14, in);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.clean();
        PersistentContext context = state.getContext();
        this.notifyObservers(17, state);
        this.setComments(state.getString("comments"));
        this.setCreationDate(state.getString("creationDate"));
        this.setModificationDate(state.getString("modificationDate"));
        this.setName(state.getString("name"));
        this.setOwner(state.getString("owner"));
        this.setSelectionColor((Color)state.get("selectionColor"));
        this.setProjection((IProjection)state.get("projection"));
        this.propertiesHelper = (ExtendedPropertiesHelper)state.get("propertiesHelper");
        List extents = (List)state.get("extents");
        for (int i = 0; i < extents.size(); ++i) {
            this.addExtent((ProjectExtent)extents.get(i));
        }
        List documents = (List)state.get("documents");
        for (int i = 0; i < documents.size(); ++i) {
            AbstractDocument doc = (AbstractDocument)documents.get(i);
            if (doc == null) continue;
            this.add(doc);
        }
        try {
            List persistentWindows = (List)state.get("documentWindowsInformation");
            for (int i = 0; i < persistentWindows.size(); ++i) {
                try {
                    DocumentWindowInfo persistentWindow = (DocumentWindowInfo)persistentWindows.get(i);
                    String docName = persistentWindow.getDocumentName();
                    String docType = persistentWindow.getDocumentType();
                    Document doc = this.getDocument(docName, docType);
                    IWindow win = doc.getFactory().getMainWindow(doc);
                    if (win == null) continue;
                    win.getWindowInfo().setWindowInfo(persistentWindow.getWindowInfo());
                    PluginServices.getMDIManager().addWindow(win);
                    continue;
                }
                catch (Exception ex) {
                    if (!context.getCollectErrors()) {
                        throw ex;
                    }
                    context.addError((Throwable)ex);
                }
            }
            if (state.hasValue("projectWindowInfo")) {
                WindowInfo projectWindowInfo = (WindowInfo)state.get("projectWindowInfo");
                SwingUtilities.invokeLater(() -> {
                    ProjectExtension pe = (ProjectExtension)PluginServices.getExtension(ProjectExtension.class);
                    pe.setProject(this);
                    pe.showProjectWindow(projectWindowInfo);
                });
            }
        }
        catch (Exception ex) {
            if (!context.getCollectErrors()) {
                throw ex;
            }
            context.addError((Throwable)ex);
        }
        this.notifyObservers(18, state);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("version", VERSION);
        state.set("comments", this.getComments());
        state.set("creationDate", this.getCreationDate());
        state.set("modificationDate", this.getModificationDate());
        state.set("name", this.getName());
        state.set("owner", this.getOwner());
        state.set("selectionColor", (Object)this.getSelectionColor());
        state.set("projection", (Object)this.getProjection());
        state.set("extents", this.extents);
        List<Document> docs = this.getDocuments();
        ArrayList<Document> noTempDocs = new ArrayList<Document>();
        for (Document document : docs) {
            if (!(document instanceof ViewDocument) || document.isTemporary()) continue;
            noTempDocs.add(document);
        }
        for (Document document : docs) {
            if (document instanceof ViewDocument || document.isTemporary()) continue;
            noTempDocs.add(document);
        }
        state.set("documents", noTempDocs);
        state.set("propertiesHelper", (Persistent)this.propertiesHelper);
        ArrayList<DocumentWindowInfo> persistentWindows = new ArrayList<DocumentWindowInfo>();
        MDIManager mdiMan = PluginServices.getMDIManager();
        IWindow[] windows = mdiMan.getOrderedWindows();
        for (int i = windows.length - 1; i >= 0; --i) {
            IWindow window = windows[i];
            if (window instanceof IDocumentWindow) {
                WindowInfo wi = mdiMan.getWindowInfo(window);
                DocumentWindowInfo dwi = new DocumentWindowInfo(wi, ((IDocumentWindow)window).getDocument().getTypeName(), ((IDocumentWindow)window).getDocument().getName());
                persistentWindows.add(dwi);
                continue;
            }
            if (!(window instanceof ProjectWindow)) continue;
            state.set("projectWindowInfo", (Persistent)mdiMan.getWindowInfo(window));
        }
        state.set("documentWindowsInformation", persistentWindows);
    }

    @Deprecated
    public Object getProperty(Object key) {
        return this.propertiesHelper.getProperty(key);
    }

    @Deprecated
    public void setProperty(Object key, Object obj) {
        this.propertiesHelper.setProperty(key, obj);
    }

    @Deprecated
    public Map getExtendedProperties() {
        return this.propertiesHelper.getExtendedProperties();
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getExtendedProperties();
    }

    public static void registerPersistent() {
        AbstractDocument.registerPersistent();
        DocumentWindowInfo.registerPersistent();
        ProjectExtent.registerPersistent();
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(DefaultProject.class, "Project", "Project Persistence definition", null, null);
        definition.addDynFieldString("version").setMandatory(true);
        definition.addDynFieldString("comments").setMandatory(true);
        definition.addDynFieldString("creationDate").setMandatory(true);
        definition.addDynFieldString("modificationDate").setMandatory(true);
        definition.addDynFieldString("name").setMandatory(true);
        definition.addDynFieldString("owner").setMandatory(true);
        definition.addDynFieldObject("selectionColor").setClassOfValue(Color.class).setMandatory(true);
        definition.addDynFieldObject("projection").setClassOfValue(IProjection.class).setMandatory(true);
        definition.addDynFieldList("extents").setClassOfItems(ProjectExtent.class).setMandatory(true);
        definition.addDynFieldList("documents").setClassOfItems(Document.class).setMandatory(true);
        definition.addDynFieldObject("projectWindowInfo").setClassOfValue(WindowInfo.class).setMandatory(false);
        definition.addDynFieldList("documentWindowsInformation").setClassOfItems(WindowInfo.class).setMandatory(false);
        definition.addDynFieldObject("propertiesHelper").setClassOfValue(ExtendedPropertiesHelper.class).setMandatory(false);
    }

    public static void setDefaultSelectionColor(Color color) {
        DefaultProject.getPreferences().setDefaultSelectionColor(color);
    }

    public static Color getDefaultSelectionColor() {
        return DefaultProject.getPreferences().getDefaultSelectionColor();
    }

    public static int getDefaultMapUnits() {
        return DefaultProject.getPreferences().getDefaultMapUnits();
    }

    public static int getDefaultDistanceUnits() {
        return DefaultProject.getPreferences().getDefaultDistanceUnits();
    }

    public static int getDefaultDistanceArea() {
        return DefaultProject.getPreferences().getDefaultDistanceArea();
    }

    public static void setDefaultMapUnits(int mapUnits) {
        DefaultProject.getPreferences().setDefaultMapUnits(mapUnits);
    }

    public static void setDefaultDistanceUnits(int distanceUnits) {
        DefaultProject.getPreferences().setDefaultDistanceUnits(distanceUnits);
    }

    public static void setDefaultDistanceArea(int distanceArea) {
        DefaultProject.getPreferences().setDefaultDistanceArea(distanceArea);
    }

    public static void setDefaultProjection(IProjection defaultProjection) {
        DefaultProject.getPreferences().setDefaultProjection(defaultProjection);
    }

    public static IProjection getDefaultProjection() {
        return DefaultProject.getPreferences().getDefaultProjection();
    }

    public void setColor(String color) {
        this.setSelectionColor(StringUtilities.string2Color((String)color));
    }

    public String getColor() {
        return StringUtilities.color2String((Color)this.selectionColor);
    }

    public List<Document> getViews() {
        return this.getDocuments(ViewManager.TYPENAME);
    }

    public void addView(DefaultViewDocument v) {
        this.add(v);
    }

    public void delView(int i) {
        List<Document> list = this.getDocuments(ViewManager.TYPENAME);
        this.remove(list.get(i));
    }

    public Document getProjectDocumentByName(String name, String type) {
        return this.getDocument(name, type);
    }

    public List<Document> getDocumentsByType(String type) {
        return this.getDocuments(type);
    }

    public String exportToXML(AbstractDocument[] selectedItems) throws SaveException {
        throw new UnsupportedOperationException("This method is not supported");
    }

    public void importFromXML(String sourceString, String docType) {
        throw new UnsupportedOperationException("This method is not supported");
    }

    public boolean isValidXMLForImport(String sourceString, String docType) {
        throw new UnsupportedOperationException("This method is not supported");
    }

    @Override
    public boolean canImportDocuments(String data, String doctype) {
        return false;
    }

    @Override
    public String exportDocumentsAsText(List<Document> documents) {
        return null;
    }

    @Override
    public void importDocuments(String data, String doctype) {
    }

    @Override
    public Document getActiveDocument() {
        return this.getActiveDocument((Class<? extends Document>)null);
    }

    @Override
    public Document getActiveDocument(String documentTypeName) {
        ApplicationManager application = ApplicationLocator.getManager();
        for (DocumentManager documentManager : application.getProjectManager().getDocumentManagers()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)documentTypeName, (CharSequence)documentManager.getTypeName())) continue;
            return this.getActiveDocument(documentManager.getClassOfDocument());
        }
        return null;
    }

    @Override
    public List<Document> getOpenDocuments(Class<? extends Document> documentClass) {
        return this.getOpenDocuments((Document doc) -> doc != null && (documentClass == null || documentClass.isAssignableFrom(doc.getClass())));
    }

    @Override
    public List<Document> getOpenDocuments(String type) {
        return this.getOpenDocuments((Document doc) -> doc != null && StringUtils.equals((CharSequence)type, (CharSequence)doc.getTypeName()));
    }

    @Override
    public List<Document> getOpenDocuments(Predicate<Document> filter) {
        IWindow[] windows;
        ApplicationManager application = ApplicationLocator.getManager();
        ArrayList<Document> docs = new ArrayList<Document>();
        for (IWindow window : windows = application.getUIManager().getOrderedWindows()) {
            if (!(window instanceof SingletonWindow) || !(window instanceof IDocumentWindow)) continue;
            try {
                Document doc = (Document)((SingletonWindow)window).getWindowModel();
                if (filter == null) {
                    docs.add(doc);
                    continue;
                }
                if (!filter.test(doc)) continue;
                docs.add(doc);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return docs;
    }

    @Override
    public Document getActiveDocument(Class<? extends Document> documentClass) {
        ApplicationManager application = ApplicationLocator.getManager();
        Document document = null;
        IWindow[] windows = application.getUIManager().getOrderedWindows();
        IWindow window = null;
        for (int i = 0; i < windows.length; ++i) {
            window = windows[i];
            if (!(window instanceof SingletonWindow) || !(window instanceof IDocumentWindow)) continue;
            try {
                document = (Document)((SingletonWindow)window).getWindowModel();
                if (documentClass == null) {
                    return document;
                }
                if (documentClass.isAssignableFrom(document.getClass())) {
                    return document;
                }
                if (document instanceof DocumentsContainer) {
                    Document subdoc = ((DocumentsContainer)((Object)document)).getActiveDocument(documentClass);
                    return subdoc;
                }
                return null;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Document getFirstDocument(Class<? extends Document> documentClass) {
        ApplicationManager application = ApplicationLocator.getManager();
        Document document = null;
        IWindow[] windows = application.getUIManager().getOrderedWindows();
        IWindow window = null;
        for (int i = 0; i < windows.length; ++i) {
            window = windows[i];
            if (!(window instanceof SingletonWindow) || !(window instanceof IDocumentWindow)) continue;
            try {
                document = (Document)((SingletonWindow)window).getWindowModel();
                if (documentClass == null) {
                    return document;
                }
                if (documentClass.isAssignableFrom(document.getClass())) {
                    return document;
                }
                if (!(document instanceof DocumentsContainer)) continue;
                Document subdoc = ((DocumentsContainer)((Object)document)).getActiveDocument(documentClass);
                return subdoc;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public IWindow getActiveWindow(Class<? extends Document> documentClass) {
        IWindow[] windows;
        ApplicationManager application = ApplicationLocator.getManager();
        for (IWindow window : windows = application.getUIManager().getOrderedWindows()) {
            if (!(window instanceof SingletonWindow) || !(window instanceof IDocumentWindow)) continue;
            try {
                if (documentClass == null) {
                    return window;
                }
                Document document = (Document)((SingletonWindow)window).getWindowModel();
                if (!documentClass.isAssignableFrom(document.getClass())) continue;
                return window;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public void addObserver(Observer o) {
        this.observableHelper.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observableHelper.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observableHelper.deleteObservers();
    }

    private ProjectNotification notifyObservers(int type) {
        return this.notifyObservers(new DefaultProjectNotification(type));
    }

    private ProjectNotification notifyObservers(int type, Document document) {
        return this.notifyObservers(new DefaultProjectNotification(type, document));
    }

    private ProjectNotification notifyObservers(int type, PersistentState state) {
        return this.notifyObservers(new DefaultProjectNotification(type, state));
    }

    private ProjectNotification notifyObservers(int type, File file) {
        return this.notifyObservers(new DefaultProjectNotification(type, file));
    }

    private ProjectNotification notifyObservers(ProjectNotification notifycation) {
        try {
            this.observableHelper.notifyObservers((Observable)this, (Object)notifycation);
        }
        catch (Exception ex) {
            this.LOG.info("Can't notify observers", (Throwable)ex);
        }
        this.notifyProjectManagerEvent(notifycation.getNotificationType());
        return notifycation;
    }

    private void notifyProjectManagerEvent(int type) {
        try {
            ProjectManager.getInstance().notifyProjectEvent(new ProjectManager.ProjectEventImpl(this, type));
        }
        catch (Exception ex) {
            this.LOG.info("Can't notify project manager events", (Throwable)ex);
        }
    }

    class DefaultProjectNotification
    implements ProjectNotification {
        private int type;
        private Document document;
        private File file;
        private boolean processCanceled = false;
        private PersistentState state = null;

        DefaultProjectNotification(int type) {
            this.type = type;
        }

        DefaultProjectNotification(int type, Document document) {
            this(type);
            this.document = document;
        }

        DefaultProjectNotification(int type, File file) {
            this(type);
            this.file = file;
        }

        DefaultProjectNotification(int type, PersistentState state) {
            this(type);
            this.state = state;
        }

        @Override
        public int getNotificationType() {
            return this.type;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public void cancelProcess() {
            this.processCanceled = true;
        }

        @Override
        public boolean isProcessCanceled() {
            return this.processCanceled;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public PersistentState getState() {
            return this.state;
        }

        @Override
        public Project getProject() {
            return DefaultProject.this;
        }
    }

    public static class DocumentWindowInfo
    implements Persistent {
        public static final String PERSISTENCE_DEFINITION_NAME = "DocumentWindowInfo";
        private WindowInfo windowInfo;
        private String documentType;
        private String documentName;

        public DocumentWindowInfo() {
        }

        DocumentWindowInfo(WindowInfo wi, String docType, String docName) {
            this.windowInfo = wi;
            this.documentType = docType;
            this.documentName = docName;
        }

        public WindowInfo getWindowInfo() {
            return this.windowInfo;
        }

        public String getDocumentType() {
            return this.documentType;
        }

        public String getDocumentName() {
            return this.documentName;
        }

        public void saveToState(PersistentState state) throws PersistenceException {
            state.set("windowInfo", (Persistent)this.windowInfo);
            state.set("documentType", this.documentType);
            state.set("documentName", this.documentName);
        }

        public void loadFromState(PersistentState state) throws PersistenceException {
            this.windowInfo = (WindowInfo)state.get("windowInfo");
            this.documentType = state.getString("documentType");
            this.documentName = state.getString("documentName");
        }

        public static void registerPersistent() {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.getDefinition(PERSISTENCE_DEFINITION_NAME);
            if (definition == null) {
                definition = manager.addDefinition(DocumentWindowInfo.class, PERSISTENCE_DEFINITION_NAME, "DocumentWindowInfo persistence definition", null, null);
                definition.addDynFieldObject("windowInfo").setMandatory(true).setClassOfValue(WindowInfo.class);
                definition.addDynFieldString("documentType").setMandatory(true);
                definition.addDynFieldString("documentName").setMandatory(true);
            }
        }
    }
}

