/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.DefaultProject;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectExtent;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.DefaultDocumentActionGroup;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentAction;
import org.gvsig.app.project.documents.DocumentActionGroup;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.gui.ProjectWindow;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.extensionpoint.ExtensionSingleton;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.util.BaseListenerSupport;
import org.gvsig.tools.util.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectManager
extends BaseWeakReferencingObservable {
    private static final Logger logger = LoggerFactory.getLogger(ProjectManager.class);
    private static ProjectManager factory = null;
    private static final String KEY_DOCUMENTS_FACTORIES = "app.project.documents.factories";
    private static final String KEY_DOCUMENTS_ACTIONS = "app.project.documents.actions";
    private Map<String, DocumentActionGroup> documentActionGroups = new HashMap<String, DocumentActionGroup>();
    private final BaseListenerSupport newProjectListeners = new BaseListenerSupport();

    public static ProjectManager getInstance() {
        if (factory == null) {
            factory = new ProjectManager();
        }
        return factory;
    }

    private ProjectManager() {
    }

    public Project getCurrentProject() {
        ProjectExtension ext = (ProjectExtension)PluginServices.getExtension(ProjectExtension.class);
        if (ext == null) {
            return null;
        }
        return ext.getProject();
    }

    public void setCurrentProject(Project project) {
        ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).setProject(project);
    }

    public ProjectWindow getCurrentProjectWindow() {
        ProjectExtension projectExtension = (ProjectExtension)PluginServices.getExtension(ProjectExtension.class);
        ProjectWindow window = (ProjectWindow)projectExtension.getProjectWindow();
        return window;
    }

    public List<DocumentManager> getDocumentManager() {
        return this.getDocumentManagers();
    }

    public List<DocumentManager> getDocumentManagers() {
        Iterator iterator = ToolsLocator.getExtensionPointManager().get(KEY_DOCUMENTS_FACTORIES).iterator();
        ArrayList<DocumentManager> factories = new ArrayList<DocumentManager>();
        while (iterator.hasNext()) {
            ExtensionPoint.Extension extension = (ExtensionPoint.Extension)iterator.next();
            try {
                factories.add((DocumentManager)extension.create());
            }
            catch (InstantiationException e) {
                logger.error("Can't access to project document factory (" + extension.getName() + ").");
            }
            catch (IllegalAccessException e) {
                logger.error("Can't access to project document factory (" + extension.getName() + ").");
            }
        }
        return factories;
    }

    public DocumentManager getDocumentManagers(String type) {
        return this.getDocumentManager(type);
    }

    public DocumentManager getDocumentManager(String type) {
        DocumentManager factory = null;
        try {
            factory = (DocumentManager)ToolsLocator.getExtensionPointManager().get(KEY_DOCUMENTS_FACTORIES).create(type);
        }
        catch (Exception ex) {
            logger.warn(MessageFormat.format("Unable to locate factory for documents of type {0}", type), (Throwable)ex);
        }
        return factory;
    }

    public Document createDocument(String type) {
        AbstractDocument doc = this.getDocumentManager(type).createDocument();
        return doc;
    }

    public Document createDocument(String type, String name) {
        Document doc = this.createDocument(type);
        doc.setName(name);
        return doc;
    }

    public Document createDocumentByUser(String type) {
        AbstractDocument doc = this.getDocumentManager(type).createDocumentByUser();
        return doc;
    }

    public Iterator<? extends Document> createDocumentsByUser(String type) {
        logger.info("createDocumentsByUser('{}')", (Object)type);
        return this.getDocumentManager(type).createDocumentsByUser();
    }

    public Iterator<? extends Document> createDocumentsByUser(String type, Invocable whenDocumentsLoadeds) {
        logger.info("createDocumentsByUser('{}')", (Object)type);
        return this.getDocumentManager(type).createDocumentsByUser(whenDocumentsLoadeds);
    }

    public Project createProject() {
        return new DefaultProject();
    }

    public ProjectExtent createExtent() {
        return new ProjectExtent();
    }

    public void registerDocumentFactory(DocumentManager documentManager) {
        ExtensionPointManager manager = ToolsLocator.getExtensionPointManager();
        manager.add(KEY_DOCUMENTS_FACTORIES).append(documentManager.getTypeName(), null, (ExtensionBuilder)documentManager);
        this.notifyObservers();
    }

    public void registerDocumentFactoryAlias(String typeName, String alias) {
        ExtensionPointManager manager = ToolsLocator.getExtensionPointManager();
        manager.get(KEY_DOCUMENTS_FACTORIES).addAlias(typeName, alias);
    }

    public void registerDocumentAction(String typeName, DocumentAction action) {
        ExtensionPointManager manager = ToolsLocator.getExtensionPointManager();
        String key = "app.project.documents.actions." + typeName;
        String description = MessageFormat.format("Actions for {1} documents ", typeName);
        manager.add(key, description).append(action.getId(), action.getDescription(), (ExtensionSingleton)action);
    }

    public List<DocumentAction> getDocumentActions(String doctype) {
        String key;
        ExtensionPointManager manager = ToolsLocator.getExtensionPointManager();
        ExtensionPoint extensionPoint = manager.get(key = "app.project.documents.actions." + doctype);
        if (extensionPoint == null) {
            return null;
        }
        ArrayList<DocumentAction> actions = new ArrayList<DocumentAction>();
        Iterator it = extensionPoint.iterator();
        while (it.hasNext()) {
            try {
                DocumentAction action = (DocumentAction)((ExtensionPoint.Extension)it.next()).create();
                actions.add(action);
            }
            catch (InstantiationException e) {
                logger.warn("Can't retrieve document action", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn("Can't retrieve document action", (Throwable)e);
            }
        }
        if (actions.size() < 1) {
            return null;
        }
        Collections.sort(actions, new CompareAction());
        return actions;
    }

    public DocumentActionGroup addDocumentActionGroup(String id, String title, String description, int order) {
        DocumentActionGroup group = this.documentActionGroups.get(id);
        if (group != null) {
            return group;
        }
        group = new DefaultDocumentActionGroup(id, title, description, order);
        this.documentActionGroups.put(id, group);
        return group;
    }

    public ProjectPreferences getProjectPreferences() {
        return DefaultProject.getPreferences();
    }

    public void addProjectListener(BaseListenerSupport.NotificationListener listener) {
        this.newProjectListeners.addListener((EventListener)listener);
    }

    public BaseListenerSupport.NotificationListener[] getProjectListeners() {
        return (BaseListenerSupport.NotificationListener[])this.newProjectListeners.getListeners();
    }

    public boolean hasProjectListeners() {
        return this.newProjectListeners.hasListeners();
    }

    public void removeProjectListener(BaseListenerSupport.NotificationListener listener) {
        this.newProjectListeners.removeListener((EventListener)listener);
    }

    public void removeAllProjectListener() {
        this.newProjectListeners.removeAllListener();
    }

    public void notifyProjectEvent(ProjectEvent event) {
        this.newProjectListeners.notifyEvent((EventListener)event);
    }

    private class CompareAction
    implements Comparator<DocumentAction> {
        private CompareAction() {
        }

        @Override
        public int compare(DocumentAction action1, DocumentAction action2) {
            String key1 = MessageFormat.format("{1}.{2}.{3}", action1.getGroup().getOrder(), action1.getGroup().getTitle(), action1.getOrder());
            String key2 = MessageFormat.format("{1}.{2}.{3}", action2.getGroup().getOrder(), action2.getGroup().getTitle(), action2.getOrder());
            return key1.compareTo(key2);
        }
    }

    public static class ProjectEventImpl
    implements ProjectEvent {
        private final Project project;
        private final int id;

        public ProjectEventImpl(Project project, int id) {
            this.project = project;
            this.id = id;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public Project getProject() {
            return this.project;
        }
    }

    public static interface ProjectEvent
    extends EventListener {
        public int getId();

        public Project getProject();
    }
}

