/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.propertypage.PropertiesPage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class ProjectGeneralPropertiesPage
extends JPanel
implements PropertiesPage {
    private Project project = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JTextField txtName = null;
    private JTextField txtPath = null;
    private JTextField txtCreationDate = null;
    private JTextField txtModificationDate = null;
    private JTextField txtOwner = null;
    private JLabel jLabel5 = null;
    private JTextArea txtComments = null;
    private JLabel jLabel6 = null;
    private JLabel lblColor = null;
    private JButton btnColor = null;
    private JScrollPane jScrollPane = null;

    public ProjectGeneralPropertiesPage(Project project) {
        this.project = project;
        this.initComponents();
    }

    public void setData(Object data) {
    }

    public boolean whenAccept() {
        return this.whenApply();
    }

    public boolean whenApply() {
        this.project.setName(this.txtName.getText());
        this.project.setOwner(this.txtOwner.getText());
        this.project.setComments(this.txtComments.getText());
        this.project.setSelectionColor(this.lblColor.getBackground());
        return true;
    }

    public boolean whenCancel() {
        return true;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("General");
    }

    public int getPriority() {
        return 1000;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(this.getJPanel());
        this.getTxtName().setText(this.project.getName());
        String path = ProjectExtension.getPath();
        if (path != null) {
            File f = new File(path);
            this.getTxtPath().setText(f.toString());
        } else {
            this.getTxtPath().setText("");
        }
        this.getTxtOwner().setText(this.project.getOwner());
        this.getTxtComments().setText(this.project.getComments());
        this.getTxtCreationDate().setText(this.project.getCreationDate());
        this.getTxtModificationDate().setText(this.project.getModificationDate());
        this.getLblColor().setBackground(this.project.getSelectionColor());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 5, 0, 5);
            c.gridy = -1;
            this.addRow(c, this.getJLabel(), this.getTxtName());
            this.addRow(c, this.getJLabel1(), this.getTxtPath());
            this.addRow(c, this.getJLabel2(), this.getTxtCreationDate());
            this.addRow(c, this.getJLabel3(), this.getTxtModificationDate());
            this.addRow(c, this.getJLabel4(), this.getTxtOwner());
            c.anchor = 17;
            c.weightx = 0.0;
            c.gridx = 0;
            ++c.gridy;
            this.jPanel.add((Component)this.getJLabel6(), c);
            JPanel colorPanel = new JPanel(new FlowLayout(0));
            colorPanel.add(this.getLblColor());
            colorPanel.add(this.getBtnColor());
            c.fill = 2;
            c.weightx = 1.0;
            c.gridx = 1;
            this.jPanel.add((Component)colorPanel, c);
            c.anchor = 17;
            c.weightx = 0.0;
            c.gridx = 0;
            ++c.gridy;
            this.jPanel.add((Component)this.getJLabel5(), c);
            c.fill = 1;
            c.weightx = 1.0;
            ++c.gridy;
            c.gridwidth = 2;
            this.jPanel.add((Component)this.getJScrollPane(), c);
            c.anchor = 13;
            c.gridx = 0;
            c.gridwidth = 2;
            ++c.gridy;
            c.weightx = 1.0;
        }
        return this.jPanel;
    }

    private void addRow(GridBagConstraints c, JComponent label, JComponent text) {
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.jPanel.add((Component)label, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        this.jPanel.add((Component)text, c);
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(PluginServices.getText((Object)this, (String)"nombre_sesion") + ":");
        }
        return this.jLabel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(PluginServices.getText((Object)this, (String)"path") + ":");
        }
        return this.jLabel1;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(PluginServices.getText((Object)this, (String)"creation_date") + ":");
        }
        return this.jLabel2;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText(PluginServices.getText((Object)this, (String)"modification_date") + ":");
        }
        return this.jLabel3;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText(PluginServices.getText((Object)this, (String)"owner") + ":");
        }
        return this.jLabel4;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField(20);
        }
        return this.txtName;
    }

    private JTextField getTxtPath() {
        if (this.txtPath == null) {
            this.txtPath = new JTextField(20);
            this.txtPath.setEditable(false);
            this.txtPath.setBackground(Color.white);
        }
        return this.txtPath;
    }

    private JTextField getTxtCreationDate() {
        if (this.txtCreationDate == null) {
            this.txtCreationDate = new JTextField(20);
            this.txtCreationDate.setEditable(false);
            this.txtCreationDate.setBackground(Color.white);
        }
        return this.txtCreationDate;
    }

    private JTextField getTxtModificationDate() {
        if (this.txtModificationDate == null) {
            this.txtModificationDate = new JTextField(20);
            this.txtModificationDate.setEditable(false);
            this.txtModificationDate.setBackground(Color.white);
        }
        return this.txtModificationDate;
    }

    private JTextField getTxtOwner() {
        if (this.txtOwner == null) {
            this.txtOwner = new JTextField(20);
        }
        return this.txtOwner;
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setText(PluginServices.getText((Object)this, (String)"comentarios") + ":");
        }
        return this.jLabel5;
    }

    private JTextArea getTxtComments() {
        if (this.txtComments == null) {
            this.txtComments = new JTextArea();
            this.txtComments.setRows(4);
            this.txtComments.setColumns(20);
        }
        return this.txtComments;
    }

    private JLabel getJLabel6() {
        if (this.jLabel6 == null) {
            this.jLabel6 = new JLabel();
            this.jLabel6.setText(PluginServices.getText((Object)this, (String)"selection_color") + ":");
        }
        return this.jLabel6;
    }

    private JLabel getLblColor() {
        if (this.lblColor == null) {
            this.lblColor = new JLabel();
            this.lblColor.setPreferredSize(this.getBtnColor().getPreferredSize());
            this.lblColor.setOpaque(true);
        }
        return this.lblColor;
    }

    private JButton getBtnColor() {
        if (this.btnColor == null) {
            this.btnColor = new JButton("...");
            this.btnColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color ret = JColorChooser.showDialog(ProjectGeneralPropertiesPage.this, PluginServices.getText((Object)this, (String)"selection_color"), ProjectGeneralPropertiesPage.this.lblColor.getBackground());
                    if (ret != null) {
                        ProjectGeneralPropertiesPage.this.lblColor.setBackground(ret);
                    }
                }
            });
        }
        return this.btnColor;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(this.getTxtComments());
            Dimension dim = this.getTxtComments().getPreferredSize();
            this.jScrollPane.setMinimumSize(new Dimension(dim.width, dim.height + 10));
        }
        return this.jScrollPane;
    }
}

