/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.help.Help;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.gui.DocumentContextMenu;
import org.gvsig.app.project.documents.gui.ProjectProperties;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.usability.UsabilitySwingManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.PropertiesSupport;
import org.gvsig.tools.util.PropertiesSupportHelper;
import org.gvsig.utils.DefaultListModel;

public class ProjectWindow2_OLD
extends JPanel
implements PropertyChangeListener,
IWindow,
SingletonWindow,
Observer,
PropertiesSupport {
    private static final long serialVersionUID = 7315293357719796556L;
    public static final String PERSISTENCE_DEFINITION_NAME = "ProjectWindow";
    private JScrollPane documentTypes = null;
    private JPanel documentTypesList = null;
    private JRadioButton[] btnsDocuments = null;
    private ButtonGroup grupo = new ButtonGroup();
    private JPanel documentsPanel = null;
    private JList lstDocs = null;
    private JPanel jPanel2 = null;
    private JButton btnNuevo = null;
    private JButton btnPropiedades = null;
    private JButton btnAbrir = null;
    private JButton btnBorrar = null;
    private JButton btnRenombrar = null;
    private JPanel propertiesPanel = null;
    private JLabel jLabel = null;
    private JLabel lblNombreSesion = null;
    private JLabel jLabel1 = null;
    private JLabel lblGuardado = null;
    private JLabel jLabel2 = null;
    private JLabel lblFecha = null;
    private JButton btnImportar = null;
    private JButton btnExportar = null;
    private JButton btnEditar = null;
    private WindowInfo m_viewInfo = null;
    private Project project;
    private UsabilitySwingManager manager = ToolsSwingLocator.getUsabilitySwingManager();
    private JScrollPane documentsScrollPane = null;
    private JPanel projectButtonsPanel = null;
    private PropertiesSupportHelper propertiesHelper = new PropertiesSupportHelper();

    public ProjectWindow2_OLD() {
        this.propertiesHelper.setProperty(PERSISTENCE_DEFINITION_NAME, (Object)this);
        this.initialize();
        this.refreshControls();
        Help.getHelp().enableHelp((JComponent)this, this.getClass().getName());
        ProjectManager.getInstance().addObserver(this);
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addPropertyChangeListener(this);
        }
        this.refreshControls();
    }

    private void activarBotones() {
        if (this.lstDocs.getSelectedIndex() != -1) {
            this.btnAbrir.setEnabled(true);
            this.btnBorrar.setEnabled(true);
            if (this.lstDocs.getSelectedIndices().length == 1) {
                this.btnRenombrar.setEnabled(true);
                this.btnPropiedades.setEnabled(true);
            } else {
                this.btnRenombrar.setEnabled(false);
                this.btnPropiedades.setEnabled(false);
            }
        } else {
            this.btnAbrir.setEnabled(false);
            this.btnBorrar.setEnabled(false);
            this.btnRenombrar.setEnabled(false);
            this.btnPropiedades.setEnabled(false);
        }
    }

    private void refreshList() {
        if (this.project != null) {
            DefaultListModel model = null;
            String tituloMarco = PluginServices.getText((Object)this, (String)"documentos_existentes");
            String doctype = this.getDocumentSelected();
            model = new DefaultListModel(this.project.getDocuments(doctype));
            tituloMarco = this.getDocumentSelectedName();
            Object selectedDoc = this.lstDocs.getSelectedValue();
            this.lstDocs.setModel(model);
            if (selectedDoc != null) {
                this.lstDocs.setSelectedValue(selectedDoc, false);
            }
            ((TitledBorder)this.getDocumentsPanel().getBorder()).setTitle(tituloMarco);
            this.getDocumentsPanel().repaint(1L);
            this.activarBotones();
        }
    }

    public String getDocumentSelected() {
        JRadioButton btnSelected = null;
        for (int i = 0; i < this.btnsDocuments.length; ++i) {
            if (!this.btnsDocuments[i].isSelected()) continue;
            btnSelected = this.btnsDocuments[i];
            return btnSelected.getName();
        }
        return null;
    }

    private String getDocumentSelectedName() {
        JRadioButton btnSelected = null;
        for (int i = 0; i < this.btnsDocuments.length; ++i) {
            if (!this.btnsDocuments[i].isSelected()) continue;
            btnSelected = this.btnsDocuments[i];
            return btnSelected.getText();
        }
        return null;
    }

    private void refreshProperties() {
        if (this.project != null) {
            this.lblNombreSesion.setText(this.project.getName());
            String path = ProjectExtension.getPath();
            if (path != null) {
                File f = new File(path);
                this.lblGuardado.setText(f.toString());
            } else {
                this.lblGuardado.setText("");
            }
            this.lblFecha.setText(this.project.getCreationDate());
        }
    }

    public void refreshControls() {
        this.refreshList();
        this.refreshProperties();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 0;
        this.add((Component)this.getDocumentTypesPanel(), c);
        c.fill = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.getDocumentsPanel(), c);
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 2;
        this.add((Component)this.getPropertiesPanel(), c);
        this.setMinimumSize(this.getPreferredSize());
        this.refreshDocuments();
    }

    private void createDocumentsInProject(String doctype) {
        Iterator<? extends Document> documents = ProjectManager.getInstance().createDocumentsByUser(doctype);
        while (documents != null && documents.hasNext()) {
            try {
                Document document = documents.next();
                this.project.add(document);
                int index = ((DefaultListModel)this.lstDocs.getModel()).indexOf((Object)document);
                this.lstDocs.setSelectedIndex(index);
                this.lstDocs.requestFocus();
                this.openDocumentWindow(document);
            }
            catch (Exception e) {
                NotificationManager.addError((Throwable)e);
            }
        }
    }

    private void newProjectDocument() throws Exception {
        String doctype = this.getDocumentSelected();
        this.createDocumentsInProject(doctype);
        this.lstDocs.setSelectedIndex(this.lstDocs.getModel().getSize() - 1);
    }

    private void abrir() {
        int[] indexes = this.lstDocs.getSelectedIndices();
        for (int i = indexes.length - 1; i >= 0; --i) {
            int index = indexes[i];
            if (index == -1) {
                return;
            }
            String doctype = this.getDocumentSelected();
            List<Document> documents = this.project.getDocuments(doctype);
            Document doc = documents.get(index);
            if (!doc.isAvailable()) {
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                JOptionPane.showMessageDialog(this, i18nManager.getTranslation("document_not_available"), i18nManager.getTranslation("abrir"), 2);
                return;
            }
            this.openDocumentWindow(doc);
        }
    }

    private void openDocumentWindow(Document doc) {
        if (doc != null) {
            IWindow window = doc.getFactory().getMainWindow(doc);
            if (window == null) {
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"error_opening_the_document"));
                return;
            }
            PluginServices.getMDIManager().addWindow(window, 1816);
            this.project.setModified(true);
        }
    }

    private void renombrar() {
        int index = this.lstDocs.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String doctype = this.getDocumentSelected();
        List<Document> documents = this.project.getDocuments(doctype);
        Document doc = documents.get(index);
        JOptionPane pane = new JOptionPane();
        pane.setMessage(PluginServices.getText((Object)this, (String)"introduce_nombre"));
        pane.setMessageType(3);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(doc.getName());
        pane.setInputValue(doc.getName());
        JDialog dlg = pane.createDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"renombrar"));
        dlg.setModal(true);
        dlg.setVisible(true);
        String nuevoNombre = pane.getInputValue().toString().trim();
        if (nuevoNombre.length() == 0) {
            return;
        }
        for (int i = 0; i < this.lstDocs.getModel().getSize(); ++i) {
            if (i == index || !((AbstractDocument)this.lstDocs.getModel().getElementAt(i)).getName().equals(nuevoNombre)) continue;
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"elemento_ya_existe"));
            return;
        }
        doc.setName(nuevoNombre);
        this.refreshList();
        this.project.setModified(true);
    }

    private void borrar() {
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        int res = application.confirmDialog(i18n.getTranslation("confirmar_borrar"), i18n.getTranslation("borrar"), 0, 1, "Confirm remove document from project");
        int lastremoved = 0;
        if (res == 0) {
            int[] indexes = this.lstDocs.getSelectedIndices();
            for (int i = indexes.length - 1; i >= 0; --i) {
                int index = indexes[i];
                String s = this.getDocumentSelected();
                List<Document> documents = this.project.getDocuments(s);
                Document doc = documents.get(index);
                if (doc.isLocked()) {
                    application.messageDialog(i18n.getTranslation("locked_element_it_cannot_be_deleted"), i18n.getTranslation("Information"), 1);
                    return;
                }
                PluginServices.getMDIManager().closeSingletonWindow((Object)doc);
                this.project.removeDocument(doc);
                lastremoved = index;
            }
            if (lastremoved >= this.lstDocs.getModel().getSize()) {
                this.lstDocs.setSelectedIndex(this.lstDocs.getModel().getSize() - 1);
            } else if (lastremoved >= 0) {
                this.lstDocs.setSelectedIndex(lastremoved);
            }
            this.project.setModified(true);
        }
    }

    private void propiedades() {
        int index = this.lstDocs.getSelectedIndex();
        if (index == -1) {
            return;
        }
        IWindow dlg = null;
        String doctype = this.getDocumentSelected();
        List<Document> documents = this.project.getDocuments(doctype);
        Document doc = documents.get(index);
        if (!doc.isAvailable()) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            JOptionPane.showMessageDialog(this, i18nManager.getTranslation("document_not_available"), i18nManager.getTranslation("properties"), 2);
            return;
        }
        dlg = doc.getFactory().getPropertiesWindow(doc);
        PluginServices.getMDIManager().addWindow(dlg);
        this.refreshControls();
        this.lstDocs.setSelectedIndex(index);
        this.project.setModified(true);
    }

    private JComponent getDocumentTypesPanel() {
        if (this.documentTypes == null) {
            this.documentTypesList = new JPanel(new FlowLayout(1, 5, 5));
            this.documentTypesList.setName("tipoDocPanel");
            this.fillDocumentTypeButtons();
            this.documentTypes = new JScrollPane(this.documentTypesList);
            Dimension dim = this.documentTypesList.getPreferredSize();
            this.documentTypes.setMinimumSize(new Dimension(dim.width, dim.height + 35));
            this.documentTypes.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"tipos_de_documentos"), 0, 0, null, null));
            this.documentTypes.setVerticalScrollBarPolicy(21);
            this.documentTypes.setHorizontalScrollBarPolicy(30);
        }
        return this.documentTypes;
    }

    private void fillDocumentTypeButtons() {
        JRadioButton[] btns = this.getBtnDocumentTypes();
        for (int i = 0; i < btns.length; ++i) {
            this.documentTypesList.add(btns[i]);
        }
    }

    private JRadioButton[] getBtnDocumentTypes() {
        if (this.btnsDocuments == null) {
            ArrayList<JRadioButton> btns = new ArrayList<JRadioButton>();
            List<DocumentManager> factories = ProjectManager.getInstance().getDocumentManagers();
            Collections.sort(factories, new Comparator<DocumentManager>(){

                @Override
                public int compare(DocumentManager arg0, DocumentManager arg1) {
                    return arg0.getPriority() - arg1.getPriority();
                }
            });
            SimpleIdentityManager identityManager = ToolsLocator.getIdentityManager();
            for (DocumentManager documentFactory : factories) {
                if (!identityManager.getCurrentIdentity().isAuthorized("project-document-access", (Object)documentFactory, documentFactory.getTypeName())) continue;
                JRadioButton rb = new JRadioButton();
                rb.setIcon(documentFactory.getIcon());
                rb.setSelectedIcon(documentFactory.getIconSelected());
                rb.setHorizontalTextPosition(0);
                rb.setText(documentFactory.getTitle());
                rb.setVerticalTextPosition(3);
                rb.setName(documentFactory.getTypeName());
                rb.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        ProjectWindow2_OLD.this.refreshList();
                    }
                });
                btns.add(rb);
            }
            this.btnsDocuments = btns.toArray(new JRadioButton[0]);
        }
        return this.btnsDocuments;
    }

    private JPanel getDocumentsPanel() {
        if (this.documentsPanel == null) {
            this.documentsPanel = new JPanel();
            GridBagLayout layout2 = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.documentsPanel.setLayout(layout2);
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 17;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.documentsPanel.add((Component)this.getDocumentsScrollPane(), c);
            c.anchor = 13;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            this.documentsPanel.add((Component)this.getDocumentButtonsPanel(), c);
            this.documentsPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"documentos_existentes"), 0, 0, null, null));
        }
        return this.documentsPanel;
    }

    private JList getDocumentsList() {
        if (this.lstDocs == null) {
            this.lstDocs = new JList();
            this.lstDocs.addMouseListener(new MouseAdapter(){

                public AbstractDocument[] getSelecteds() {
                    if (ProjectWindow2_OLD.this.lstDocs.getSelectedIndex() < 0) {
                        return new AbstractDocument[0];
                    }
                    Object[] seleteds = ProjectWindow2_OLD.this.lstDocs.getSelectedValues();
                    AbstractDocument[] returnValue = new AbstractDocument[seleteds.length];
                    System.arraycopy(seleteds, 0, returnValue, 0, seleteds.length);
                    return returnValue;
                }

                public AbstractDocument getItem(MouseEvent e) {
                    if (ProjectWindow2_OLD.this.lstDocs.getSelectedIndex() < 0) {
                        return null;
                    }
                    return null;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        String docType = ProjectWindow2_OLD.this.getDocumentSelected();
                        Document[] selecteds = this.getSelecteds();
                        if (selecteds == null) {
                            return;
                        }
                        DocumentContextMenu menu = new DocumentContextMenu(docType, this.getItem(e), selecteds);
                        if (!menu.hasActions()) {
                            return;
                        }
                        ProjectWindow2_OLD.this.lstDocs.add(menu);
                        menu.show(e.getComponent(), e.getX(), e.getY());
                        return;
                    }
                    if (e.getClickCount() == 2) {
                        ProjectWindow2_OLD.this.abrir();
                    }
                }
            });
            this.lstDocs.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ProjectWindow2_OLD.this.activarBotones();
                }
            });
        }
        return this.lstDocs;
    }

    private JPanel getDocumentButtonsPanel() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            GridLayout layout = new GridLayout(5, 1);
            layout.setVgap(7);
            this.jPanel2.setLayout(layout);
            this.jPanel2.add((Component)this.getBtnNuevo(), null);
            this.jPanel2.add((Component)this.getBtnAbrir(), null);
            this.jPanel2.add((Component)this.getBtnRenombrar(), null);
            this.jPanel2.add((Component)this.getBtnBorrar(), null);
            this.jPanel2.add((Component)this.getBtnPropiedades(), null);
        }
        return this.jPanel2;
    }

    private JButton getBtnNuevo() {
        if (this.btnNuevo == null) {
            this.btnNuevo = this.manager.createJButton();
            this.btnNuevo.setName("btnNuevo");
            this.btnNuevo.setText(PluginServices.getText((Object)this, (String)"nuevo"));
            this.btnNuevo.setMargin(new Insets(2, 2, 2, 2));
            this.btnNuevo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ProjectWindow2_OLD.this.newProjectDocument();
                    }
                    catch (Exception e1) {
                        NotificationManager.addError((String)e1.getLocalizedMessage(), (Throwable)e1);
                    }
                }
            });
        }
        return this.btnNuevo;
    }

    private JButton getBtnPropiedades() {
        if (this.btnPropiedades == null) {
            this.btnPropiedades = this.manager.createJButton();
            this.btnPropiedades.setText(PluginServices.getText((Object)this, (String)"propiedades"));
            this.btnPropiedades.setName("btnPropiedades");
            this.btnPropiedades.setEnabled(false);
            this.btnPropiedades.setMargin(new Insets(2, 2, 2, 2));
            this.btnPropiedades.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectWindow2_OLD.this.propiedades();
                }
            });
        }
        return this.btnPropiedades;
    }

    private JButton getBtnAbrir() {
        if (this.btnAbrir == null) {
            this.btnAbrir = this.manager.createJButton();
            this.btnAbrir.setName("btnAbrir");
            this.btnAbrir.setText(PluginServices.getText((Object)this, (String)"abrir"));
            this.btnAbrir.setEnabled(false);
            this.btnAbrir.setMargin(new Insets(2, 2, 2, 2));
            this.btnAbrir.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectWindow2_OLD.this.abrir();
                }
            });
        }
        return this.btnAbrir;
    }

    private JButton getBtnBorrar() {
        if (this.btnBorrar == null) {
            this.btnBorrar = this.manager.createJButton();
            this.btnBorrar.setText(PluginServices.getText((Object)this, (String)"borrar"));
            this.btnBorrar.setName("btnBorrar");
            this.btnBorrar.setEnabled(false);
            this.btnBorrar.setMargin(new Insets(2, 2, 2, 2));
            this.btnBorrar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectWindow2_OLD.this.borrar();
                }
            });
        }
        return this.btnBorrar;
    }

    private JButton getBtnRenombrar() {
        if (this.btnRenombrar == null) {
            this.btnRenombrar = this.manager.createJButton();
            this.btnRenombrar.setName("btnRenombrar");
            this.btnRenombrar.setText(PluginServices.getText((Object)this, (String)"renombrar"));
            this.btnRenombrar.setEnabled(false);
            this.btnRenombrar.setMargin(new Insets(2, 2, 2, 2));
            this.btnRenombrar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProjectWindow2_OLD.this.renombrar();
                }
            });
        }
        return this.btnRenombrar;
    }

    private JPanel getPropertiesPanel() {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 5, 0, 5);
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            this.propertiesPanel.add((Component)this.getJLabel(), c);
            c.fill = 2;
            c.weightx = 1.0;
            c.gridx = 1;
            this.propertiesPanel.add((Component)this.getLblNombreSesion(), c);
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 0;
            c.weightx = 0.0;
            this.propertiesPanel.add((Component)this.getJLabel1(), c);
            c.fill = 2;
            c.weightx = 1.0;
            c.gridx = 1;
            this.propertiesPanel.add((Component)this.getLblGuardado(), c);
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 0;
            c.weightx = 0.0;
            this.propertiesPanel.add((Component)this.getJLabel2(), c);
            c.fill = 2;
            c.weightx = 1.0;
            c.gridx = 1;
            this.propertiesPanel.add((Component)this.getLblFecha(), c);
            c.gridx = 0;
            c.gridwidth = 2;
            c.gridy = 4;
            c.fill = 2;
            c.anchor = 13;
            this.propertiesPanel.add((Component)this.getProjectsButtonPanel(), c);
            this.propertiesPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"propiedades_sesion"), 0, 0, null, null));
        }
        return this.propertiesPanel;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText(PluginServices.getText((Object)this, (String)"nombre_sesion") + ":");
        }
        return this.jLabel;
    }

    private JLabel getLblNombreSesion() {
        if (this.lblNombreSesion == null) {
            this.lblNombreSesion = new JLabel();
            this.lblNombreSesion.setText("");
            this.lblNombreSesion.setName("lblNombreSesion");
            this.lblNombreSesion.setAutoscrolls(true);
        }
        return this.lblNombreSesion;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(PluginServices.getText((Object)this, (String)"guardado") + ":");
        }
        return this.jLabel1;
    }

    private JLabel getLblGuardado() {
        if (this.lblGuardado == null) {
            this.lblGuardado = new JLabel();
            this.lblGuardado.setText("");
            this.lblGuardado.setAutoscrolls(true);
        }
        return this.lblGuardado;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText(PluginServices.getText((Object)this, (String)"creation_date") + ":");
        }
        return this.jLabel2;
    }

    private JLabel getLblFecha() {
        if (this.lblFecha == null) {
            this.lblFecha = new JLabel();
            this.lblFecha.setText("");
            this.lblFecha.setAutoscrolls(true);
        }
        return this.lblFecha;
    }

    private JButton getBtnImportar() {
        if (this.btnImportar == null) {
            this.btnImportar = this.manager.createJButton();
            this.btnImportar.setPreferredSize(new Dimension(80, 23));
            this.btnImportar.setText(PluginServices.getText((Object)this, (String)"importar"));
            this.btnImportar.setName("btnImportar");
            this.btnImportar.setMargin(new Insets(2, 2, 2, 2));
        }
        return this.btnImportar;
    }

    private JButton getBtnExportar() {
        if (this.btnExportar == null) {
            this.btnExportar = this.manager.createJButton();
            this.btnExportar.setPreferredSize(new Dimension(80, 23));
            this.btnExportar.setText(PluginServices.getText((Object)this, (String)"exportar"));
            this.btnExportar.setName("btnExportar");
            this.btnExportar.setMargin(new Insets(2, 2, 2, 2));
        }
        return this.btnExportar;
    }

    private JButton getBtnEditar() {
        if (this.btnEditar == null) {
            this.btnEditar = this.manager.createJButton();
            this.btnEditar.setPreferredSize(new Dimension(80, 23));
            this.btnEditar.setText(PluginServices.getText((Object)this, (String)"propiedades"));
            this.btnEditar.setName("btnEditar");
            this.btnEditar.setMargin(new Insets(2, 2, 2, 2));
            this.btnEditar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    WindowManager winmgr = ToolsSwingLocator.getWindowManager();
                    winmgr.showWindow((JComponent)((Object)new ProjectProperties(ProjectWindow2_OLD.this.project)), i18nManager.getTranslation("project_properties"), WindowManager.MODE.WINDOW);
                    ProjectWindow2_OLD.this.refreshProperties();
                }
            });
        }
        return this.btnEditar;
    }

    private JScrollPane getDocumentsScrollPane() {
        if (this.documentsScrollPane == null) {
            this.documentsScrollPane = new JScrollPane();
            this.documentsScrollPane.setViewportView(this.getDocumentsList());
            this.documentsScrollPane.setPreferredSize(new Dimension(200, 100));
            this.documentsScrollPane.setVerticalScrollBarPolicy(20);
        }
        return this.documentsScrollPane;
    }

    public Object getWindowModel() {
        return this.project;
    }

    public Project getProject() {
        return this.project;
    }

    public WindowInfo getWindowInfo() {
        if (this.m_viewInfo == null) {
            this.m_viewInfo = new WindowInfo(3);
            this.m_viewInfo.setWidth(this.getWidth());
            this.m_viewInfo.setHeight(this.getHeight());
            int w = this.getPreferredSize().width;
            if (w < 450) {
                w = 450;
            }
            this.m_viewInfo.setNormalWidth(w);
            this.m_viewInfo.setNormalHeight(this.getPreferredSize().height);
            this.m_viewInfo.setMinimumSize(this.getPreferredSize());
            this.m_viewInfo.setTitle(PluginServices.getText((Object)this, (String)"_Project_manager"));
        }
        return this.m_viewInfo;
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectWindow2_OLD.this.propertyChange(evt);
                }
            });
            return;
        }
        this.refreshControls();
    }

    private JPanel getProjectsButtonPanel() {
        if (this.projectButtonsPanel == null) {
            this.projectButtonsPanel = new JPanel();
            this.projectButtonsPanel.setLayout(new FlowLayout(2));
            this.projectButtonsPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            this.projectButtonsPanel.add((Component)this.getBtnEditar(), null);
        }
        return this.projectButtonsPanel;
    }

    public Object getWindowProfile() {
        return WindowInfo.PROJECT_PROFILE;
    }

    public void update(Observable observable, Object notification) {
        if (observable instanceof ProjectManager) {
            this.refreshDocuments();
        }
    }

    private void refreshDocuments() {
        this.btnsDocuments = null;
        this.documentTypesList.removeAll();
        Enumeration<AbstractButton> buttons = this.grupo.getElements();
        while (buttons.hasMoreElements()) {
            this.grupo.remove(buttons.nextElement());
        }
        JRadioButton[] btnDocuments = this.getBtnDocumentTypes();
        for (int i = 0; i < btnDocuments.length; ++i) {
            this.grupo.add(btnDocuments[i]);
        }
        if (btnDocuments.length > 0) {
            btnDocuments[0].setSelected(true);
        }
        this.fillDocumentTypeButtons();
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.btnNuevo.setText(i18nManager.getTranslation("nuevo"));
        this.btnPropiedades.setText(i18nManager.getTranslation("propiedades"));
        this.btnAbrir.setText(i18nManager.getTranslation("abrir"));
        this.btnBorrar.setText(i18nManager.getTranslation("borrar"));
        this.btnRenombrar.setText(i18nManager.getTranslation("renombrar"));
        this.jLabel.setText(i18nManager.getTranslation("nombre_sesion") + ":");
        this.jLabel1.setText(i18nManager.getTranslation("guardado") + ":");
        this.jLabel2.setText(i18nManager.getTranslation("creation_date") + ":");
        this.btnEditar.setText(i18nManager.getTranslation("propiedades"));
        this.m_viewInfo.setTitle(i18nManager.getTranslation("_Project_manager"));
        TitledBorder border = null;
        border = (TitledBorder)this.propertiesPanel.getBorder();
        border.setTitle(i18nManager.getTranslation("propiedades_sesion"));
        border = (TitledBorder)this.documentTypes.getBorder();
        border.setTitle(i18nManager.getTranslation("tipos_de_documentos"));
        border = (TitledBorder)this.documentsPanel.getBorder();
        border.setTitle(i18nManager.getTranslation("documentos_existentes"));
        this.refreshList();
    }

    public Object getProperty(String name) {
        return this.propertiesHelper.getProperty(name);
    }

    public void setProperty(String name, Object value) {
        this.propertiesHelper.setProperty(name, value);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesHelper.getProperties();
    }
}

