/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.dynformfield.linkforeingkeywgs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cresques.cts.IProjection;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionUtils;
import org.gvsig.featureform.swing.FeaturesFormContext;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AbstractPointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class JDynFormFieldForeingKeyWGS
extends AbstractJDynFormField
implements JDynFormField {
    private Object assignedValue = null;
    private Object value = null;
    private Feature relatedFeature = null;
    private JTextComponent txtDescription = null;
    private JToggleButton btnLinkGraphically = null;
    private JButton btnLink = null;
    private JButton btnUnlink = null;
    private JButton btnEdit = null;
    private MapControl mapControl;
    private String previosTool;
    private Color colorok;

    public JDynFormFieldForeingKeyWGS(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        if (value != null) {
            this.assignedValue = (DynObject)value;
        }
        this.colorok = Color.white;
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponentIfNeed() {
        if (this.contents == null) {
            this.initComponent();
        }
    }

    public void initComponent() {
        DynFormSPIManager.ComponentsFactory components = this.getComponentsFactory();
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JDynFormFieldForeingKeyWGS.this.fireFieldEnterEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JDynFormFieldForeingKeyWGS.this.fireFieldExitEvent();
            }
        };
        this.txtDescription = components.getJTextField(this.getDefinition(), null);
        if (this.txtDescription == null) {
            this.txtDescription = new JTextField();
        }
        this.colorok = this.txtDescription.getBackground();
        this.btnLinkGraphically = components.getJToggleButton(this.getDefinition(), "LinkGraphical");
        if (this.btnLinkGraphically == null) {
            this.btnLinkGraphically = new JToggleButton();
        }
        this.btnLink = components.getJButton(this.getDefinition(), "Link");
        if (this.btnLink == null) {
            this.btnLink = new JButton();
        }
        this.btnUnlink = components.getJButton(this.getDefinition(), "Unlink");
        if (this.btnUnlink == null) {
            this.btnUnlink = new JButton();
        }
        this.btnEdit = components.getJButton(this.getDefinition(), "Edit");
        if (this.btnEdit == null) {
            this.btnEdit = new JButton();
        }
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnLinkGraphically, (String)"_Select_related_item_graphically", (String)"selection-simple-select", ae -> this.doLinkGraphically(this.btnLinkGraphically.isSelected()), (FocusListener)focusListener);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnLink, (String)"_Select_related_item", (String)"picker-foreingkey-link", ae -> this.doLink(), (FocusListener)focusListener);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnUnlink, (String)"_Remove_relation", (String)"picker-foreingkey-unlink", ae -> this.doUnlink(), (FocusListener)focusListener);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnEdit, (String)"_See_related_item", (String)"picker-foreingkey-showform", ae -> this.doEdit(), (FocusListener)focusListener);
        this.btnLinkGraphically.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                JDynFormFieldForeingKeyWGS.this.doLinkGraphically(false);
            }
        });
        this.btnLinkGraphically.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                JDynFormFieldForeingKeyWGS.this.doLinkGraphically(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.txtDescription.setText("                        ");
        this.txtDescription.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JDynFormFieldForeingKeyWGS.this.fireFieldEnterEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JDynFormFieldForeingKeyWGS.this.fireFieldExitEvent();
            }
        });
        this.txtDescription.setEditable(false);
        boolean enabled = !this.isReadOnly();
        this.btnEdit.setEnabled(enabled);
        this.btnLink.setEnabled(enabled);
        this.btnUnlink.setEnabled(enabled);
        this.btnLinkGraphically.setEnabled(enabled);
        JPanel panel = new JPanel();
        if (!components.containsJTextField(this.getDefinition(), null)) {
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            panel.add((Component)this.txtDescription, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 2;
            c.gridy = 0;
            c.weightx = 0.0;
            panel.add((Component)this.btnLinkGraphically, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 3;
            c.gridy = 0;
            c.weightx = 0.0;
            panel.add((Component)this.btnLink, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 4;
            c.gridy = 0;
            c.weightx = 0.0;
            panel.add((Component)this.btnUnlink, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 5;
            c.gridy = 0;
            c.weightx = 0.0;
            panel.add((Component)this.btnEdit, c);
        }
        this.contents = panel;
        this.setValue(this.assignedValue);
    }

    private ForeingKey getForeingKey() {
        JDynForm.DynFormContext context = this.getForm().getContext();
        if (!(context instanceof FeaturesFormContext)) {
            return null;
        }
        FeatureType featureType = ((FeaturesFormContext)context).getFeatureType();
        if (featureType == null) {
            return null;
        }
        FeatureAttributeDescriptor attribute = featureType.getAttributeDescriptor(this.getName());
        if (attribute == null) {
            return null;
        }
        ForeingKey foreingKey = attribute.getForeingKey();
        return foreingKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLink() {
        ForeingKey foreingKey = this.getForeingKey();
        if (foreingKey == null) {
            return;
        }
        ForeingKey.ContextForeingKey context = foreingKey.createContext();
        try {
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            FeatureStoreSearchPanel searchPanel = dataSwingManager.createFeatureStoreSearchPanel(foreingKey.getFeatureStore(context));
            searchPanel.setFilterOnlyMode(true);
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            ToolsSwingUtils.ensureHeightWitdh((org.gvsig.tools.swing.api.Component)searchPanel, (int)0, (float)0.75f, (float)0.75f, (float)0.85f, (float)0.85f);
            Dialog dialog = winManager.createDialog(searchPanel.asJComponent(), "Select", "Select the '" + this.getLabel() + "'.", 3);
            dialog.setButtonEnabled(1, this.btnUnlink.isEnabled());
            dialog.addActionListener(e -> {
                Feature feature;
                if (dialog.getAction() == 1 && (feature = searchPanel.getLastSelectedFeature()) != null) {
                    this.setEditedValue(foreingKey.getCode(context, feature));
                    this.relatedFeature = feature;
                    this.fireFieldChangedEvent();
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show selector", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)context);
        }
    }

    public Feature getRelatedFeature() {
        try {
            if (this.relatedFeature != null) {
                return this.relatedFeature;
            }
            ForeingKey foreingKey = this.getForeingKey();
            if (foreingKey == null) {
                return null;
            }
            this.relatedFeature = foreingKey.getFeature(null, this.value);
            return this.relatedFeature;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve related feature from '" + this.value + "'.", (Throwable)ex);
            return null;
        }
    }

    private void doUnlink() {
        this.setEditedValue(null);
        this.fireFieldChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEdit() {
        if (this.value == null) {
            return;
        }
        ForeingKey foreingKey = this.getForeingKey();
        if (foreingKey == null) {
            return;
        }
        ForeingKey.ContextForeingKey context = foreingKey.createContext();
        try {
            this.btnEdit.setEnabled(false);
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            FeatureQuery query = foreingKey.getQuery(context, this.value);
            JFeaturesForm form = dataSwingManager.createJFeaturesForm(foreingKey.getFeatureStore(context));
            form.setQuery(query);
            form.showForm(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show linked form", (Throwable)ex);
        }
        finally {
            this.btnEdit.setEnabled(true);
            DisposeUtils.disposeQuietly((Disposable)context);
        }
    }

    private String getDescription() {
        if (this.value == null) {
            return null;
        }
        try {
            ForeingKey foreingKey = this.getForeingKey();
            if (foreingKey == null) {
                return null;
            }
            String description = foreingKey.getLabel(null, this.value);
            return description;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setReadOnly(boolean readonly) {
        this.initComponentIfNeed();
        this.readOnly = readonly;
        boolean editable = !readonly;
        JComponent theJLabel = this.getJLabel();
        if (this.jlabel != null) {
            this.jlabel.setEnabled(editable);
        } else if (theJLabel != null) {
            theJLabel.setEnabled(editable);
        }
        this.txtDescription.setEditable(false);
        this.btnEdit.setEnabled(true);
        this.btnLink.setEnabled(true);
        this.btnUnlink.setEnabled(editable);
        this.btnLinkGraphically.setEnabled(editable);
        this.setReadOnlyButtonsOfEvents(readonly);
    }

    public void setValue(Object value) {
        this.setEditedValue(value);
        this.assignedValue = value;
    }

    public void setEditedValue(Object value) {
        this.initComponentIfNeed();
        if (value == null) {
            this.value = null;
            this.txtDescription.setText("");
            return;
        }
        this.problemIndicator().clear();
        this.value = value;
        String description = this.getDescription();
        if (description == null) {
            this.txtDescription.setText(Objects.toString(value, ""));
            this.txtDescription.setBackground(ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor());
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.problemIndicator().set(i18n.getTranslation("_Related_feature_not_found"));
        } else {
            this.txtDescription.setText(Objects.toString(description));
            this.txtDescription.setBackground(this.colorok);
        }
        this.relatedFeature = null;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasValidValue() {
        return true;
    }

    public void clear() {
        this.setValue(null);
    }

    public boolean isModified() {
        return !Objects.equals(this.value, this.getAssignedValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLinkGraphically(boolean isSelected) {
        ForeingKey foreingKey = this.getForeingKey();
        if (foreingKey == null) {
            LOGGER.warn("Can't retrieve foreignkey information");
            return;
        }
        ForeingKey.ContextForeingKey context = foreingKey.createContext();
        try {
            if (isSelected) {
                FeatureStore store = foreingKey.getFeatureStore(context);
                Pair<MapControl, FLyrVect> mapControlAndLayer = this.findMapControl(store);
                if (mapControlAndLayer != null) {
                    String s;
                    this.mapControl = (MapControl)mapControlAndLayer.getLeft();
                    if (!this.mapControl.hasTool("foreingkey-capture")) {
                        ForeignkeyCaptureBehavior captureTool = new ForeignkeyCaptureBehavior(this.mapControl);
                        this.mapControl.addBehavior("foreingkey-capture", (Behavior)captureTool);
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)(s = this.mapControl.getCurrentTool()), (CharSequence)"foreingkey-capture")) {
                        this.previosTool = s;
                    }
                    this.mapControl.setTool("foreingkey-capture");
                    Behavior captureTool = this.mapControl.getCurrentMapTool();
                    if (captureTool instanceof ForeignkeyCaptureBehavior) {
                        ((ForeignkeyCaptureBehavior)captureTool).setField(this);
                        ((ForeignkeyCaptureBehavior)captureTool).setLayer((FLyrVect)mapControlAndLayer.getRight());
                    }
                    this.getForm().message("Activada la seleccion grafica de '" + this.getDefinition().getLabel() + "'.");
                } else {
                    ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                    dialogs.messageDialog("No se ha encontrado la tabla '" + store.getName() + "' en la Vista activa.", "Selector grafico", 1);
                    this.mapControl = null;
                    this.btnLinkGraphically.setSelected(false);
                }
            } else {
                if (this.mapControl != null) {
                    if (StringUtils.isBlank((CharSequence)this.previosTool)) {
                        this.mapControl.setTool("pointSelection");
                    } else {
                        this.mapControl.setTool(this.previosTool);
                    }
                }
                this.getForm().message("Desactivada la seleccion grafica.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't active/deactive foreingkey grafical selection", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)context);
        }
    }

    private Pair<MapControl, FLyrVect> findMapControl(FeatureStore store) {
        if (store == null) {
            return null;
        }
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return null;
        }
        DataStoreParameters storeParams = store.getParameters();
        if (storeParams == null) {
            return null;
        }
        MapControl theMapControl = view.getMapControl();
        MapContext mapContext = theMapControl.getMapContext();
        for (FLayer layer : mapContext.getLayers().deepiterable()) {
            FeatureStore layerStore;
            if (!(layer instanceof FLyrVect) || (layerStore = ((FLyrVect)layer).getFeatureStore()) == null || !layerStore.getParameters().isTheSameStore(storeParams)) continue;
            return new ImmutablePair((Object)theMapControl, (Object)((FLyrVect)layer));
        }
        return null;
    }

    private static class ForeignkeyCaptureBehavior
    extends CompoundBehavior {
        ForeignkeyCaptureListener foreignkeyCaptureListener;

        public ForeignkeyCaptureBehavior(MapControl mapControl) {
            super(new Behavior[0]);
            this.foreignkeyCaptureListener = new ForeignkeyCaptureListener(mapControl);
            this.addMapBehavior((Behavior)new PointBehavior((PointListener)this.foreignkeyCaptureListener), true);
            this.addMapBehavior((Behavior)new RectangleBehavior((RectangleListener)this.foreignkeyCaptureListener), true);
        }

        public Image getImageCursor() {
            return this.foreignkeyCaptureListener.getImageCursor();
        }

        public ForeignkeyCaptureListener getListener() {
            return this.foreignkeyCaptureListener;
        }

        public void setLayer(FLyrVect layer) {
            this.foreignkeyCaptureListener.setLayer(layer);
        }

        public void setField(JDynFormFieldForeingKeyWGS field) {
            this.foreignkeyCaptureListener.setField(field);
        }
    }

    private static class ForeignkeyCaptureListener
    extends AbstractPointListener
    implements RectangleListener {
        private FLyrVect layer;
        protected MapControl mapControl;
        private JDynFormFieldForeingKeyWGS field;

        private ForeignkeyCaptureListener(MapControl mapControl) {
            this.mapControl = mapControl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putValueInFormField(Feature f) throws BehaviorException {
            if (f == null) {
                return;
            }
            ForeingKey foreingKey = this.field.getForeingKey();
            if (foreingKey == null) {
                return;
            }
            ForeingKey.ContextForeingKey context = foreingKey.createContext();
            try {
                this.field.setEditedValue(foreingKey.getCode(context, f));
                this.field.relatedFeature = f;
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)context);
            }
            this.field.fireFieldChangedEvent();
        }

        public void setLayer(FLyrVect layer) {
            this.layer = layer;
        }

        public FLyrVect getLayer() {
            return this.layer;
        }

        public void setField(JDynFormFieldForeingKeyWGS field) {
            this.field = field;
        }

        public void point(PointEvent e) throws BehaviorException {
            MouseEvent mouseEvent = e.getEvent();
            if ((mouseEvent.getModifiersEx() & 0x23C0) != 0 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            String layerName = "";
            try {
                FLyrVect layer = this.getLayer();
                layerName = layer.getName();
                ViewPort vp = this.mapControl.getViewPort();
                Point point = vp.convertToMapPoint(e.getPoint());
                double tolerance = vp.toMapDistance(layer.getDefaultTolerance());
                FeatureQuery query = this.queryByPoint(point, tolerance);
                this.search(layer, query);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't get information from point on the layer " + layerName, (Throwable)ex);
            }
        }

        private FeatureQuery queryByPoint(Point point, double tol) throws CreateGeometryException, DataException {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            Circle circle = (Circle)manager.create(11, 0);
            circle.setPoints(point, tol);
            FLyrVect currentLayer = this.getLayer();
            if (currentLayer == null) {
                return null;
            }
            FeatureStore featureStore = currentLayer.getFeatureStore();
            FeatureQuery featureQuery = featureStore.createFeatureQuery();
            FeatureType featureType = featureStore.getDefaultFeatureType();
            featureQuery.setFeatureType(featureType);
            Geometry query_geo = currentLayer.transformToSourceCRS((Geometry)circle, true);
            IProjection query_proj = currentLayer.getMapContext().getProjection();
            if (currentLayer.getCoordTrans() != null) {
                query_proj = currentLayer.getCoordTrans().getPOrig();
            }
            Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(query_geo.getEnvelope(), query_proj, featureStore);
            featureQuery.setFilter(iee);
            featureQuery.retrievesAllAttributes();
            return featureQuery;
        }

        public void rectangle(EnvelopeEvent e) throws BehaviorException {
            MouseEvent mouseEvent = e.getEvent();
            if ((mouseEvent.getModifiersEx() & 0x23C0) != 0 || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            String layerName = "";
            try {
                FeatureQuery query;
                FLyrVect layer = this.getLayer();
                layerName = layer.getName();
                Geometry geom = e.getWorldCoordRect().getGeometry();
                if (geom instanceof Point) {
                    ViewPort vp = this.mapControl.getViewPort();
                    double tolerance = vp.toMapDistance(layer.getDefaultTolerance());
                    query = this.queryByPoint((Point)geom, tolerance);
                } else {
                    FeatureStore store = layer.getFeatureStore();
                    FeatureType featureType = store.getDefaultFeatureTypeQuietly();
                    GeometryExpressionBuilder builder = GeometryExpressionUtils.createExpressionBuilder();
                    String filter = builder.ST_Intersects((ExpressionBuilder.Value)builder.column(featureType.getDefaultGeometryAttributeName()), (ExpressionBuilder.Value)builder.geometry(e.getWorldCoordRect().getGeometry())).toString();
                    query = store.createFeatureQuery(filter);
                }
                this.search(layer, query);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't get information from point on the layer " + layerName, (Throwable)ex);
            }
        }

        private void search(FLyrVect layer, FeatureQuery query) {
            if (layer == null || query == null) {
                return;
            }
            String layerName = "";
            try {
                layerName = layer.getName();
                FeatureStore featureStore = layer.getFeatureStore();
                this.putValueInFormField(featureStore.findFirst(query));
            }
            catch (Exception ex) {
                LOGGER.warn("Can't get information from point on the layer " + layerName, (Throwable)ex);
            }
        }
    }
}

